/*
 * RTC.c
 *
 * Created: 2012-03-11 12:05:33
 *  Author: tmf
 */ 

#include <avr/io.h>
#include <avr/interrupt.h>
#include <util/atomic.h>
#include "RTC.h"

ISR(RTC_OVF_vect)
{
	Timestamp++;                      //Zwiksz licznik sekund
}

static inline void wait_for_RTC_sync()
{
	while(RTC.STATUS & RTC_SYNCBUSY_bm);     //Czekaj a flaga SYNCBUSY si wyzeruje
}

void RTC_init()
{
	OSC_XOSCCTRL=OSC_XOSCSEL_32KHz_gc;	//Wybierz kwarc zegarkowy
	OSC_CTRL|=OSC_XOSCEN_bm;            //Odblokuj oscylator
	
	CLK_RTCCTRL=CLK_RTCSRC_TOSC32_gc;    //Zewntrzny kwarc 32768 Hz
	CLK_RTCCTRL|=CLK_RTCEN_bm;           //W??cz wybrany oscylator dla RTC

	RTC.PER=32768;                       //W ci?gu sekundy mamy 32768 okresw zegara
	RTC.CNT=0;
	wait_for_RTC_sync();                 //Poczekaj na synchronizacj rejestrw CNT i PER
	
	RTC.INTCTRL=RTC_OVFINTLVL_LO_gc;     //W??cz przerwania przepe?nienia, nadaj?c im niski priorytet
	wait_for_RTC_sync(); 
	PMIC_CTRL=PMIC_LOLVLEN_bm;           //Odblokuj przerwania niskiego poziomu
	
	RTC.CTRL=RTC_PRESCALER_DIV1_gc;      //Preskaler 1 - brak podzia?u	
}

uint32_t GetTimestamp()
{
	uint32_t tmp;
	ATOMIC_BLOCK(ATOMIC_RESTORESTATE)
	{
		tmp=Timestamp;
	}
	return tmp;
}

void SetTimestamp(uint32_t ats)
{
	ATOMIC_BLOCK(ATOMIC_RESTORESTATE)
	{
		Timestamp=ats;
	}
}
