/*
 * EEPROM_int.c
 *
 * Created: 2012-11-18 23:49:02
 *  Author: tmf
 */ 


#include <avr/io.h>
#include <avr/interrupt.h>
#include <avr/eeprom.h>

uint8_t *EEPROMPtr;                  //Wskanik do zapisywanego bloku
uint8_t *SRAMPtr;                    //Wskanik do danych w SRAM
volatile uint16_t EEPROMWrBytes;     //Liczba bajtw do zapisu

ISR(NVM_EE_vect)
{
	eeprom_write_byte(EEPROMPtr, *SRAMPtr);
	EEPROMPtr++; SRAMPtr++;
	EEPROMWrBytes--;
	if(EEPROMWrBytes==0)
	{
		NVM_INTCTRL=NVM_EELVL_OFF_gc; //Wycz przerwania
		return; //Wszystko zostao zapisane
	}
}

void INT_init()
{
	PMIC_CTRL|=PMIC_LOLVLEN_bm;     //Odblokuj przerwania niskiego poziomu
	sei();	
}

void EEPROM_write_int(uint8_t *src, uint8_t *dst, uint16_t size)
{
	while(EEPROMWrBytes); //Czekaj na zakoczenie poprzednich operacji
	EEPROMPtr=dst;
	SRAMPtr=src;
	EEPROMWrBytes=size-1;
	eeprom_write_byte(EEPROMPtr, *SRAMPtr);
	EEPROMPtr++; SRAMPtr++;
	NVM_INTCTRL=NVM_EELVL_LO_gc; //Wcz przerwania
}

char napis[12] EEMEM;

int main(void)
{
	INT_init();
	EEPROM_write_int((uint8_t*)"Test EEPROM", (uint8_t*)napis, 12);
	EEPROM_write_int((uint8_t*)"Nowy zapis", (uint8_t*)napis, 11);
    while(1)
    {
        //TODO:: Please write your application code 
    }
}