/*
 * AwariaZasilania.c
 *
 * Created: 2012-11-17 21:48:09
 *  Author: tmf
 */ 

#include <avr/io.h>
#include <avr/interrupt.h>
#include <stdbool.h>
#include <string.h>
#include <avr/eeprom.h>


typedef struct
{
	int Dane;
	int Temperatura;
	int PID_P;
	//... itd. do max 32 bajtw
} DaneStrona;

DaneStrona DaneEEPROM EEMEM __attribute__((aligned(EEPROM_PAGE_SIZE))) //Umie struktur w EEPROM wyrwnujc do granicy strony
  = {.Dane=0xaabb, .Temperatura=0xac, .PID_P=0x10};
DaneStrona DaneSRAM; //Kopia danych w SRAM

void EEPROMReg_CmdExec(NVM_CMD_t cmd)
{
	NVM.CMD=cmd;                //Polecenie kontrolera
	CPU_CCP=CCP_IOREG_gc;       //Zezwl na jego wykonanie wykonanie
	NVM.CTRLA=NVM_CMDEX_bm;     //Wykonaj polecenie
	while(NVM.STATUS & NVM_NVMBUSY_bm); //Zaczekaj a si zakoczy
}

void EEPROM_MapEn()
{
	while(NVM.STATUS & NVM_NVMBUSY_bm); //Zaczekaj na koniec poprzednich operacji NVM
	NVM_CTRLB|=NVM_EEMAPEN_bm;          //Wcz mapowanie EEPROM
}

ISR(ACA_AC0_vect, ISR_NAKED)
{
    //Wycz zbdne generatory i zmniejsz FCLK
	//Dodatkowo warto wszystkie piny ustawi jako wejcia
	//Rozpoczynamy zapis zmiennych do EEPROM
	EEPROM_MapEn();          //Wcz mapowanie EEPROM
	EEPROMReg_CmdExec(NVM_CMD_ERASE_EEPROM_BUFFER_gc); //Skasuj bufor EEPROM - ewentualne wczeniejsze zapisy/odczyty bd bez znaczenia
	NVM.ADDR0=(size_t)&DaneEEPROM;
	NVM.ADDR1=(size_t)&DaneEEPROM >> 8;
	NVM.ADDR2=0;
	memcpy((void*)((int)&DaneEEPROM + MAPPED_EEPROM_START), &DaneSRAM, sizeof(DaneStrona)); //Skopiuj dane
	EEPROMReg_CmdExec(NVM_CMD_ERASE_WRITE_EEPROM_PAGE_gc); //Zapisz stron
	while(1); //Ju nic wicej nie robimy
}

void AC_init()
{
	ACA_CTRLB=63; //Napicie skalera - Vcc
	ACA_AC0MUXCTRL=AC_MUXPOS_PIN0_gc | AC_MUXNEG_SCALER_gc;
	ACA_AC0CTRL=AC_INTMODE_FALLING_gc | AC_INTLVL_HI_gc | AC_ENABLE_bm; //Przerwania na zboczu opadajcym, wysoki priorytet
}

void INT_init()
{
	PMIC_CTRL|=PMIC_HILVLEN_bm;     //Odblokuj przerwania wysokiego poziomu
	sei();
}

void Data_init()
{
	EEPROM_MapEn();          //Wcz mapowanie EEPROM
	memcpy(&DaneSRAM, (void*)((int)&DaneEEPROM + MAPPED_EEPROM_START), sizeof(DaneStrona)); //Przy wczonym mapowaniu EEPROM jest w przestrzeni adresowej MCU
}

int main(void)
{
	Data_init();
	AC_init();
	INT_init(); //Odblokuj przerwania
	
	DaneSRAM.Dane=0x4BCD;  //Modyfikujemy odtworzon kopi danych
	DaneSRAM.PID_P=0x0211; //Zostan one automatycznie zapisane po odczeniu zasilania
	DaneSRAM.Temperatura=0x1234;
    while(1)
    {
        //TODO:: Please write your application code 
    }
}