/*
 * MEM_IO3.c
 *
 * Created: 2012-03-21 17:06:51
 *  Author: tmf
 */ 

#include <avr/io.h>

volatile uint8_t src[]={0b11111110, 0b11111101, 0b11111011, 0b11110111, 0b11101111, 0b11011111, 0b10111111, 0b01111111,
						  0b10111111, 0b11011111, 0b11101111, 0b11110111, 0b11111011, 0b11111101};

int main(void)
{
	PORTE.DIR=0xFF;          //Port E bdzie wyjciem (tam s podczone diody)
	DMA.CTRL=DMA_ENABLE_bm;  //Odblokuj kontroler DMA, round robin, bez bouble buffering

	TCC0.PER=F_CPU/1024;              //Okres 1 sekunda
	TCC0.CTRLA=TC_CLKSEL_DIV1024_gc;  //Preskaler 1
	
	EVSYS_CH0MUX=EVSYS_CHMUX_TCC0_OVF_gc;    //Timer C0 generuje zdarzenia overflow na kanale CH0
	
	//Kopiuj src do PORTE.OUT
	DMA.CH0.ADDRCTRL=DMA_CH_SRCRELOAD_BLOCK_gc | DMA_CH_SRCDIR_INC_gc | DMA_CH_DESTDIR_FIXED_gc | DMA_CH_DESTRELOAD_BURST_gc; //Zwikszamy adres rda, adres przeznaczenia stay, reload adresu co blok
	DMA.CH0.TRFCNT=sizeof(src);                 //Blok ma dugo tablicy src
	DMA.CH0.SRCADDR0=(uint16_t)&src & 0xFF;
	DMA.CH0.SRCADDR1=(uint16_t)&src >>8;
	DMA.CH0.SRCADDR2=0;                        //rdem danych jest tablica src
	DMA.CH0.DESTADDR0=(uint16_t)&PORTE.OUT & 0xFF;
	DMA.CH0.DESTADDR1=(uint16_t)&PORTE.OUT >> 8;
	DMA.CH0.DESTADDR2=0;                       
	DMA.CH0.TRIGSRC=DMA_CH_TRIGSRC_EVSYS_CH0_gc; //DMA_CH_TRIGSRC_TCC0_CCA_gc;  //Kana CH0 wyzwoli DMA
	DMA.CH0.CTRLA=DMA_CH_ENABLE_bm | DMA_CH_BURSTLEN_1BYTE_gc | DMA_CH_SINGLE_bm | DMA_CH_REPEAT_bm;  //Kana 0 dugo transferu 1 bajt, tryb single

    while(1) {}
}