/*
 * Ultradzwieki.c
 *
 * Created: 2013-01-31 21:23:04
 *  Author: tmf
 */ 


#include <avr/io.h>
#include <stdbool.h>
#include <avr/pgmspace.h>
#include <util/delay.h>
#include <avr/interrupt.h>

#include <string.h>
#include "ADV.h"
#include "usart.h"

const ADV_Start_cfg_t cfg_start PROGMEM = {{ADV_PKT_HEADER, sizeof(ADV_Start_cfg_t), ADV_PKT_CONFIG_START}, 1, {0, 0x06}};
const ADV_Stream_cfg_t cfg_stream PROGMEM = {{ADV_PKT_HEADER, sizeof(ADV_Stream_cfg_t), ADV_PKT_CONFIG_STREAM}, 1, 1000000UL, 1, "Pomiar", {0, 0x06}};
const ADV_Data_cfg_t cfg_Data PROGMEM = {{ADV_PKT_HEADER, sizeof(ADV_Data_cfg_t), ADV_PKT_CONFIG_FIELD}, 1, 1, 4, FIELD_FORMAT_UNSIGNED, 0, 300, "cm", "Dystans", {0, 0x06}};
const ADV_End_cfg_t cfg_End PROGMEM = {{ADV_PKT_HEADER, sizeof(ADV_End_cfg_t), ADV_PKT_CONFIG_END}, 1, {0, 0x06}};

ADV_Data_uint_pkt_t Data = {{ADV_PKT_HEADER, sizeof(ADV_Data_uint_pkt_t), ADV_PKT_DATA}, 1, 0, 0, {0, 0x06}};
	
void USART_init()
{
    PORTC_OUTSET=PIN3_bm;
	PORTC_DIRSET=PIN3_bm;  //Pin TxD musi by wyjciem	
	USARTC0.CTRLB=USART_TXEN_bm;   //Wcz nadajnik USART
	USARTC0.CTRLC=USART_CHSIZE_8BIT_gc;  //Ramka 8 bitw, bez parzystoci, 1 bit stopu
	usart_set_baudrate(&USARTC0, 115200, F_CPU);
}

void ADV_init()
{
	USART_send_block_F(&USARTC0, (uint8_t*)&cfg_start, sizeof(ADV_Start_cfg_t));   //Wylij konfiguracj
	USART_send_block_F(&USARTC0, (uint8_t*)&cfg_stream, sizeof(ADV_Stream_cfg_t)); //Wylij konfiguracj strumienia
	USART_send_block_F(&USARTC0, (uint8_t*)&cfg_Data, sizeof(ADV_Data_cfg_t));     //Wylij konfiguracj danych strumienia
	USART_send_block_F(&USARTC0, (uint8_t*)&cfg_End, sizeof(ADV_End_cfg_t));       //Koniec konfiguracji
}

ISR(TCD0_CCA_vect)
{
	uint16_t tmp=TCD0_CCA;
    TCD0.CTRLA=TC_CLKSEL_OFF_gc;   //Pomiar dokonany, timer niepotrzebny
    Data.Data=tmp*34342/2/2/1000000UL;//Oblicz odlego
    Data.Timestamp++;
    USART_send_block(&USARTC0, (uint8_t*)&Data, sizeof(ADV_Data_uint_pkt_t));
}

ISR(TCD0_OVF_vect)
{
	TCD0.CTRLA=TC_CLKSEL_OFF_gc; //Brak echa w zadanym czasie
}

void US_init()
{
	PORTD_OUTCLR=PIN3_bm; //Pin trigger
	PORTD_DIRSET=PIN3_bm;

	PORTD_PIN2CTRL=PORT_OPC_PULLUP_gc | PORT_ISC_BOTHEDGES_gc;  //Pulup na pinie odbiornika IR, zbocza wywouj zdarzenia
	EVSYS_CH1MUX=EVSYS_CHMUX_PORTD_PIN2_gc;                     //Transmitowane przez kana 1
	TCD0.CTRLB=TC_WGMODE_NORMAL_gc | TC0_CCAEN_bm;              //Tryb pracy normalny
	TCD0.CTRLD=TC_EVSEL_CH1_gc | TC_EVACT_PW_gc;                //Kana 1 wyzwala pomiar szerokoci
	TCD0.INTCTRLB=TC_CCAINTLVL_LO_gc;      //Wcz przerwanie CCA
	TCD0.INTCTRLA=TC_OVFINTLVL_LO_gc;      //Wcz przerwanie nadmiaru
	PMIC_CTRL=PMIC_LOLVLEN_bm;             //Odblokuj przerwania niskiego poziomu
}

/*void Gen_pulse()
{
    PORTD_OUTSET=PIN3_bm;
    _delay_us(12);
    PORTD_OUTCLR=PIN3_bm;
    TCD0.CTRLA=TC_CLKSEL_DIV1_gc;	
}*/

void Gen_pulse()
{
	USARTD0_DATA=1;  //Wygeneruj impuls >10 us
	TCD0.CTRLA=TC_CLKSEL_DIV1_gc;
}

void USART_Pulse_init()
{
	PORTD.OUTSET=PIN3_bm; //Pin trigger
	PORTD.DIRSET=PIN3_bm;
	PORTD.PIN3CTRL=PORT_INVEN_bm;  //Negujemy stan portu - stanem spoczynkowym bdzie 0
	USARTD0.CTRLB=USART_TXEN_bm;   //Wcz nadajnik USART
	USARTD0.CTRLC=USART_CHSIZE_8BIT_gc;  //Ramka 8 bitw, bez parzystoci, 1 bit stopu
	usart_set_baudrate(&USARTD0, 115200, F_CPU);
}

int main(void)
{
	USART_init();
	USART_Pulse_init();
	ADV_init();
	US_init();
	sei();
	
    while(1)
    {
        Gen_pulse();
		_delay_ms(60);
    }
}