/*
 * Decompiled with CFR 0.152.
 */
package org.noos.xing.mydoggy.plaf.ui.util;

import java.awt.Color;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;

public class MutableColor
extends Color {
    protected static final double FACTOR = 0.7;
    protected int value;
    protected float[] frgbvalue = null;
    protected float[] fvalue = null;
    protected float falpha = 0.0f;
    protected ColorSpace cs = null;

    public MutableColor(int r, int g, int b) {
        super(r, g, b);
        this.value = 0xFF000000 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
        MutableColor.testColorValueRange(r, g, b, 255);
    }

    public MutableColor(Color c) {
        this(c.getRed(), c.getGreen(), c.getBlue());
    }

    public int getRed() {
        return this.getRGB() >> 16 & 0xFF;
    }

    public int getGreen() {
        return this.getRGB() >> 8 & 0xFF;
    }

    public int getBlue() {
        return this.getRGB() >> 0 & 0xFF;
    }

    public int getAlpha() {
        return this.getRGB() >> 24 & 0xFF;
    }

    public int getRGB() {
        return this.value;
    }

    public Color brighter() {
        int r = this.getRed();
        int g = this.getGreen();
        int b = this.getBlue();
        int i = 3;
        if (r == 0 && g == 0 && b == 0) {
            return new Color(i, i, i);
        }
        if (r > 0 && r < i) {
            r = i;
        }
        if (g > 0 && g < i) {
            g = i;
        }
        if (b > 0 && b < i) {
            b = i;
        }
        return new Color(Math.min((int)((double)r / 0.7), 255), Math.min((int)((double)g / 0.7), 255), Math.min((int)((double)b / 0.7), 255));
    }

    public Color darker() {
        return new Color(Math.max((int)((double)this.getRed() * 0.7), 0), Math.max((int)((double)this.getGreen() * 0.7), 0), Math.max((int)((double)this.getBlue() * 0.7), 0));
    }

    public int hashCode() {
        return this.value;
    }

    public boolean equals(Object obj) {
        if (obj instanceof MutableColor) {
            return ((MutableColor)obj).value == this.value;
        }
        if (obj instanceof Color) {
            Color c = (Color)obj;
            return this.getRed() == c.getRed() && this.getBlue() == c.getBlue() && this.getGreen() == c.getGreen() && this.getAlpha() == c.getAlpha();
        }
        return false;
    }

    public String toString() {
        return this.getClass().getName() + "[r=" + this.getRed() + ",g=" + this.getGreen() + ",b=" + this.getBlue() + "]";
    }

    public float[] getRGBComponents(float[] compArray) {
        float[] f = compArray == null ? new float[4] : compArray;
        if (this.frgbvalue == null) {
            f[0] = (float)this.getRed() / 255.0f;
            f[1] = (float)this.getGreen() / 255.0f;
            f[2] = (float)this.getBlue() / 255.0f;
            f[3] = (float)this.getAlpha() / 255.0f;
        } else {
            f[0] = this.frgbvalue[0];
            f[1] = this.frgbvalue[1];
            f[2] = this.frgbvalue[2];
            f[3] = this.falpha;
        }
        return f;
    }

    public float[] getRGBColorComponents(float[] compArray) {
        float[] f = compArray == null ? new float[3] : compArray;
        if (this.frgbvalue == null) {
            f[0] = (float)this.getRed() / 255.0f;
            f[1] = (float)this.getGreen() / 255.0f;
            f[2] = (float)this.getBlue() / 255.0f;
        } else {
            f[0] = this.frgbvalue[0];
            f[1] = this.frgbvalue[1];
            f[2] = this.frgbvalue[2];
        }
        return f;
    }

    public float[] getComponents(float[] compArray) {
        if (this.fvalue == null) {
            return this.getRGBComponents(compArray);
        }
        int n = this.fvalue.length;
        float[] f = compArray == null ? new float[n + 1] : compArray;
        System.arraycopy(this.fvalue, 0, f, 0, n);
        f[n] = this.falpha;
        return f;
    }

    public float[] getColorComponents(float[] compArray) {
        if (this.fvalue == null) {
            return this.getRGBColorComponents(compArray);
        }
        int n = this.fvalue.length;
        float[] f = compArray == null ? new float[n] : compArray;
        System.arraycopy(this.fvalue, 0, f, 0, n);
        return f;
    }

    public float[] getComponents(ColorSpace cspace, float[] compArray) {
        if (this.cs == null) {
            this.cs = ColorSpace.getInstance(1000);
        }
        float[] f = this.fvalue == null ? new float[]{(float)this.getRed() / 255.0f, (float)this.getGreen() / 255.0f, (float)this.getBlue() / 255.0f} : this.fvalue;
        float[] tmp = this.cs.toCIEXYZ(f);
        float[] tmpout = cspace.fromCIEXYZ(tmp);
        if (compArray == null) {
            compArray = new float[tmpout.length + 1];
        }
        System.arraycopy(tmpout, 0, compArray, 0, tmpout.length);
        compArray[tmpout.length] = this.fvalue == null ? (float)this.getAlpha() / 255.0f : this.falpha;
        return compArray;
    }

    public float[] getColorComponents(ColorSpace cspace, float[] compArray) {
        if (this.cs == null) {
            this.cs = ColorSpace.getInstance(1000);
        }
        float[] f = this.fvalue == null ? new float[]{(float)this.getRed() / 255.0f, (float)this.getGreen() / 255.0f, (float)this.getBlue() / 255.0f} : this.fvalue;
        float[] tmp = this.cs.toCIEXYZ(f);
        float[] tmpout = cspace.fromCIEXYZ(tmp);
        if (compArray == null) {
            return tmpout;
        }
        System.arraycopy(tmpout, 0, compArray, 0, tmpout.length);
        return compArray;
    }

    public ColorSpace getColorSpace() {
        if (this.cs == null) {
            this.cs = ColorSpace.getInstance(1000);
        }
        return this.cs;
    }

    public synchronized PaintContext createContext(ColorModel cm, Rectangle r, Rectangle2D r2d, AffineTransform xform, RenderingHints hints) {
        throw new RuntimeException("Method not supported...");
    }

    public int getTransparency() {
        int alpha = this.getAlpha();
        if (alpha == 255) {
            return 1;
        }
        if (alpha == 0) {
            return 2;
        }
        return 3;
    }

    public void setRGB(int r, int g, int b) {
        this.value = 0xFF000000 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | (b & 0xFF) << 0;
        this.frgbvalue = null;
        this.fvalue = null;
        this.falpha = 0.0f;
        this.cs = null;
    }

    public void setRGB(Color color) {
        int r = color.getRed();
        int g = color.getGreen();
        int b = color.getBlue();
        this.value = 0xFF000000 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | (b & 0xFF) << 0;
        this.frgbvalue = null;
        this.fvalue = null;
        this.falpha = 0.0f;
        this.cs = null;
    }

    private static void testColorValueRange(int r, int g, int b, int a) {
        boolean rangeError = false;
        String badComponentString = "";
        if (a < 0 || a > 255) {
            rangeError = true;
            badComponentString = badComponentString + " Alpha";
        }
        if (r < 0 || r > 255) {
            rangeError = true;
            badComponentString = badComponentString + " Red";
        }
        if (g < 0 || g > 255) {
            rangeError = true;
            badComponentString = badComponentString + " Green";
        }
        if (b < 0 || b > 255) {
            rangeError = true;
            badComponentString = badComponentString + " Blue";
        }
        if (rangeError) {
            throw new IllegalArgumentException("Color parameter outside of expected range:" + badComponentString);
        }
    }
}

