/*
 * Decompiled with CFR 0.152.
 */
package org.noos.xing.mydoggy.plaf.ui.util;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.noos.xing.mydoggy.plaf.ui.util.MutableColor;

public class GraphicsUtil {
    public static final int FROM_CENTRE_GRADIENT_ON_Y = 0;
    public static final int FROM_CENTRE_GRADIENT_ON_X = 1;
    public static final int LEFT_TO_RIGHT_GRADIENT = 2;
    public static final int RIGHT_TO_LEFT_GRADIENT = 3;
    public static final int BOTTOM_TO_UP_GRADIENT = 4;
    public static final int UP_TO_BOTTOM_GRADIENT = 5;

    public static void fillRect(Graphics g, JComponent c, Color start, Color end) {
        if (c.isOpaque()) {
            GraphicsUtil.fillRect(g, c.getBounds(), start, end, null, 0);
        }
    }

    public static void fillRect(Graphics g, Rectangle r, Color start, Color end) {
        GraphicsUtil.fillRect(g, r, start, end, null, 0);
    }

    public static void fillRect(Graphics g, Rectangle r, Color start, Color end, Shape clip, int direction) {
        switch (direction) {
            case 2: {
                GraphicsUtil.fillRect(g, r, r.x, r.y, start, r.x + r.width, r.y, end, clip);
                break;
            }
            case 3: {
                GraphicsUtil.fillRect(g, r, r.x + r.width, r.y, start, r.x, r.y, end, clip);
                break;
            }
            case 4: {
                GraphicsUtil.fillRect(g, r, r.x, r.y + r.height, start, r.x, r.y, end, clip);
                break;
            }
            case 5: {
                GraphicsUtil.fillRect(g, r, r.x, r.y, start, r.x, r.y + r.height, end, clip);
                break;
            }
            case 1: {
                Rectangle tmp = new Rectangle(r);
                tmp.width >>= 1;
                GraphicsUtil.fillRect(g, tmp, r.x, r.y, start, r.x + r.width, r.y, end, clip);
                if (r.width % 2 == 0) {
                    tmp = new Rectangle(r);
                    tmp.x += tmp.width >> 1;
                    tmp.width >>= 1;
                } else {
                    tmp = new Rectangle(r);
                    tmp.x += tmp.width >> 1;
                    tmp.width = (tmp.width >> 1) + 1;
                }
                GraphicsUtil.fillRect(g, tmp, r.x + r.width, r.y, start, r.x, r.y, end, clip);
                break;
            }
            default: {
                Rectangle tmp = new Rectangle(r);
                tmp.height >>= 1;
                GraphicsUtil.fillRect(g, tmp, r.x, r.y, start, r.x, r.y + r.height, end, clip);
                if (r.height % 2 == 0) {
                    tmp = new Rectangle(r);
                    tmp.y += tmp.height >> 1;
                    tmp.height >>= 1;
                } else {
                    tmp = new Rectangle(r);
                    tmp.y += tmp.height >> 1;
                    tmp.height = (tmp.height >> 1) + 1;
                }
                GraphicsUtil.fillRect(g, tmp, r.x, r.y + r.height, start, r.x, r.y, end, clip);
            }
        }
    }

    public static void fillRect(Graphics g, Rectangle r, float x1, float y1, Color color1, float x2, float y2, Color color2, Shape clip) {
        if (clip != null) {
            if (g instanceof Graphics2D) {
                Graphics2D g2D = (Graphics2D)g;
                g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                Paint oldPaint = g2D.getPaint();
                g2D.setPaint(new GradientPaint(x1, y1, color1, x2, y2, color2));
                g2D.fill(clip);
                g2D.setPaint(oldPaint);
            }
        } else if (g instanceof Graphics2D) {
            Graphics2D g2D = (Graphics2D)g;
            g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            Paint oldPaint = g2D.getPaint();
            g2D.setPaint(new GradientPaint(x1, y1, color1, x2, y2, color2));
            g2D.fillRect(r.x, r.y, r.width, r.height);
            g2D.setPaint(oldPaint);
        }
    }

    public static void fillRect(Graphics g, Rectangle r, BufferedImage image) {
        if (g instanceof Graphics2D) {
            Graphics2D g2D = (Graphics2D)g;
            g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            Paint oldPaint = g2D.getPaint();
            g2D.setPaint(new TexturePaint(image, r));
            g2D.fillRect(r.x, r.y, r.width, r.height);
            g2D.setPaint(oldPaint);
        }
    }

    public static void fillRectTransparently(Graphics g, Rectangle r, Shape clip, int rule, float alpha) {
        Shape oldClip = g.getClip();
        if (clip != null) {
            g.setClip(clip);
        }
        if (g instanceof Graphics2D) {
            Graphics2D g2D = (Graphics2D)g;
            g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            Composite oldComposite = g2D.getComposite();
            g2D.setComposite(AlphaComposite.getInstance(rule, alpha));
            g2D.fillRect(r.x, r.y, r.width, r.height);
            g2D.setComposite(oldComposite);
        }
        if (clip != null) {
            g.setClip(oldClip);
        }
    }

    public static void drawRect(Graphics g, int x, int y, int width, int height, int tickness) {
        for (int i = 0; i < tickness; ++i) {
            g.drawRect(x + i, y + i, width - i * 2 - 1, height - i * 2 - 1);
        }
    }

    public static void drawRoundRect(Graphics g, int x, int y, int width, int height, int tickness, int arcWidth, int arcHeight) {
        Graphics2D g2D = (Graphics2D)g;
        g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        for (int i = 0; i < tickness; ++i) {
            g.drawRoundRect(x + i, y + i, width - i * 2 - 1, height - i * 2 - 1, arcWidth, arcHeight);
        }
    }

    public static void fillRoundRect(Graphics g, int x, int y, int width, int height, int tickness, int arcWidth, int arcHeight, float alpha) {
        Graphics2D g2D = (Graphics2D)g;
        g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        for (int i = 0; i < tickness; ++i) {
            g.drawRoundRect(x + i, y + i, width - i * 2 - 1, height - i * 2 - 1, arcWidth, arcHeight);
        }
        Composite oldComposite = g2D.getComposite();
        g2D.setComposite(AlphaComposite.getInstance(3, alpha));
        g.fillRect(x + tickness, y + tickness, width - 2 * tickness, height - 2 * tickness);
        g2D.setComposite(oldComposite);
    }

    public static String clippedText(String text, FontMetrics fm, int availTextWidth) {
        if (text == null || text.equals("")) {
            return "";
        }
        int textWidth = SwingUtilities.computeStringWidth(fm, text);
        String clipString = "...";
        if (textWidth > availTextWidth) {
            int nChars;
            int totalWidth = SwingUtilities.computeStringWidth(fm, clipString);
            for (nChars = 0; nChars < text.length() && (totalWidth += fm.charWidth(text.charAt(nChars))) <= availTextWidth; ++nChars) {
            }
            text = text.substring(0, nChars) + clipString;
        }
        return text;
    }

    public static int normalizeColor(int c) {
        return c > 255 ? 255 : (c < 0 ? 0 : c);
    }

    public static Color getLinearInterpolationColor(Color color, int distance) {
        return new Color(GraphicsUtil.normalizeColor(color.getRed() + distance), GraphicsUtil.normalizeColor(color.getGreen() + distance), GraphicsUtil.normalizeColor(color.getBlue() + distance));
    }

    public static Color getInterpolatedColor(Color from, Color to, float percent) {
        int newRed = (int)(percent * (float)Math.abs(from.getRed() - to.getRed()));
        newRed = from.getRed() < to.getRed() ? to.getRed() - newRed : to.getRed() + newRed;
        int newGreen = (int)(percent * (float)Math.abs(from.getGreen() - to.getGreen()));
        newGreen = from.getGreen() < to.getGreen() ? to.getGreen() - newGreen : to.getGreen() + newGreen;
        int newBly = (int)(percent * (float)Math.abs(from.getBlue() - to.getBlue()));
        newBly = from.getBlue() < to.getBlue() ? to.getBlue() - newBly : to.getBlue() + newBly;
        return new Color(newRed, newGreen, newBly);
    }

    public static MutableColor getInterpolatedColor(MutableColor mutableColor, Color from, Color to, double percent) {
        int newRed = (int)(percent * (double)Math.abs(from.getRed() - to.getRed()));
        newRed = from.getRed() < to.getRed() ? to.getRed() - newRed : to.getRed() + newRed;
        int newGreen = (int)(percent * (double)Math.abs(from.getGreen() - to.getGreen()));
        newGreen = from.getGreen() < to.getGreen() ? to.getGreen() - newGreen : to.getGreen() + newGreen;
        int newBlu = (int)(percent * (double)Math.abs(from.getBlue() - to.getBlue()));
        newBlu = from.getBlue() < to.getBlue() ? to.getBlue() - newBlu : to.getBlue() + newBlu;
        mutableColor.setRGB(newRed, newGreen, newBlu);
        return mutableColor;
    }

    public static BufferedImage rotate(BufferedImage image, double angle) {
        double sin = Math.abs(Math.sin(angle));
        double cos = Math.abs(Math.cos(angle));
        int w = image.getWidth();
        int h = image.getHeight();
        int neww = (int)Math.floor((double)w * cos + (double)h * sin);
        int newh = (int)Math.floor((double)h * cos + (double)w * sin);
        GraphicsConfiguration gc = GraphicsUtil.getDefaultConfiguration();
        BufferedImage result = gc.createCompatibleImage(neww, newh, 3);
        Graphics2D g = result.createGraphics();
        g.translate((double)(neww - w) / 2.0, (double)(newh - h) / 2.0);
        g.rotate(angle, (double)w / 2.0, (double)h / 2.0);
        g.drawRenderedImage(image, null);
        g.dispose();
        return result;
    }

    public static Icon rotate(Icon icon, double angle) {
        GraphicsConfiguration gc = GraphicsUtil.getDefaultConfiguration();
        BufferedImage result = gc.createCompatibleImage(icon.getIconWidth(), icon.getIconHeight(), 3);
        Graphics2D g = result.createGraphics();
        icon.paintIcon(null, g, 0, 0);
        g.dispose();
        return new ImageIcon(GraphicsUtil.rotate(result, angle));
    }

    public static BufferedImage scale(BufferedImage image, int width, int height) {
        Image scaledImage = image.getScaledInstance(width, height, 4);
        GraphicsConfiguration gc = GraphicsUtil.getDefaultConfiguration();
        BufferedImage result = gc.createCompatibleImage(width, height, 3);
        Graphics2D g = result.createGraphics();
        g.drawImage(scaledImage, 0, 0, null);
        g.dispose();
        return result;
    }

    public static Image getImage(Component component, Icon icon) {
        if (icon == null) {
            return null;
        }
        if (icon instanceof ImageIcon) {
            return ((ImageIcon)icon).getImage();
        }
        BufferedImage bufferedImage = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 1);
        icon.paintIcon(component, bufferedImage.getGraphics(), 0, 0);
        return bufferedImage;
    }

    public static GraphicsConfiguration getDefaultConfiguration() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gd = ge.getDefaultScreenDevice();
        return gd.getDefaultConfiguration();
    }
}

