/*
 * Decompiled with CFR 0.152.
 */
package org.noos.xing.mydoggy.plaf.ui.look;

import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicLabelUI;
import org.noos.xing.mydoggy.ToolWindow;
import org.noos.xing.mydoggy.ToolWindowTab;
import org.noos.xing.mydoggy.plaf.cleaner.Cleaner;
import org.noos.xing.mydoggy.plaf.cleaner.CleanerProvider;
import org.noos.xing.mydoggy.plaf.ui.cmp.ToolWindowTabTitle;
import org.noos.xing.mydoggy.plaf.ui.util.SwingUtil;

public class ToolWindowTabTitleUI
extends BasicLabelUI
implements MouseListener,
Cleaner {
    protected ToolWindowTab tab;
    protected ToolWindow toolWindow;
    protected ToolWindowTabTitle toolWindowTabTitle;
    protected boolean pressed;
    protected boolean inside;

    public static ComponentUI createUI(JComponent c) {
        return new ToolWindowTabTitleUI();
    }

    public void cleanup() {
        this.uninstallUI(this.toolWindowTabTitle);
    }

    public void mousePressed(MouseEvent e) {
        this.toolWindow.setActive(true);
        if (SwingUtilities.isLeftMouseButton(e) && !this.tab.isSelected()) {
            this.pressed = true;
            this.toolWindowTabTitle.repaint();
        } else {
            this.pressed = false;
            this.toolWindowTabTitle.repaint();
        }
    }

    public void mouseReleased(MouseEvent e) {
        this.pressed = false;
        this.toolWindowTabTitle.repaint();
    }

    public void mouseEntered(MouseEvent e) {
        this.inside = true;
        this.toolWindowTabTitle.repaint();
    }

    public void mouseExited(MouseEvent e) {
        this.inside = false;
        this.toolWindowTabTitle.repaint();
    }

    public void mouseClicked(MouseEvent e) {
        if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 1) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ToolWindowTabTitleUI.this.tab.setSelected(true);
                }
            });
        }
    }

    public void installUI(JComponent c) {
        this.toolWindowTabTitle = (ToolWindowTabTitle)c;
        this.tab = this.toolWindowTabTitle.getToolWindowTab();
        this.toolWindow = this.tab.getOwner();
        super.installUI(c);
    }

    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        this.toolWindowTabTitle = null;
        this.tab = null;
        this.toolWindow = null;
    }

    protected void installDefaults(JLabel c) {
        super.installDefaults(c);
        this.inside = false;
        this.pressed = false;
        if (c.getFont() != null) {
            c.setFont(c.getFont().deriveFont(SwingUtil.getFloat("ToolWindowTabTitleUI.font.size", 12.0f)));
        }
        c.setText(this.tab.getTitle());
        c.setIcon(this.tab.getIcon());
        c.setForeground(UIManager.getColor("ToolWindowTitleBarUI.tab.foreground.unselected"));
        c.setOpaque(false);
        c.setFocusable(false);
        SwingUtil.installFont(c, "ToolWindowTabTitleUI.font");
    }

    protected void installListeners(JLabel c) {
        super.installListeners(c);
        ((CleanerProvider)((Object)this.tab)).getCleanerAggregator().addCleaner(this);
    }

    protected void uninstallListeners(JLabel c) {
        super.uninstallListeners(c);
        ((CleanerProvider)((Object)this.tab)).getCleanerAggregator().removeCleaner(this);
    }

    public void update(Graphics g, JComponent c) {
        if (this.tab.isFlashing() && this.toolWindow.isVisible()) {
            Boolean flashingState = (Boolean)SwingUtil.getClientProperty((JComponent)c.getParent(), "mydoggy.flashingState");
            if (flashingState == null || flashingState.booleanValue()) {
                this.toolWindowTabTitle.setForeground(UIManager.getColor("ToolWindowTitleBarUI.tab.foreground.selected"));
            } else {
                this.toolWindowTabTitle.setForeground(UIManager.getColor("ToolWindowTitleBarUI.tab.foreground.unselected"));
            }
        } else if (this.tab.isSelected()) {
            this.toolWindowTabTitle.setForeground(UIManager.getColor("ToolWindowTitleBarUI.tab.foreground.selected"));
        } else {
            this.toolWindowTabTitle.setForeground(UIManager.getColor("ToolWindowTitleBarUI.tab.foreground.unselected"));
        }
        super.update(g, c);
    }

    protected void paintEnabledText(JLabel l, Graphics g, String s, int textX, int textY) {
        if (this.pressed && this.inside) {
            super.paintEnabledText(l, g, s, textX + 1, textY + 1);
        } else {
            super.paintEnabledText(l, g, s, textX, textY);
        }
    }
}

