/*
 * Decompiled with CFR 0.152.
 */
package org.noos.xing.mydoggy.plaf.ui.drag;

import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.image.BufferedImage;
import javax.swing.JLayeredPane;
import javax.swing.SwingUtilities;
import org.noos.xing.mydoggy.ToolWindowAnchor;
import org.noos.xing.mydoggy.plaf.MyDoggyToolWindowManager;
import org.noos.xing.mydoggy.plaf.cleaner.Cleaner;
import org.noos.xing.mydoggy.plaf.ui.DockableDescriptor;
import org.noos.xing.mydoggy.plaf.ui.cmp.DockableDropPanel;
import org.noos.xing.mydoggy.plaf.ui.cmp.GlassPanel;
import org.noos.xing.mydoggy.plaf.ui.cmp.ToolWindowScrollBar;
import org.noos.xing.mydoggy.plaf.ui.drag.DragAndDropLock;
import org.noos.xing.mydoggy.plaf.ui.drag.DragListener;
import org.noos.xing.mydoggy.plaf.ui.util.SwingUtil;

public abstract class DragListenerAdapter
implements DragListener,
Cleaner {
    protected MyDoggyToolWindowManager manager;
    protected DockableDescriptor descriptor;
    protected BufferedImage ghostImage;
    protected BufferedImage updatedGhostImage;
    protected DockableDropPanel lastDropPanel;
    protected ToolWindowAnchor lastBarAnchor;

    protected DragListenerAdapter(DockableDescriptor descriptor) {
        this.descriptor = descriptor;
        this.manager = descriptor.getManager();
    }

    protected DragListenerAdapter(MyDoggyToolWindowManager manager) {
        this.manager = manager;
    }

    public void cleanup() {
        this.descriptor = null;
        this.manager = null;
    }

    public void dragGestureRecognized(DragGestureEvent dge) {
        this.lastDropPanel = null;
        this.lastBarAnchor = null;
    }

    public void dragMouseMoved(DragSourceDragEvent dsde) {
    }

    public void dragEnter(DragSourceDragEvent dsde) {
    }

    public void dragOver(DragSourceDragEvent dsde) {
    }

    public void dropActionChanged(DragSourceDragEvent dsde) {
    }

    public void dragExit(DragSourceEvent dse) {
    }

    public void dragDropEnd(DragSourceDropEvent dsde) {
    }

    protected boolean acquireLocks() {
        if (this.isDragEnabled()) {
            if (DragAndDropLock.isLocked()) {
                DragAndDropLock.setDragAndDropStarted(false);
                return false;
            }
            DragAndDropLock.setLocked(true);
            DragAndDropLock.setDragAndDropStarted(true);
            return true;
        }
        return false;
    }

    protected void releaseLocks() {
        this.releaseLocksOne();
        this.releaseLocksTwo();
    }

    protected void releaseLocksOne() {
        DragAndDropLock.setDragAndDropStarted(false);
    }

    protected void releaseLocksTwo() {
        DragAndDropLock.setLocked(false);
    }

    protected boolean checkStatus() {
        return DragAndDropLock.isDragAndDropStarted() && this.ghostImage != null;
    }

    protected boolean isDragEnabled() {
        return SwingUtil.getBoolean("drag.enabled", true);
    }

    protected void setGhostImage(Point point, BufferedImage ghostImage) {
        this.updateGhostImage(point, ghostImage);
        this.ghostImage = ghostImage;
    }

    protected void updateGhostImage(Point point, BufferedImage ghostImage) {
        GlassPanel glassPane = this.manager.getGlassPanel();
        glassPane.setVisible(true);
        glassPane.setPoint(SwingUtil.convertPointFromScreen(point, glassPane));
        glassPane.setDraggingImage(ghostImage);
        glassPane.repaint();
        this.updatedGhostImage = ghostImage;
    }

    protected void updateGhostImage(Point point) {
        GlassPanel glassPane = this.manager.getGlassPanel();
        glassPane.setPoint(SwingUtil.convertPointFromScreen(point, glassPane));
        glassPane.repaint();
    }

    protected void resetGhostImage() {
        GlassPanel glassPane = this.manager.getGlassPanel();
        Rectangle dirtyRegion = glassPane.getRepaintRect();
        glassPane.setDraggingImage(null);
        glassPane.repaint(dirtyRegion);
    }

    protected void cleanupGhostImage() {
        GlassPanel glassPane = this.manager.getGlassPanel();
        glassPane.setDraggingImage(null);
        glassPane.setVisible(false);
        this.ghostImage = null;
        SwingUtilities.getWindowAncestor(this.manager).repaint();
    }

    protected void updateDropTarget(DragSourceDragEvent event) {
        Point location = event.getLocation();
        JLayeredPane source = this.manager.getLayeredPane();
        Component deepestCmp = null;
        for (Window window : SwingUtil.getMyDoggyTopContainers()) {
            if (!window.isVisible()) continue;
            location = event.getLocation();
            SwingUtilities.convertPointFromScreen(location, window);
            deepestCmp = SwingUtilities.getDeepestComponentAt(window, location.x, location.y);
            if (deepestCmp == null) continue;
            break;
        }
        if (deepestCmp == null && source.getComponentCount() > 0) {
            SwingUtilities.convertPointFromScreen(location, source);
            deepestCmp = SwingUtilities.getDeepestComponentAt(source, location.x, location.y);
        }
        if (deepestCmp == null) {
            location = event.getLocation();
            SwingUtilities.convertPointFromScreen(location, this.manager);
            deepestCmp = SwingUtilities.getDeepestComponentAt(this.manager, location.x, location.y);
        }
        if (deepestCmp != null) {
            DockableDropPanel dockableDropPanel = SwingUtil.getParent(deepestCmp, DockableDropPanel.class);
            if (dockableDropPanel != null) {
                if (this.lastDropPanel != dockableDropPanel) {
                    if (this.lastDropPanel != null) {
                        this.lastDropPanel.dragExit();
                    }
                    this.lastDropPanel = dockableDropPanel.dragStart(event.getDragSourceContext().getTransferable(), event.getDragSourceContext().getSourceActions()) ? dockableDropPanel : null;
                } else {
                    location = event.getLocation();
                    SwingUtilities.convertPointFromScreen(location, dockableDropPanel);
                    dockableDropPanel.dragOver(location);
                }
                this.lastBarAnchor = null;
            } else {
                this.dockableDropDragExit();
                ToolWindowScrollBar toolWindowScrollBar = SwingUtil.getParent(deepestCmp, ToolWindowScrollBar.class);
                this.lastBarAnchor = toolWindowScrollBar != null ? toolWindowScrollBar.getToolWindowBar().getAnchor() : null;
            }
        } else {
            this.dockableDropDragExit();
            this.lastBarAnchor = null;
        }
    }

    protected void dockableDropDragEnd() {
        if (this.lastDropPanel != null) {
            this.lastDropPanel.dragEnd();
        }
    }

    protected void dockableDropDragExit() {
        if (this.lastDropPanel != null) {
            this.lastDropPanel.dragExit();
            this.lastDropPanel = null;
        }
    }
}

