/*
 * Decompiled with CFR 0.152.
 */
package org.noos.xing.mydoggy.plaf.ui.cmp.multisplit;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.swing.UIManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiSplitLayout
implements LayoutManager {
    protected Map<String, Component> childMap = new LinkedHashMap<String, Component>();
    protected PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    protected Node model;
    protected int dividerSize;
    protected boolean floatingDividers = true;

    public MultiSplitLayout() {
        this(new Leaf("default"));
    }

    public MultiSplitLayout(Node model) {
        this.model = model;
        this.dividerSize = UIManager.getInt("SplitPane.dividerSize");
        if (this.dividerSize == 0) {
            this.dividerSize = 7;
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (listener != null) {
            this.pcs.addPropertyChangeListener(listener);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (listener != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    public PropertyChangeListener[] getPropertyChangeListeners() {
        return this.pcs.getPropertyChangeListeners();
    }

    private void firePCS(String propertyName, Object oldValue, Object newValue) {
        if (oldValue == null || newValue == null || !oldValue.equals(newValue)) {
            this.pcs.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    public Node getModel() {
        return this.model;
    }

    public void setModel(Node model) {
        if (model == null || model instanceof Divider) {
            throw new IllegalArgumentException("invalid model");
        }
        Node oldModel = this.model;
        this.model = model;
        this.firePCS("model", oldModel, model);
    }

    public int getDividerSize() {
        return this.dividerSize;
    }

    public void setDividerSize(int dividerSize) {
        if (dividerSize < 0) {
            throw new IllegalArgumentException("invalid dividerSize");
        }
        int oldDividerSize = this.dividerSize;
        this.dividerSize = dividerSize;
        this.firePCS("dividerSize", oldDividerSize, dividerSize);
    }

    public boolean getFloatingDividers() {
        return this.floatingDividers;
    }

    public void setFloatingDividers(boolean floatingDividers) {
        boolean oldFloatingDividers = this.floatingDividers;
        this.floatingDividers = floatingDividers;
        this.firePCS("floatingDividers", oldFloatingDividers, floatingDividers);
    }

    @Override
    public void addLayoutComponent(String name, Component child) {
        if (name == null) {
            throw new IllegalArgumentException("name not specified");
        }
        this.childMap.put(name, child);
    }

    @Override
    public void removeLayoutComponent(Component child) {
        for (String key : this.childMap.keySet()) {
            if (this.childMap.get(key) != child) continue;
            this.childMap.remove(key);
            break;
        }
    }

    private Component childForNode(Node node) {
        if (node instanceof Leaf) {
            Leaf leaf = (Leaf)node;
            String name = leaf.getName();
            return name != null ? this.childMap.get(name) : null;
        }
        return null;
    }

    private Dimension preferredComponentSize(Node node, Rectangle bounds) {
        if (node.isResetted()) {
            Component child = this.childForNode(node);
            if (node.getParent() != null && node.getParent().isRowLayout()) {
                int width = (int)((double)bounds.width * node.getWeight());
                return new Dimension(width, child != null ? child.getPreferredSize().height : 0);
            }
            int height = (int)((double)bounds.height * node.getWeight());
            return new Dimension(child != null ? child.getPreferredSize().width : 0, height);
        }
        return node.getBounds().getSize();
    }

    private Dimension minimumComponentSize(Node node) {
        Component child = this.childForNode(node);
        return child != null ? child.getMinimumSize() : new Dimension(0, 0);
    }

    private Dimension preferredNodeSize(Node root, Rectangle bounds) {
        if (root instanceof Leaf) {
            return this.preferredComponentSize(root, bounds);
        }
        if (root instanceof Divider) {
            int dividerSize = this.getDividerSize();
            return new Dimension(dividerSize, dividerSize);
        }
        Split split = (Split)root;
        List<Node> splitChildren = split.getChildren();
        int width = 0;
        int height = 0;
        if (split.isRowLayout()) {
            for (Node splitChild : splitChildren) {
                Dimension size = this.preferredNodeSize(splitChild, bounds);
                width += size.width;
                height = Math.max(height, size.height);
            }
            Rectangle nodeBounds = root.getBounds();
            if (split.getParent() != null && split.getParent().isRowLayout()) {
                if (nodeBounds.x == 0 && nodeBounds.y == 0 && nodeBounds.width == 0 && nodeBounds.height == 0 && root.getWeight() > 0.0) {
                    width = (int)((double)bounds.width * split.getWeight());
                }
            } else if (nodeBounds.x == 0 && nodeBounds.y == 0 && nodeBounds.width == 0 && nodeBounds.height == 0 && root.getWeight() > 0.0) {
                height = (int)((double)bounds.height * split.getWeight());
            }
        } else {
            for (Node splitChild : splitChildren) {
                Dimension size = this.preferredNodeSize(splitChild, bounds);
                width = Math.max(width, size.width);
                height += size.height;
            }
            Rectangle nodeBounds = root.getBounds();
            if (split.getParent() != null && split.getParent().isRowLayout()) {
                if (nodeBounds.x == 0 && nodeBounds.y == 0 && nodeBounds.width == 0 && nodeBounds.height == 0 && root.getWeight() > 0.0) {
                    width = (int)((double)bounds.width * split.getWeight());
                }
            } else if (nodeBounds.x == 0 && nodeBounds.y == 0 && nodeBounds.width == 0 && nodeBounds.height == 0 && root.getWeight() > 0.0) {
                height = (int)((double)bounds.height * split.getWeight());
            }
        }
        return new Dimension(width, height);
    }

    private Dimension minimumNodeSize(Node root) {
        if (root instanceof Leaf) {
            Component child = this.childForNode(root);
            return child != null ? child.getMinimumSize() : new Dimension(0, 0);
        }
        if (root instanceof Divider) {
            int dividerSize = this.getDividerSize();
            return new Dimension(dividerSize, dividerSize);
        }
        Split split = (Split)root;
        List<Node> splitChildren = split.getChildren();
        int width = 0;
        int height = 0;
        if (split.isRowLayout()) {
            for (Node splitChild : splitChildren) {
                Dimension size = this.minimumNodeSize(splitChild);
                width += size.width;
                height = Math.max(height, size.height);
            }
        } else {
            for (Node splitChild : splitChildren) {
                Dimension size = this.minimumNodeSize(splitChild);
                width = Math.max(width, size.width);
                height += size.height;
            }
        }
        return new Dimension(width, height);
    }

    private Dimension sizeWithInsets(Container parent, Dimension size) {
        Insets insets = parent.getInsets();
        int width = size.width + insets.left + insets.right;
        int height = size.height + insets.top + insets.bottom;
        return new Dimension(width, height);
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        Dimension size = this.preferredNodeSize(this.getModel(), parent.getBounds());
        return this.sizeWithInsets(parent, size);
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        Dimension size = this.minimumNodeSize(this.getModel());
        return this.sizeWithInsets(parent, size);
    }

    private Rectangle boundsWithYandHeight(Rectangle bounds, double y, double height) {
        if (height < 0.0) {
            height = -height;
        }
        Rectangle r = new Rectangle();
        r.setBounds((int)bounds.getX(), (int)y, (int)bounds.getWidth(), (int)height);
        return r;
    }

    private Rectangle boundsWithXandWidth(Rectangle bounds, double x, double width) {
        Rectangle r = new Rectangle();
        r.setBounds((int)x, (int)bounds.getY(), (int)width, (int)bounds.getHeight());
        return r;
    }

    private void minimizeSplitBounds(Split split, Rectangle bounds) {
        Rectangle splitBounds = new Rectangle(bounds.x, bounds.y, 0, 0);
        List<Node> splitChildren = split.getChildren();
        Node lastChild = splitChildren.get(splitChildren.size() - 1);
        Rectangle lastChildBounds = lastChild.getBounds();
        if (split.isRowLayout()) {
            int lastChildMaxX = lastChildBounds.x + lastChildBounds.width;
            splitBounds.add(lastChildMaxX, bounds.y + bounds.height);
        } else {
            int lastChildMaxY = lastChildBounds.y + lastChildBounds.height;
            splitBounds.add(bounds.x + bounds.width, lastChildMaxY);
        }
        split.setBounds(splitBounds);
    }

    private void layoutShrink(Split split, Rectangle bounds) {
        Rectangle splitBounds = split.getBounds();
        Node lastWeightedChild = split.lastWeightedChild();
        if (split.isRowLayout()) {
            double extraWidth;
            int totalWidth = 0;
            int minWeightedWidth = 0;
            int totalWeightedWidth = 0;
            for (Node splitChild : split.getChildren()) {
                int nodeWidth = splitChild.getBounds().width;
                int nodeMinWidth = Math.min(nodeWidth, this.minimumNodeSize((Node)splitChild).width);
                totalWidth += nodeWidth;
                if (!(splitChild.getWeight() > 0.0)) continue;
                minWeightedWidth += nodeMinWidth;
                totalWeightedWidth += nodeWidth;
            }
            double x = bounds.getX();
            double availableWidth = extraWidth = splitBounds.getWidth() - bounds.getWidth();
            boolean onlyShrinkWeightedComponents = (double)(totalWeightedWidth - minWeightedWidth) > extraWidth;
            ListIterator<Node> splitChildren = split.getChildren().listIterator();
            while (splitChildren.hasNext()) {
                double splitChildWeight;
                Node splitChild = splitChildren.next();
                Rectangle splitChildBounds = splitChild.getBounds();
                double minSplitChildWidth = this.minimumNodeSize(splitChild).getWidth();
                double d = splitChildWeight = onlyShrinkWeightedComponents ? splitChild.getWeight() : splitChildBounds.getWidth() / (double)totalWidth;
                if (!splitChildren.hasNext()) {
                    double oldWidth = splitChildBounds.getWidth();
                    double newWidth = Math.max(minSplitChildWidth, bounds.getMaxX() - x);
                    Rectangle newSplitChildBounds = this.boundsWithXandWidth(bounds, x, newWidth);
                    this.layout2(splitChild, newSplitChildBounds);
                    availableWidth -= oldWidth - splitChild.getBounds().getWidth();
                } else if (availableWidth > 0.0 && splitChildWeight > 0.0) {
                    double allocatedWidth = Math.rint(splitChildWeight * extraWidth);
                    double oldWidth = splitChildBounds.getWidth();
                    double newWidth = Math.max(minSplitChildWidth, oldWidth - allocatedWidth);
                    Rectangle newSplitChildBounds = this.boundsWithXandWidth(bounds, x, newWidth);
                    this.layout2(splitChild, newSplitChildBounds);
                    availableWidth -= oldWidth - splitChild.getBounds().getWidth();
                } else {
                    double existingWidth = splitChildBounds.getWidth();
                    Rectangle newSplitChildBounds = this.boundsWithXandWidth(bounds, x, existingWidth);
                    this.layout2(splitChild, newSplitChildBounds);
                }
                x = splitChild.getBounds().getMaxX();
            }
        } else {
            double extraHeight;
            int totalHeight = 0;
            int minWeightedHeight = 0;
            int totalWeightedHeight = 0;
            for (Node splitChild : split.getChildren()) {
                int nodeHeight = splitChild.getBounds().height;
                int nodeMinHeight = Math.min(nodeHeight, this.minimumNodeSize((Node)splitChild).height);
                totalHeight += nodeHeight;
                if (!(splitChild.getWeight() > 0.0)) continue;
                minWeightedHeight += nodeMinHeight;
                totalWeightedHeight += nodeHeight;
            }
            double y = bounds.getY();
            double availableHeight = extraHeight = splitBounds.getHeight() - bounds.getHeight();
            boolean onlyShrinkWeightedComponents = (double)(totalWeightedHeight - minWeightedHeight) > extraHeight;
            ListIterator<Node> splitChildren = split.getChildren().listIterator();
            while (splitChildren.hasNext()) {
                double splitChildWeight;
                Node splitChild = splitChildren.next();
                Rectangle splitChildBounds = splitChild.getBounds();
                double minSplitChildHeight = this.minimumNodeSize(splitChild).getHeight();
                double d = splitChildWeight = onlyShrinkWeightedComponents ? splitChild.getWeight() : splitChildBounds.getHeight() / (double)totalHeight;
                if (!splitChildren.hasNext()) {
                    double oldHeight = splitChildBounds.getHeight();
                    double newHeight = Math.max(minSplitChildHeight, bounds.getMaxY() - y);
                    Rectangle newSplitChildBounds = this.boundsWithYandHeight(bounds, y, newHeight);
                    this.layout2(splitChild, newSplitChildBounds);
                    availableHeight -= oldHeight - splitChild.getBounds().getHeight();
                } else if (availableHeight > 0.0 && splitChildWeight > 0.0) {
                    double allocatedHeight = Math.rint(splitChildWeight * extraHeight);
                    double oldHeight = splitChildBounds.getHeight();
                    double newHeight = Math.max(minSplitChildHeight, oldHeight - allocatedHeight);
                    Rectangle newSplitChildBounds = this.boundsWithYandHeight(bounds, y, newHeight);
                    this.layout2(splitChild, newSplitChildBounds);
                    availableHeight -= oldHeight - splitChild.getBounds().getHeight();
                } else {
                    double existingHeight = splitChildBounds.getHeight();
                    Rectangle newSplitChildBounds = this.boundsWithYandHeight(bounds, y, existingHeight);
                    this.layout2(splitChild, newSplitChildBounds);
                }
                y = splitChild.getBounds().getMaxY();
            }
        }
        this.minimizeSplitBounds(split, bounds);
    }

    private void layoutGrow(Split split, Rectangle bounds) {
        Rectangle splitBounds = split.getBounds();
        ListIterator<Node> splitChildren = split.getChildren().listIterator();
        Node lastWeightedChild = split.lastWeightedChild();
        if (split.isRowLayout()) {
            double extraWidth;
            double x = bounds.getX();
            double availableWidth = extraWidth = bounds.getWidth() - splitBounds.getWidth();
            while (splitChildren.hasNext()) {
                Rectangle newSplitChildBounds;
                Node splitChild = splitChildren.next();
                Rectangle splitChildBounds = splitChild.getBounds();
                double splitChildWeight = splitChild.getWeight();
                if (!splitChildren.hasNext()) {
                    double newWidth = bounds.getMaxX() - x;
                    newSplitChildBounds = this.boundsWithXandWidth(bounds, x, newWidth);
                    this.layout2(splitChild, newSplitChildBounds);
                } else if (availableWidth > 0.0 && splitChildWeight > 0.0) {
                    double allocatedWidth = splitChild.equals(lastWeightedChild) ? availableWidth : Math.rint(splitChildWeight * extraWidth);
                    double newWidth = splitChildBounds.getWidth() + allocatedWidth;
                    Rectangle newSplitChildBounds2 = this.boundsWithXandWidth(bounds, x, newWidth);
                    this.layout2(splitChild, newSplitChildBounds2);
                    availableWidth -= allocatedWidth;
                } else {
                    double existingWidth = splitChildBounds.getWidth();
                    newSplitChildBounds = this.boundsWithXandWidth(bounds, x, existingWidth);
                    this.layout2(splitChild, newSplitChildBounds);
                }
                x = splitChild.getBounds().getMaxX();
            }
        } else {
            double extraHeight;
            double y = bounds.getY();
            double availableHeight = extraHeight = bounds.getHeight() - splitBounds.getHeight();
            while (splitChildren.hasNext()) {
                Node splitChild = splitChildren.next();
                Rectangle splitChildBounds = splitChild.getBounds();
                double splitChildWeight = splitChild.getWeight();
                if (!splitChildren.hasNext()) {
                    double newHeight = bounds.getMaxY() - y;
                    Rectangle newSplitChildBounds = this.boundsWithYandHeight(bounds, y, newHeight);
                    this.layout2(splitChild, newSplitChildBounds);
                } else if (availableHeight > 0.0 && splitChildWeight > 0.0) {
                    double allocatedHeight = splitChild.equals(lastWeightedChild) ? availableHeight : Math.rint(splitChildWeight * extraHeight);
                    double newHeight = splitChildBounds.getHeight() + allocatedHeight;
                    Rectangle newSplitChildBounds = this.boundsWithYandHeight(bounds, y, newHeight);
                    this.layout2(splitChild, newSplitChildBounds);
                    availableHeight -= allocatedHeight;
                } else {
                    double existingHeight = splitChildBounds.getHeight();
                    Rectangle newSplitChildBounds = this.boundsWithYandHeight(bounds, y, existingHeight);
                    this.layout2(splitChild, newSplitChildBounds);
                }
                y = splitChild.getBounds().getMaxY();
            }
        }
    }

    private void layout2(Node root, Rectangle bounds) {
        if (root instanceof Leaf) {
            Component child = this.childForNode(root);
            if (child != null) {
                child.setBounds(bounds);
            }
            root.setBounds(bounds);
        } else if (root instanceof Divider) {
            root.setBounds(bounds);
        } else if (root instanceof Split) {
            boolean grow;
            Split split = (Split)root;
            boolean bl = split.isRowLayout() ? split.getBounds().width <= bounds.width : (grow = split.getBounds().height <= bounds.height);
            if (grow) {
                this.layoutGrow(split, bounds);
                root.setBounds(bounds);
            } else {
                this.layoutShrink(split, bounds);
            }
        }
    }

    private void layout1(Node root, Rectangle bounds) {
        if (root instanceof Leaf) {
            root.setBounds(bounds);
        } else if (root instanceof Split) {
            Split split = (Split)root;
            Iterator<Node> children = split.getChildren().iterator();
            int dividerSize = this.getDividerSize();
            if (split.isRowLayout()) {
                Rectangle rootBounds = root.getBounds();
                double x = bounds.getX();
                int stateCondition = 0;
                if (x < (double)rootBounds.x) {
                    stateCondition = 1;
                } else if (x > (double)rootBounds.x) {
                    stateCondition = -1;
                }
                boolean flag = false;
                for (Node node : split.getChildren()) {
                    if (!node.isResetted()) continue;
                    flag = true;
                }
                if (flag) {
                    for (Node node : split.getChildren()) {
                        node.resetBounds();
                    }
                }
                while (children.hasNext()) {
                    Rectangle dividerBounds;
                    double dividerX;
                    Divider dividerChild;
                    Node child = children.next();
                    Divider divider = dividerChild = children.hasNext() ? (Divider)children.next() : null;
                    if (dividerChild != null && !(dividerChild instanceof Divider)) {
                        this.throwInvalidLayout("Expected Divider. [found : " + dividerChild + "]", split);
                    }
                    double childWidth = this.getFloatingDividers() ? this.preferredNodeSize(child, bounds).getWidth() : (dividerChild != null ? (stateCondition == 1 ? (double)(((Node)child).bounds.width - 20) : (stateCondition == -1 ? (double)(((Node)child).bounds.width + 20) : dividerChild.getBounds().getX() - x)) : (stateCondition == 1 ? (double)(((Node)child).bounds.width - 20) : (stateCondition == -1 ? (double)(((Node)child).bounds.width + 20) : split.getBounds().getMaxX() - x)));
                    Rectangle childBounds = this.boundsWithXandWidth(bounds, x, childWidth);
                    this.layout1(child, childBounds);
                    if (this.getFloatingDividers() && dividerChild != null) {
                        dividerX = childBounds.getMaxX();
                        dividerBounds = this.boundsWithXandWidth(bounds, dividerX, dividerSize);
                        dividerChild.setBounds(dividerBounds);
                    } else if (dividerChild != null) {
                        dividerX = childBounds.getMaxX();
                        dividerBounds = this.boundsWithXandWidth(bounds, dividerX, dividerSize);
                        dividerChild.setBounds(dividerBounds);
                    }
                    if (dividerChild == null) continue;
                    x = dividerChild.getBounds().getMaxX();
                }
            } else {
                double y = bounds.getY();
                int stateCondition = 0;
                if (y < (double)root.getBounds().y) {
                    stateCondition = 1;
                } else if (y > (double)root.getBounds().y) {
                    stateCondition = -1;
                }
                boolean flag = false;
                for (Node node : split.getChildren()) {
                    if (!node.isResetted()) continue;
                    flag = true;
                }
                if (flag) {
                    for (Node node : split.getChildren()) {
                        node.resetBounds();
                    }
                }
                while (children.hasNext()) {
                    Rectangle dividerBounds;
                    double dividerY;
                    Node dividerChild;
                    Node child = children.next();
                    Node node = dividerChild = children.hasNext() ? children.next() : null;
                    if (dividerChild != null && !(dividerChild instanceof Divider)) {
                        this.throwInvalidLayout("Expected Divider. [found : " + dividerChild + "]", split);
                    }
                    double childHeight = this.getFloatingDividers() ? this.preferredNodeSize(child, bounds).getHeight() : (dividerChild != null ? (stateCondition == 1 ? (double)(((Node)child).bounds.height - 20) : (stateCondition == -1 ? (double)(((Node)child).bounds.height + 20) : dividerChild.getBounds().getY() - y)) : (stateCondition == 1 ? (double)(((Node)child).bounds.height - 20) : (stateCondition == -1 ? (double)(((Node)child).bounds.height + 20) : split.getBounds().getMaxY() - y)));
                    Rectangle childBounds = this.boundsWithYandHeight(bounds, y, childHeight);
                    this.layout1(child, childBounds);
                    if (this.getFloatingDividers() && dividerChild != null) {
                        dividerY = childBounds.getMaxY();
                        dividerBounds = this.boundsWithYandHeight(bounds, dividerY, dividerSize);
                        dividerChild.setBounds(dividerBounds);
                    } else if (dividerChild != null) {
                        dividerY = childBounds.getMaxY();
                        dividerBounds = this.boundsWithYandHeight(bounds, dividerY, dividerSize);
                        dividerChild.setBounds(dividerBounds);
                    }
                    if (dividerChild == null) continue;
                    y = dividerChild.getBounds().getMaxY();
                }
            }
            this.minimizeSplitBounds(split, bounds);
        }
    }

    private void throwInvalidLayout(String msg, Node node) {
        throw new InvalidLayoutException(msg, node);
    }

    private void checkLayout(Node root) {
        if (root instanceof Split) {
            Split split = (Split)root;
            if (split.getChildren().size() <= 2) {
                this.throwInvalidLayout("Split must have > 2 children", root);
            }
            Iterator<Node> splitChildren = split.getChildren().iterator();
            double weight = 0.0;
            while (splitChildren.hasNext()) {
                Node dividerChild;
                Node splitChild = splitChildren.next();
                if (splitChild instanceof Divider) {
                    this.throwInvalidLayout("expected a Split or Leaf Node", splitChild);
                }
                if (splitChildren.hasNext() && !((dividerChild = splitChildren.next()) instanceof Divider)) {
                    this.throwInvalidLayout("expected a Divider Node", dividerChild);
                }
                weight += splitChild.getWeight();
                this.checkLayout(splitChild);
            }
            if (weight > 1.0) {
                this.throwInvalidLayout("Split children's total weight > 1.0", root);
            }
        }
    }

    @Override
    public void layoutContainer(Container parent) {
        this.checkLayout(this.getModel());
        Insets insets = parent.getInsets();
        Dimension size = parent.getSize();
        int width = size.width - (insets.left + insets.right);
        int height = size.height - (insets.top + insets.bottom);
        Rectangle bounds = new Rectangle(insets.left, insets.top, width, height);
        this.layout1(this.getModel(), bounds);
        this.layout2(this.getModel(), bounds);
    }

    public Map<String, Component> getChildMap() {
        return this.childMap;
    }

    public void setChildMap(Map<String, Component> childMap) {
        this.childMap = childMap;
    }

    private Divider dividerAt(Node root, int x, int y) {
        if (root instanceof Divider) {
            Divider divider = (Divider)root;
            return divider.getBounds().contains(x, y) ? divider : null;
        }
        if (root instanceof Split) {
            Split split = (Split)root;
            for (Node child : split.getChildren()) {
                if (!child.getBounds().contains(x, y)) continue;
                return this.dividerAt(child, x, y);
            }
        }
        return null;
    }

    public Divider dividerAt(int x, int y) {
        return this.dividerAt(this.getModel(), x, y);
    }

    private boolean nodeOverlapsRectangle(Node node, Rectangle r2) {
        Rectangle r1 = node.getBounds();
        return r1.x <= r2.x + r2.width && r1.x + r1.width >= r2.x && r1.y <= r2.y + r2.height && r1.y + r1.height >= r2.y;
    }

    private List<Divider> dividersThatOverlap(Node root, Rectangle r) {
        if (this.nodeOverlapsRectangle(root, r) && root instanceof Split) {
            ArrayList<Divider> dividers = new ArrayList<Divider>();
            for (Node child : ((Split)root).getChildren()) {
                if (child instanceof Divider) {
                    if (!this.nodeOverlapsRectangle(child, r)) continue;
                    dividers.add((Divider)child);
                    continue;
                }
                if (!(child instanceof Split)) continue;
                dividers.addAll(this.dividersThatOverlap(child, r));
            }
            return dividers;
        }
        return Collections.emptyList();
    }

    public List<Divider> dividersThatOverlap(Rectangle r) {
        if (r == null) {
            throw new IllegalArgumentException("null Rectangle");
        }
        return this.dividersThatOverlap(this.getModel(), r);
    }

    private static void throwParseException(StreamTokenizer st, String msg) throws Exception {
        throw new Exception("MultiSplitLayout.parseModel Error: " + msg);
    }

    private static void parseAttribute(String name, StreamTokenizer st, Node node) throws Exception {
        if (st.nextToken() != 61) {
            MultiSplitLayout.throwParseException(st, "expected '=' after " + name);
        }
        if (name.equalsIgnoreCase("WEIGHT")) {
            if (st.nextToken() == -2) {
                node.setWeight(st.nval);
            } else {
                MultiSplitLayout.throwParseException(st, "invalid weight");
            }
        } else if (name.equalsIgnoreCase("TRANSFERABLE_NAME")) {
            if (st.nextToken() == -3) {
                if (node instanceof Leaf) {
                    ((Leaf)node).setName(st.sval);
                } else {
                    MultiSplitLayout.throwParseException(st, "can't specify name for " + node);
                }
            } else {
                MultiSplitLayout.throwParseException(st, "invalid name");
            }
        } else {
            MultiSplitLayout.throwParseException(st, "unrecognized attribute \"" + name + "\"");
        }
    }

    private static void addSplitChild(Split parent, Node child) {
        ArrayList<Node> children = new ArrayList<Node>(parent.getChildren());
        if (children.size() == 0) {
            children.add(child);
        } else {
            children.add(new Divider());
            children.add(child);
        }
        parent.setChildren(children);
    }

    private static void parseLeaf(StreamTokenizer st, Split parent) throws Exception {
        int token;
        Leaf leaf = new Leaf();
        while ((token = st.nextToken()) != -1 && token != 41) {
            if (token == -3) {
                MultiSplitLayout.parseAttribute(st.sval, st, leaf);
                continue;
            }
            MultiSplitLayout.throwParseException(st, "Bad Leaf: " + leaf);
        }
        MultiSplitLayout.addSplitChild(parent, leaf);
    }

    private static void parseSplit(StreamTokenizer st, Split parent) throws Exception {
        int token;
        while ((token = st.nextToken()) != -1 && token != 41) {
            String nodeType;
            if (token == -3) {
                if (st.sval.equalsIgnoreCase("WEIGHT")) {
                    MultiSplitLayout.parseAttribute(st.sval, st, parent);
                    continue;
                }
                MultiSplitLayout.addSplitChild(parent, new Leaf(st.sval));
                continue;
            }
            if (token != 40) continue;
            token = st.nextToken();
            if (token != -3) {
                MultiSplitLayout.throwParseException(st, "invalid node type");
            }
            if ((nodeType = st.sval.toUpperCase()).equals("LEAF")) {
                MultiSplitLayout.parseLeaf(st, parent);
                continue;
            }
            if (nodeType.equals("ROW") || nodeType.equals("COLUMN")) {
                Split split = new Split();
                split.setRowLayout(nodeType.equals("ROW"));
                MultiSplitLayout.addSplitChild(parent, split);
                MultiSplitLayout.parseSplit(st, split);
                continue;
            }
            MultiSplitLayout.throwParseException(st, "unrecognized node type '" + nodeType + "'");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Node parseModel(Reader r) {
        StreamTokenizer st = new StreamTokenizer(r);
        try {
            Split root = new Split();
            MultiSplitLayout.parseSplit(st, root);
            Node node = root.getChildren().get(0);
            return node;
        }
        catch (Exception e) {
            System.err.println(e);
        }
        finally {
            try {
                r.close();
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    public static Node parseModel(String s) {
        return MultiSplitLayout.parseModel(new StringReader(s));
    }

    private static void printModel(String indent, Node root, PrintStream printStream) {
        if (root instanceof Split) {
            Split split = (Split)root;
            printStream.println(indent + split.print());
        } else {
            printStream.println(indent + root.print());
        }
    }

    public static void printModel(Node root) {
        MultiSplitLayout.printModel("", root, System.out);
    }

    public static void printModel(Node root, PrintStream printStream) {
        MultiSplitLayout.printModel("", root, printStream);
    }

    public static class Divider
    extends Node {
        public final boolean isVertical() {
            Split parent = this.getParent();
            return parent != null ? parent.isRowLayout() : false;
        }

        public void setWeight(double weight) {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return "Divider " + this.getBounds().toString();
        }

        public void setBounds(Rectangle bounds) {
            super.setBounds(bounds);
        }

        public String print() {
            return String.format("Divider{%s}", this.getBounds());
        }
    }

    public static class Leaf
    extends Node {
        private String name = "";

        public Leaf() {
        }

        public Leaf(String name) {
            if (name == null) {
                throw new IllegalArgumentException("name is null");
            }
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            if (name == null) {
                throw new IllegalArgumentException("name is null");
            }
            this.name = name;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer("Leaf");
            sb.append(" \"");
            sb.append(this.getName());
            sb.append("\"");
            sb.append(" weight=");
            sb.append(this.getWeight());
            sb.append(" ");
            sb.append(this.getBounds());
            return sb.toString();
        }

        public String print() {
            StringBuffer sb = new StringBuffer("Leaf");
            sb.append(" \"");
            sb.append(this.getName());
            sb.append("\"");
            return sb.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Split
    extends Node {
        private List<Node> children = Collections.emptyList();
        private boolean rowLayout = true;

        public boolean isRowLayout() {
            return this.rowLayout;
        }

        public void setRowLayout(boolean rowLayout) {
            this.rowLayout = rowLayout;
        }

        public List<Node> getChildren() {
            return new ArrayList<Node>(this.children);
        }

        public void setChildren(List<Node> children) {
            if (children == null) {
                throw new IllegalArgumentException("children must be a non-null List");
            }
            for (Node child : this.children) {
                child.setParent(null);
            }
            this.children = new ArrayList<Node>(children);
            for (Node child : this.children) {
                child.setParent(this);
            }
        }

        public final Node lastWeightedChild() {
            List<Node> children = this.getChildren();
            Node weightedChild = null;
            for (Node child : children) {
                if (!(child.getWeight() > 0.0)) continue;
                weightedChild = child;
            }
            return weightedChild;
        }

        public void removeNode(Node node) {
            this.children.remove(node);
        }

        public String toString() {
            StringBuffer sb = new StringBuffer("Split");
            sb.append(this.isRowLayout() ? " ROW [" : " COLUMN [");
            for (Node child : this.children) {
                sb.append(child).append(" ; ");
            }
            sb.append("] ");
            sb.append(this.getBounds());
            return sb.toString();
        }

        @Override
        public String print() {
            StringBuffer sb = new StringBuffer("Split");
            sb.append("{").append(this.getBounds()).append("}");
            sb.append(this.isRowLayout() ? " ROW [" : " COLUMN [");
            for (Node child : this.children) {
                sb.append(child.print()).append(" ; ");
            }
            sb.append("] ");
            return sb.toString();
        }
    }

    public static abstract class Node {
        private Split parent = null;
        private Rectangle bounds = new Rectangle();
        private double weight = 0.0;

        public Split getParent() {
            return this.parent;
        }

        public void setParent(Split parent) {
            this.parent = parent;
        }

        public Rectangle getBounds() {
            return new Rectangle(this.bounds);
        }

        public void setBounds(Rectangle bounds) {
            if (bounds == null) {
                throw new IllegalArgumentException("null bounds");
            }
            this.bounds = new Rectangle(bounds);
        }

        public void resetBounds() {
            this.bounds.height = 0;
            this.bounds.width = 0;
            this.bounds.y = 0;
            this.bounds.x = 0;
        }

        public double getWeight() {
            return this.weight;
        }

        public void setWeight(double weight) {
            if (weight < 0.0 || weight > 1.0) {
                throw new IllegalArgumentException("invalid weight");
            }
            this.weight = weight;
        }

        private Node siblingAtOffset(int offset) {
            Split parent = this.getParent();
            if (parent == null) {
                return null;
            }
            List<Node> siblings = parent.getChildren();
            int index = siblings.indexOf(this);
            if (index == -1) {
                return null;
            }
            return (index += offset) > -1 && index < siblings.size() ? siblings.get(index) : null;
        }

        public Node nextSibling() {
            return this.siblingAtOffset(1);
        }

        public Node previousSibling() {
            return this.siblingAtOffset(-1);
        }

        public String print() {
            return "";
        }

        public boolean isResetted() {
            return this.bounds.x == 0 && this.bounds.y == 0 && this.bounds.width == 0 && this.bounds.height == 0 && this.weight > 0.0;
        }
    }

    public static class InvalidLayoutException
    extends RuntimeException {
        private final Node node;

        public InvalidLayoutException(String msg, Node node) {
            super(msg);
            this.node = node;
        }

        public Node getNode() {
            return this.node;
        }
    }
}

