/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.client.action;

import java.awt.AWTEvent;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.filechooser.FileFilter;
import nl.lxtreme.ols.client.ClientController;
import nl.lxtreme.ols.client.action.BaseAction;
import nl.lxtreme.ols.client.action.OpenProjectAction;
import nl.lxtreme.ols.util.HostUtils;
import nl.lxtreme.ols.util.swing.SwingComponentUtils;
import nl.lxtreme.ols.util.swing.component.JErrorDialog;

public class SaveProjectAction
extends BaseAction {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = Logger.getLogger(SaveProjectAction.class.getName());
    public static final String ID = "SaveProject";

    public SaveProjectAction(ClientController aController) {
        this(ID, aController, "document-save.png", "Save project", "Save the current project");
    }

    protected SaveProjectAction(String aID, ClientController aController, String aIconName, String aName, String aDescription) {
        super(aID, aController, aIconName, aName, aDescription);
        this.putValue("AcceleratorKey", SwingComponentUtils.createMenuKeyMask((int)83, (int[])new int[0]));
        this.putValue("MnemonicKey", 65);
    }

    @Override
    public void actionPerformed(ActionEvent aEvent) {
        Window owner = SwingComponentUtils.getOwningWindow((AWTEvent)aEvent);
        File file = this.getProjectFilename();
        if (this.showFileChooserDialogNeeded()) {
            file = this.askForFilename(owner);
        }
        if (file == null) {
            return;
        }
        this.saveProjectFile(owner, file);
    }

    protected File askForFilename(Window owner) {
        File file = SwingComponentUtils.showFileSaveDialog((Window)owner, (FileFilter[])new FileFilter[]{OpenProjectAction.OLS_PROJECT_FILTER});
        if (file != null) {
            return HostUtils.setFileExtension((File)file, (String)"olp");
        }
        return file;
    }

    protected File getProjectFilename() {
        return this.getController().getProjectFilename();
    }

    protected void saveProjectFile(Window aOwner, File aFile) {
        block2: {
            LOG.log(Level.INFO, "Saving project data to file: {0}", aFile);
            String projectName = HostUtils.stripFileExtension((File)aFile, (String[])new String[]{"ols", "olp"});
            try {
                this.getController().saveProjectFile(projectName, aFile);
            }
            catch (IOException exception) {
                if (HostUtils.handleInterruptedException((Throwable)exception)) break block2;
                LOG.log(Level.WARNING, "Saving OLS project failed!", exception);
                JErrorDialog.showDialog((Window)aOwner, (String)"Saving the project data failed!", (Throwable)exception);
            }
        }
    }

    protected boolean showFileChooserDialogNeeded() {
        return this.getProjectFilename() == null;
    }
}

