/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.cm.impl;

import java.io.IOException;
import java.util.Dictionary;
import java.util.Hashtable;
import org.apache.felix.cm.PersistenceManager;
import org.apache.felix.cm.impl.CaseInsensitiveDictionary;
import org.apache.felix.cm.impl.ConfigurationBase;
import org.apache.felix.cm.impl.ConfigurationManager;
import org.apache.felix.cm.impl.Factory;
import org.osgi.service.cm.Configuration;

class ConfigurationImpl
extends ConfigurationBase {
    private static final String CONFIGURATION_NEW = "_felix_.cm.newConfiguration";
    private final String factoryPID;
    private volatile String staticBundleLocation;
    private volatile String dynamicBundleLocation;
    private volatile CaseInsensitiveDictionary properties;
    private volatile boolean isDeleted;
    private volatile long revision;

    ConfigurationImpl(ConfigurationManager configurationManager, PersistenceManager persistenceManager, Dictionary properties) {
        super(configurationManager, persistenceManager, (String)properties.remove("service.pid"));
        this.factoryPID = (String)properties.remove("service.factoryPid");
        this.isDeleted = false;
        this.staticBundleLocation = (String)properties.remove("service.bundleLocation");
        this.dynamicBundleLocation = configurationManager.getDynamicBundleLocation(this.getBaseId());
        this.configureFromPersistence(properties);
    }

    ConfigurationImpl(ConfigurationManager configurationManager, PersistenceManager persistenceManager, String pid, String factoryPid, String bundleLocation) throws IOException {
        super(configurationManager, persistenceManager, pid);
        this.factoryPID = factoryPid;
        this.isDeleted = false;
        this.staticBundleLocation = bundleLocation;
        this.dynamicBundleLocation = configurationManager.getDynamicBundleLocation(this.getBaseId());
        this.properties = null;
        this.revision = 1L;
        if (factoryPid == null) {
            this.storeNewConfiguration();
        }
    }

    public void delete() throws IOException {
        this.isDeleted = true;
        this.getPersistenceManager().delete(this.getPid());
        this.getConfigurationManager().setDynamicBundleLocation(this.getPid(), null);
        this.getConfigurationManager().deleted(this);
    }

    public String getPid() {
        return this.getBaseId();
    }

    public String getFactoryPid() {
        return this.factoryPID;
    }

    String getBundleLocation() {
        if (this.staticBundleLocation != null) {
            return this.staticBundleLocation;
        }
        return this.dynamicBundleLocation;
    }

    String getDynamicBundleLocation() {
        return this.dynamicBundleLocation;
    }

    String getStaticBundleLocation() {
        return this.staticBundleLocation;
    }

    void setStaticBundleLocation(String bundleLocation) {
        String oldBundleLocation = this.getBundleLocation();
        this.staticBundleLocation = bundleLocation;
        this.storeSilently();
        if (bundleLocation != null && this.getDynamicBundleLocation() != null && !bundleLocation.equals(this.getDynamicBundleLocation())) {
            this.setDynamicBundleLocation(null, false);
        }
        this.getConfigurationManager().locationChanged(this, oldBundleLocation);
    }

    void setDynamicBundleLocation(String bundleLocation, boolean dispatchConfiguration) {
        String oldBundleLocation = this.getBundleLocation();
        this.dynamicBundleLocation = bundleLocation;
        this.getConfigurationManager().setDynamicBundleLocation(this.getBaseId(), bundleLocation);
        if (dispatchConfiguration) {
            this.getConfigurationManager().locationChanged(this, oldBundleLocation);
        }
    }

    boolean tryBindLocation(String bundleLocation) {
        if (this.getBundleLocation() == null) {
            this.getConfigurationManager().log(4, "Dynamically binding config {0} to {1}", new Object[]{this.getPid(), bundleLocation});
            this.setDynamicBundleLocation(bundleLocation, true);
        }
        return true;
    }

    public Dictionary getProperties(boolean deepCopy) {
        if (this.properties == null) {
            return null;
        }
        CaseInsensitiveDictionary props = new CaseInsensitiveDictionary(this.properties, deepCopy);
        this.setAutoProperties(props, false);
        return props;
    }

    public void update() throws IOException {
        PersistenceManager localPersistenceManager = this.getPersistenceManager();
        if (localPersistenceManager != null) {
            if (localPersistenceManager.exists(this.getPid())) {
                Dictionary properties = localPersistenceManager.load(this.getPid());
                String servicePid = (String)properties.get("service.pid");
                if (servicePid != null && !this.getPid().equals(servicePid)) {
                    throw new IOException("PID of configuration file does match requested PID; expected " + this.getPid() + ", got " + servicePid);
                }
                this.configureFromPersistence(properties);
            }
            this.getConfigurationManager().updated(this, false);
        }
    }

    public void update(Dictionary properties) throws IOException {
        PersistenceManager localPersistenceManager = this.getPersistenceManager();
        if (localPersistenceManager != null) {
            Factory factory;
            CaseInsensitiveDictionary newProperties = new CaseInsensitiveDictionary(properties);
            this.getConfigurationManager().log(4, "Updating config {0} with {1}", new Object[]{this.getPid(), newProperties});
            this.setAutoProperties(newProperties, true);
            localPersistenceManager.store(this.getPid(), newProperties);
            String factoryPid = this.getFactoryPid();
            if (factoryPid != null && (factory = this.getConfigurationManager().getFactory(factoryPid)).addPID(this.getPid())) {
                try {
                    factory.store();
                }
                catch (IOException ioe) {
                    this.getConfigurationManager().log(1, "Failure storing factory {0} with new configuration {1}", new Object[]{factoryPid, this.getPid(), ioe});
                }
            }
            this.configure(newProperties);
            this.getConfigurationManager().updated(this, true);
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Configuration) {
            return this.getPid().equals(((Configuration)obj).getPid());
        }
        return false;
    }

    public int hashCode() {
        return this.getPid().hashCode();
    }

    public String toString() {
        return "Configuration PID=" + this.getPid() + ", factoryPID=" + this.factoryPID + ", bundleLocation=" + this.getBundleLocation();
    }

    void ensureFactoryConfigPersisted() throws IOException {
        if (this.factoryPID != null && this.isNew() && !this.getPersistenceManager().exists(this.getPid())) {
            this.storeNewConfiguration();
        }
    }

    private void storeNewConfiguration() throws IOException {
        Hashtable<String, Boolean> props = new Hashtable<String, Boolean>();
        this.setAutoProperties(props, true);
        ((Dictionary)props).put(CONFIGURATION_NEW, Boolean.TRUE);
        this.getPersistenceManager().store(this.getPid(), props);
    }

    void store() throws IOException {
        Hashtable props = this.getProperties(false);
        if (props == null) {
            props = new Hashtable();
            this.setAutoProperties(props, true);
        } else {
            ConfigurationImpl.replaceProperty(props, "service.bundleLocation", this.getStaticBundleLocation());
        }
        this.getPersistenceManager().store(this.getPid(), props);
    }

    long getRevision() {
        return this.revision;
    }

    boolean isNew() {
        return this.properties == null;
    }

    boolean isDeleted() {
        return this.isDeleted;
    }

    private void configureFromPersistence(Dictionary properties) {
        if (properties.get(CONFIGURATION_NEW) == null) {
            this.configure(properties);
        } else {
            this.configure(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configure(Dictionary properties) {
        CaseInsensitiveDictionary newProperties;
        if (properties == null) {
            newProperties = null;
        } else {
            ConfigurationImpl.clearAutoProperties(properties);
            newProperties = properties instanceof CaseInsensitiveDictionary ? (CaseInsensitiveDictionary)properties : new CaseInsensitiveDictionary(properties);
        }
        ConfigurationImpl configurationImpl = this;
        synchronized (configurationImpl) {
            this.properties = newProperties;
            ++this.revision;
        }
    }

    void setAutoProperties(Dictionary properties, boolean withBundleLocation) {
        ConfigurationImpl.replaceProperty(properties, "service.pid", this.getPid());
        ConfigurationImpl.replaceProperty(properties, "service.factoryPid", this.factoryPID);
        if (withBundleLocation) {
            ConfigurationImpl.replaceProperty(properties, "service.bundleLocation", this.getStaticBundleLocation());
        } else {
            properties.remove("service.bundleLocation");
        }
    }

    static void clearAutoProperties(Dictionary properties) {
        properties.remove("service.pid");
        properties.remove("service.factoryPid");
        properties.remove("service.bundleLocation");
    }
}

