/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.api.util;

public enum SizeUnit {
    B("", 1.0),
    KB("k", 1024.0),
    MB("M", 1048576.0),
    GB("G", 1.073741824E9),
    TB("T", 1.099511627776E12);

    public static final double ZERO_THRESHOLD = 0.1;
    private static final String BASE_UNIT = "B";
    private final String displayName;
    private final double factor;

    private SizeUnit(String aPrefix, double aFactor) {
        this.displayName = aPrefix.concat(BASE_UNIT);
        this.factor = aFactor;
    }

    public static String format(double aSize) {
        return SizeUnit.toUnit(aSize).format(aSize, 2);
    }

    public static SizeUnit toUnit(double aSize) {
        int i;
        SizeUnit[] sizes = SizeUnit.values();
        double size = Math.abs(aSize);
        for (i = sizes.length - 1; i >= 0 && !(size >= sizes[i].getFactor()); --i) {
        }
        return sizes[Math.max(i, 0)];
    }

    public String format(double aSize, int aScale) {
        if (Math.abs(aSize) < 0.1 && this != B) {
            return B.format(0.0, aScale);
        }
        Double size = aSize / this.getFactor();
        String format = String.format("%%.%df%%s", aScale);
        return String.format(format, size, this.getDisplayName());
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public double getFactor() {
        return this.factor;
    }
}

