/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.export.vcd;

import java.io.PrintWriter;
import java.text.DateFormat;
import java.util.Date;

public class ValueChangeDumpHelper {
    private ValueChangeDumpHelper() {
    }

    public static final String getIdentifier(int aIndex) {
        if (aIndex < 0) {
            throw new IllegalArgumentException("Index cannot be negative!");
        }
        if (aIndex > 90) {
            throw new IllegalArgumentException("More than 90 identifiers are not supported!");
        }
        int id = 33 + aIndex;
        return String.format("%c", id);
    }

    public static final double getTimebase(long aSampleRate) {
        int i;
        if (aSampleRate < 0L) {
            throw new IllegalArgumentException("Negative sample rates are not supported!");
        }
        if (aSampleRate == 0L) {
            return 0.0;
        }
        double[] unitVals = new double[]{1.0, 0.001, 1.0E-6, 1.0E-9, 1.0E-12, 1.0E-15, 1.0E-18};
        double period = 1.0 / (double)aSampleRate;
        for (i = 0; i < unitVals.length && !(period >= unitVals[i]); ++i) {
        }
        i = Math.max(0, Math.min(i, unitVals.length - 1));
        return (double)ValueChangeDumpHelper.normalizeTimebase(1.0 / ((double)aSampleRate * unitVals[i])) * unitVals[i];
    }

    public static final void writeCloseDeclaration(PrintWriter aWriter) {
        aWriter.println("$end");
    }

    public static final void writeDate(PrintWriter aWriter) {
        ValueChangeDumpHelper.writeDeclaration(aWriter, "date", DateFormat.getDateTimeInstance().format(new Date()));
    }

    public static final void writeDeclaration(PrintWriter aWriter, String aKeyword, String ... aValues) {
        aWriter.printf("$%s ", aKeyword);
        for (String value : aValues) {
            aWriter.println();
            aWriter.printf("  %s", value);
        }
        if (aValues.length > 0) {
            aWriter.println();
        }
        ValueChangeDumpHelper.writeCloseDeclaration(aWriter);
    }

    public static final void writeOpenDeclaration(PrintWriter aWriter, String aKeyword) {
        aWriter.printf("$%s", aKeyword).println();
    }

    public static final void writeTime(PrintWriter aWriter, long aTimebase) {
        aWriter.printf("#%d", aTimebase).println();
    }

    public static final void writeTimescale(PrintWriter aWriter, double aTimebase) {
        ValueChangeDumpHelper.writeDeclaration(aWriter, "timescale", ValueChangeDumpHelper.getTimescale(aTimebase));
    }

    public static final void writeVariable(PrintWriter aWriter, int aIndex, String aLabel) {
        aWriter.printf("$var wire 1 %s %s $end", ValueChangeDumpHelper.getIdentifier(aIndex), aLabel).println();
    }

    protected static final String getTimescale(double aTimebase) {
        int i;
        if (aTimebase < 0.0) {
            throw new IllegalArgumentException("Negative timebases are not supported!");
        }
        if (aTimebase == 0.0) {
            return "0 s";
        }
        String[] unitStrs = new String[]{"s", "ms", "us", "ns", "ps", "fs", "as"};
        double[] unitVals = new double[]{1.0, 0.001, 1.0E-6, 1.0E-9, 1.0E-12, 1.0E-15, 1.0E-18};
        double absTime = Math.abs(aTimebase);
        for (i = 0; i < unitVals.length && !(absTime >= unitVals[i]); ++i) {
        }
        i = Math.min(i, unitVals.length - 1);
        return String.format("%.0f %s", aTimebase / unitVals[i], unitStrs[i]);
    }

    private static final int normalizeTimebase(double aTime) {
        if (Double.isInfinite(aTime) || Double.isNaN(aTime)) {
            return 0;
        }
        if (aTime >= 100.0) {
            return 100;
        }
        if (aTime >= 10.0) {
            return 10;
        }
        return 1;
    }
}

