/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.api.data;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import nl.lxtreme.ols.api.acquisition.AcquisitionResult;
import nl.lxtreme.ols.api.data.Channel;
import nl.lxtreme.ols.api.data.ChannelAnnotation;
import nl.lxtreme.ols.api.data.ChannelAnnotations;
import nl.lxtreme.ols.api.data.Cursor;
import nl.lxtreme.ols.api.data.DataSet;
import nl.lxtreme.ols.api.data.project.ProjectManager;

@Deprecated
public final class DataContainer
implements AcquisitionResult {
    private final Map<Integer, ChannelAnnotations> annotations;
    private final ProjectManager projectManager;

    public DataContainer(ProjectManager aProjectManager) {
        if (aProjectManager == null) {
            throw new IllegalArgumentException("Project manager cannot be null!");
        }
        this.projectManager = aProjectManager;
        this.annotations = new HashMap<Integer, ChannelAnnotations>();
    }

    public void addChannelAnnotation(int aChannelIdx, long aStartTimestamp, long aEndTimestamp, Object aData) {
        if (aChannelIdx < 0 || aChannelIdx > 31) {
            throw new IllegalArgumentException("Invalid channel index: " + aChannelIdx + "! Should be between 0 and " + 32);
        }
        ChannelAnnotations annotations = this.annotations.get(aChannelIdx);
        if (annotations == null) {
            annotations = new ChannelAnnotations(aChannelIdx);
            this.annotations.put(aChannelIdx, annotations);
        }
        annotations.addAnnotation(aStartTimestamp, aEndTimestamp, aData);
    }

    public double calculateTime(int aSampleIndex) {
        double timestamp = this.calculateTimeOffset(this.getTimestamps()[aSampleIndex]);
        return timestamp / (double)this.getSampleRate();
    }

    public void clearChannelAnnotations(int aChannelIdx) {
        if (aChannelIdx < 0 || aChannelIdx > 31) {
            throw new IllegalArgumentException("Invalid channel index: " + aChannelIdx + "! Should be between 0 and " + 32);
        }
        this.annotations.remove(aChannelIdx);
    }

    @Override
    public long getAbsoluteLength() {
        return this.hasCapturedData() ? this.getAcquisitionData().getAbsoluteLength() : -1L;
    }

    public Channel[] getAllChannels() {
        return this.getCurrentDataSet().getChannels();
    }

    public int getBlockCount() {
        return (int)Math.min(4.0, Math.ceil((double)this.getChannels() / 8.0));
    }

    public ChannelAnnotation getChannelAnnotation(int aChannelIdx, int aTimeIndex) {
        if (aChannelIdx < 0 || aChannelIdx > 31) {
            throw new IllegalArgumentException("Invalid channel index: " + aChannelIdx + "! Should be between 0 and " + 32);
        }
        ChannelAnnotations channelAnnotations = this.annotations.get(aChannelIdx);
        if (channelAnnotations == null) {
            return null;
        }
        return channelAnnotations.getAnnotation(aTimeIndex);
    }

    public Iterator<ChannelAnnotation> getChannelAnnotations(int aChannelIdx, int aStartIdx, int aEndIdx) {
        if (aChannelIdx < 0 || aChannelIdx > 31) {
            throw new IllegalArgumentException("Invalid channel index: " + aChannelIdx + "! Should be between 0 and " + 32);
        }
        ChannelAnnotations channelAnnotations = this.annotations.get(aChannelIdx);
        if (channelAnnotations == null) {
            return Collections.emptyList().iterator();
        }
        return channelAnnotations.getAnnotations(aStartIdx, aEndIdx);
    }

    public String getChannelLabel(int aChannelIdx) {
        if (aChannelIdx < 0 || aChannelIdx > 31) {
            throw new IllegalArgumentException("Invalid channel index: " + aChannelIdx + "! Should be between 0 and " + 32);
        }
        return this.getAllChannels()[aChannelIdx].getLabel();
    }

    @Override
    public int getChannels() {
        return this.hasCapturedData() ? this.getAcquisitionData().getChannels() : -1;
    }

    public int getChannelsForBlock(int aBlockNr) {
        int remainder;
        int blockCount = this.getBlockCount();
        if (aBlockNr < 0 || aBlockNr >= blockCount) {
            throw new IllegalArgumentException("Invalid block number: " + aBlockNr + "!");
        }
        int result = 8;
        if (aBlockNr == blockCount - 1 && (remainder = this.getChannels() % 8) != 0) {
            result = remainder;
        }
        return result;
    }

    public Long getCursorPosition(int aCursorIdx) throws IllegalArgumentException {
        if (aCursorIdx < 0 || aCursorIdx > 9) {
            throw new IllegalArgumentException("Invalid cursor index: " + aCursorIdx + "! Should be between 0 and " + 10);
        }
        Cursor[] cursorPositions = this.getCursors();
        if (cursorPositions == null || cursorPositions[aCursorIdx] == null) {
            return null;
        }
        return cursorPositions[aCursorIdx].getTimestamp();
    }

    public Double getCursorTimeValue(int aCursorIdx) {
        if (!this.isCursorPositionSet(aCursorIdx)) {
            return null;
        }
        Long cursorPos = this.getCursorPosition(aCursorIdx);
        return (double)this.calculateTimeOffset(cursorPos) / (double)this.getAcquisitionData().getSampleRate();
    }

    @Override
    public int getEnabledChannels() {
        return this.hasCapturedData() ? this.getAcquisitionData().getEnabledChannels() : -1;
    }

    @Override
    public int getSampleIndex(long aAbs) {
        return this.hasCapturedData() ? this.getAcquisitionData().getSampleIndex(aAbs) : -1;
    }

    @Override
    public int getSampleRate() {
        return this.hasCapturedData() ? this.getAcquisitionData().getSampleRate() : -1;
    }

    @Override
    public long[] getTimestamps() {
        return this.hasCapturedData() ? this.getAcquisitionData().getTimestamps() : new long[]{};
    }

    @Override
    public long getTriggerPosition() {
        return this.hasCapturedData() && this.hasTriggerData() ? this.getAcquisitionData().getTriggerPosition() : -1L;
    }

    @Override
    public int[] getValues() {
        return this.hasCapturedData() ? this.getAcquisitionData().getValues() : new int[]{};
    }

    public boolean hasCapturedData() {
        return this.getAcquisitionData() != null;
    }

    @Override
    public boolean hasTimingData() {
        return this.hasCapturedData() ? this.getAcquisitionData().hasTimingData() : false;
    }

    @Override
    public boolean hasTriggerData() {
        return this.hasCapturedData() ? this.getAcquisitionData().hasTriggerData() : false;
    }

    public boolean isChannelLabelSet(int aChannelIdx) {
        if (aChannelIdx < 0 || aChannelIdx > 31) {
            throw new IllegalArgumentException("Invalid channel index: " + aChannelIdx + "! Should be between 0 and " + 32);
        }
        Channel channel = this.getAllChannels()[aChannelIdx];
        return channel.hasName();
    }

    public boolean isCursorPositionSet(int aCursorIdx) {
        if (aCursorIdx < 0 || aCursorIdx > 9) {
            throw new IllegalArgumentException("Invalid cursor index: " + aCursorIdx + "! Should be between 0 and " + 10);
        }
        Cursor[] cursorPositions = this.getCursors();
        if (cursorPositions == null) {
            return false;
        }
        return cursorPositions[aCursorIdx] != null && cursorPositions[aCursorIdx].isDefined();
    }

    public void setCapturedData(AcquisitionResult aData) {
        this.projectManager.getCurrentProject().setCapturedData(aData);
        this.annotations.clear();
    }

    public void setChannelAnnotations(int aChannelIdx, ChannelAnnotations aAnnotations) {
        if (aChannelIdx < 0 || aChannelIdx > 31) {
            throw new IllegalArgumentException("Invalid channel index: " + aChannelIdx + "! Should be between 0 and " + 32);
        }
        this.annotations.put(aChannelIdx, aAnnotations);
    }

    public void setChannelLabel(int aChannelIdx, String aLabel) {
        if (aChannelIdx < 0 || aChannelIdx > 31) {
            throw new IllegalArgumentException("Invalid channel index: " + aChannelIdx + "! Should be between 0 and " + 32);
        }
        this.getAllChannels()[aChannelIdx].setLabel(aLabel);
    }

    public void setChannelLabels(String[] aLabels) {
        if (aLabels.length != 32) {
            throw new IllegalArgumentException("Invalid channel labels! Should have exact 32 items!");
        }
        for (int i = 0; i < aLabels.length; ++i) {
            this.getAllChannels()[i].setLabel(aLabels[i]);
        }
    }

    public void setCursorPosition(int aCursorIdx, Long aCursorPosition) throws IllegalArgumentException {
        if (aCursorIdx < 0 || aCursorIdx > 9) {
            throw new IllegalArgumentException("Invalid cursor index! Should be between 0 and 10");
        }
        Cursor[] cursorPositions = this.getCursors();
        if (cursorPositions != null) {
            if (aCursorPosition == null || aCursorPosition == Long.MIN_VALUE) {
                cursorPositions[aCursorIdx].clear();
            } else {
                cursorPositions[aCursorIdx].setTimestamp(aCursorPosition);
            }
        }
    }

    protected long calculateTimeOffset(long aTime) {
        AcquisitionResult capturedData = this.getAcquisitionData();
        if (capturedData.hasTriggerData()) {
            return aTime - capturedData.getTriggerPosition();
        }
        return aTime;
    }

    private AcquisitionResult getAcquisitionData() {
        return this.getCurrentDataSet().getCapturedData();
    }

    private DataSet getCurrentDataSet() {
        return this.projectManager.getCurrentProject().getDataSet();
    }

    private Cursor[] getCursors() {
        return this.getCurrentDataSet().getCursors();
    }
}

