/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.client.osgi;

import java.awt.Font;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import nl.lxtreme.ols.util.ColorUtils;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;

public class UIManagerConfigurator
implements ManagedService {
    public static final String PID = "ols.ui.defaults";
    private static final String PREFIX = "ols.";
    private static final String FONT_SUFFIX = ".font";
    private static final String COLOR_SUFFIX = ".color";
    private static final String FLOAT_SUFFIX = ".float";
    private static final String ENUM_SUFFIX = ".enum";
    private static final String BOOLEAN_SUFFIX = ".boolean";

    public void updated(Dictionary aProperties) throws ConfigurationException {
        this.removeOlsSpecificKeys();
        if (aProperties != null) {
            this.applyOlsSpecificKeys(aProperties);
        }
    }

    private Font applyFontSize(Font aResult, String aSize) {
        if (aSize.endsWith("em")) {
            float factor = Float.parseFloat(aSize.substring(0, aSize.length() - 2));
            return aResult.deriveFont(aResult.getSize2D() * factor);
        }
        if (aSize.endsWith("%")) {
            float factor = Float.parseFloat(aSize.substring(0, aSize.length() - 1));
            return aResult.deriveFont(aResult.getSize2D() * (factor / 100.0f));
        }
        int pointSize = Integer.parseInt(aSize);
        return aResult.deriveFont(pointSize);
    }

    private Font applyFontVariant(Font aResult, String aVariant) {
        if ("bold".equalsIgnoreCase(aVariant)) {
            return aResult.deriveFont(1);
        }
        if ("italic".equalsIgnoreCase(aVariant) || "oblique".equalsIgnoreCase(aVariant)) {
            return aResult.deriveFont(2);
        }
        return aResult;
    }

    private void applyOlsSpecificKeys(Dictionary aProperties) throws ConfigurationException {
        Properties config = new Properties();
        Enumeration keys = aProperties.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            if (!key.startsWith(PREFIX)) continue;
            try {
                Object value = this.parseAsValue(key, aProperties.get(key));
                if (value == null) continue;
                config.put(key, value);
            }
            catch (Exception exception) {
                System.err.println("Configuration problem for '" + key + "' (value = '" + aProperties.get(key) + "')!");
                exception.printStackTrace();
                throw new ConfigurationException(key, "Unable to parse value!", (Throwable)exception);
            }
        }
        this.replacePlaceholders(config);
        UIDefaults defaults = UIManager.getDefaults();
        for (Map.Entry<Object, Object> entry : config.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            defaults.put(key, value);
        }
    }

    private Object parseAsValue(String aKey, Object aObject) {
        String value = aObject.toString().trim();
        if ("".equals(value)) {
            return null;
        }
        if (aKey.endsWith(BOOLEAN_SUFFIX)) {
            return Boolean.valueOf(value);
        }
        if (aKey.endsWith(COLOR_SUFFIX)) {
            return ColorUtils.parseColor((String)value);
        }
        if (aKey.endsWith(ENUM_SUFFIX)) {
            return value;
        }
        if (aKey.endsWith(FLOAT_SUFFIX)) {
            return Float.valueOf(value);
        }
        if (aKey.endsWith(FONT_SUFFIX)) {
            return this.parseFontValue(value);
        }
        return Integer.valueOf(value);
    }

    private Object parseFontValue(String value) {
        String regex = "\\s*(%\\{[^}]+\\}|[\\s]+)\\s*(?i)(bold|italic|plain)?\\s*([^\\s]+)?\\s*";
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(value);
        if (m.matches()) {
            String name = m.group(1);
            String variant = m.group(2);
            String size = m.group(3);
            Font result = name.startsWith("%") ? UIManager.getFont(name.substring(2, name.length() - 1)) : Font.decode(name);
            if (size != null) {
                result = this.applyFontSize(result, size);
            }
            if (variant != null) {
                result = this.applyFontVariant(result, variant);
            }
            return result;
        }
        return null;
    }

    private void removeOlsSpecificKeys() {
        UIDefaults defaults = UIManager.getDefaults();
        Enumeration keys = defaults.keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            if (!key.toString().startsWith(PREFIX)) continue;
            defaults.put(key, (Object)null);
        }
    }

    private void replacePlaceholders(Properties aConfig) throws ConfigurationException {
        ArrayList<Object> keySet = new ArrayList<Object>(aConfig.keySet());
        for (Object e : keySet) {
            Object value = aConfig.get(e);
            if (!(value instanceof String) || !((String)value).matches("\\$\\{[^}]+\\}")) continue;
            String v = (String)value;
            Object newValue = aConfig.get(v = v.substring(2, v.length() - 1));
            if (newValue == null) {
                throw new ConfigurationException(e.toString(), "Missing value for placeholder!");
            }
            aConfig.put(e, newValue);
        }
    }
}

