/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.tool.jtag;

import nl.lxtreme.ols.api.data.BaseData;
import nl.lxtreme.ols.tool.jtag.JTAGState;

public final class JTAGData
extends BaseData<JTAGData> {
    private final JTAGState dataValue;
    private final String dataName;

    public JTAGData(int aIdx, int aChannelIdx, String aEvent, int aSampleIdx) {
        super(aIdx, aChannelIdx, aSampleIdx, aEvent);
        this.dataValue = null;
        this.dataName = null;
    }

    public JTAGData(int aIdx, int aChannelIdx, String aDataName, JTAGState aDataValue, int aStartSampleIdx, int aEndSampleIdx) {
        super(aIdx, aChannelIdx, aStartSampleIdx, aEndSampleIdx);
        this.dataName = aDataName;
        this.dataValue = aDataValue;
    }

    public boolean equals(Object aObject) {
        if (this == aObject) {
            return true;
        }
        if (!super.equals(aObject) || !(aObject instanceof JTAGData)) {
            return false;
        }
        JTAGData other = (JTAGData)((Object)aObject);
        return this.dataValue == other.dataValue;
    }

    public String getDataName() {
        return this.dataName;
    }

    public final JTAGState getDataValue() {
        return this.dataValue;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        if (this.dataValue != null) {
            result = 31 * result + this.dataValue.hashCode();
        }
        return result;
    }

    public boolean isData() {
        return this.dataName != null && !this.dataName.trim().isEmpty();
    }

    public final boolean isTdiData() {
        return "TDI".equals(this.dataName);
    }

    public final boolean isTdoData() {
        return "TDO".equals(this.dataName);
    }
}

