/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.util.swing.component;

import java.awt.Dimension;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.accessibility.Accessible;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JScrollPane;
import javax.swing.MutableComboBoxModel;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.basic.BasicComboPopup;

public class JLazyComboBox
extends JComboBox {
    private static final long serialVersionUID = -4065089150844005742L;

    public JLazyComboBox(ItemProvider aItemProvider) {
        super(new DefaultComboBoxModel());
        this.addPopupMenuListener(new ComboboxPopupListener(aItemProvider));
    }

    static final class ComboboxPopupListener
    implements PopupMenuListener {
        private static final Method popupHeightForRowCountMethod;
        private final ItemProvider itemProvider;

        public ComboboxPopupListener(ItemProvider aItemProvider) {
            this.itemProvider = aItemProvider;
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent aEvent) {
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent aEvent) {
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent aEvent) {
            JComboBox combobox = (JComboBox)aEvent.getSource();
            Dimension originalPreferredSize = combobox.getPreferredSize();
            if (combobox.getItemCount() <= 0) {
                Object[] items;
                MutableComboBoxModel model = (MutableComboBoxModel)combobox.getModel();
                for (Object item : items = this.itemProvider.getItems()) {
                    model.addElement(item);
                }
                this.correctSize(combobox, originalPreferredSize, items.length);
            }
        }

        private void correctSize(JComboBox aComboBox, Dimension aPreferredSize, int aAddedItemCount) {
            aComboBox.setPreferredSize(aPreferredSize);
            if (aAddedItemCount > 0) {
                Accessible comp = aComboBox.getUI().getAccessibleChild(aComboBox, 0);
                if (!(comp instanceof BasicComboPopup)) {
                    return;
                }
                BasicComboPopup popup = (BasicComboPopup)comp;
                JScrollPane scrollPane = (JScrollPane)popup.getComponent(0);
                int newWidth = Math.max(scrollPane.getPreferredSize().width, aPreferredSize.width);
                int newHeight = this.getPopupHeightForRowCount(popup, Math.min(aComboBox.getMaximumRowCount(), aAddedItemCount));
                Dimension size = new Dimension(newWidth, newHeight);
                scrollPane.setPreferredSize(size);
                scrollPane.setMaximumSize(size);
            }
        }

        private int getPopupHeightForRowCount(BasicComboPopup aPopup, int aItemCount) {
            try {
                Integer result = (Integer)popupHeightForRowCountMethod.invoke((Object)aPopup, aItemCount);
                return result;
            }
            catch (IllegalAccessException exception) {
                throw new RuntimeException("BasicComboPopup#getPopupHeightForRowCount not accessible?!", exception);
            }
            catch (InvocationTargetException exception) {
                throw new RuntimeException("BasicComboPopup#getPopupHeightForRowCount throws exception?!", exception.getCause());
            }
        }

        static {
            try {
                popupHeightForRowCountMethod = BasicComboPopup.class.getDeclaredMethod("getPopupHeightForRowCount", Integer.TYPE);
                popupHeightForRowCountMethod.setAccessible(true);
            }
            catch (SecurityException exception) {
                throw new RuntimeException("Security exception while trying to access BasicComboPopup#getPopupHeightForRowCount!", exception);
            }
            catch (NoSuchMethodException exception) {
                throw new RuntimeException("No such method: BasicComboPopup#getPopupHeightForRowCount()?!", exception);
            }
        }
    }

    public static interface ItemProvider {
        public Object[] getItems();
    }
}

