/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.cm.impl;

import java.io.IOException;
import java.security.SecureRandom;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Random;
import org.apache.felix.cm.PersistenceManager;
import org.apache.felix.cm.file.FilePersistenceManager;
import org.apache.felix.cm.impl.CachingPersistenceManagerProxy;
import org.apache.felix.cm.impl.CaseInsensitiveDictionary;
import org.apache.felix.cm.impl.ConfigurationAdminFactory;
import org.apache.felix.cm.impl.ConfigurationAdminImpl;
import org.apache.felix.cm.impl.ConfigurationImpl;
import org.apache.felix.cm.impl.DynamicBindings;
import org.apache.felix.cm.impl.Factory;
import org.apache.felix.cm.impl.RankingComparator;
import org.apache.felix.cm.impl.UpdateThread;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ConfigurationEvent;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ConfigurationListener;
import org.osgi.service.cm.ConfigurationPermission;
import org.osgi.service.cm.ConfigurationPlugin;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.cm.ManagedServiceFactory;
import org.osgi.service.log.LogService;
import org.osgi.util.tracker.ServiceTracker;

public class ConfigurationManager
implements BundleActivator,
BundleListener {
    public static final String CM_CONFIG_DIR = "felix.cm.dir";
    public static final String CM_LOG_LEVEL = "felix.cm.loglevel";
    private static final String LOG_SERVICE_NAME = "org.osgi.service.log.LogService";
    private static final int CM_LOG_LEVEL_DEFAULT = 2;
    private static Random numberGenerator;
    private BundleContext bundleContext;
    private volatile ServiceRegistration configurationAdminRegistration;
    private ServiceTracker logTracker;
    private ServiceTracker configurationListenerTracker;
    private ServiceTracker managedServiceTracker;
    private ServiceTracker managedServiceFactoryTracker;
    private ServiceTracker persistenceManagerTracker;
    private UpdateThread updateThread;
    private UpdateThread eventThread;
    private PersistenceManager[] persistenceManagers;
    private int pmtCount;
    private final Map factories = new HashMap();
    private final Map configurations = new HashMap();
    private DynamicBindings dynamicBindings;
    private int logLevel = 2;
    private volatile boolean handleBundleEvents;
    private volatile boolean isActive;

    public void start(BundleContext bundleContext) {
        Hashtable<String, Object> props;
        this.logTracker = new ServiceTracker(bundleContext, LOG_SERVICE_NAME, null);
        this.logTracker.open();
        String logLevelProp = bundleContext.getProperty(CM_LOG_LEVEL);
        if (logLevelProp == null) {
            this.logLevel = 2;
        } else {
            try {
                this.logLevel = Integer.parseInt(logLevelProp);
            }
            catch (NumberFormatException nfe) {
                this.logLevel = 2;
            }
        }
        this.bundleContext = bundleContext;
        this.configurationListenerTracker = new ServiceTracker(bundleContext, ConfigurationListener.class.getName(), null);
        this.configurationListenerTracker.open();
        ThreadGroup tg = new ThreadGroup("Configuration Admin Service");
        tg.setDaemon(true);
        this.updateThread = new UpdateThread(this, tg, "CM Configuration Updater");
        this.eventThread = new UpdateThread(this, tg, "CM Event Dispatcher");
        try {
            FilePersistenceManager fpm = new FilePersistenceManager(bundleContext, bundleContext.getProperty(CM_CONFIG_DIR));
            props = new Hashtable<String, Object>();
            props.put("service.pid", fpm.getClass().getName());
            props.put("service.description", "Platform Filesystem Persistence Manager");
            props.put("service.vendor", "Apache Software Foundation");
            props.put("service.ranking", new Integer(Integer.MIN_VALUE));
            bundleContext.registerService(PersistenceManager.class.getName(), (Object)fpm, props);
            this.dynamicBindings = new DynamicBindings(bundleContext, fpm);
        }
        catch (IOException ioe) {
            this.log(1, "Failure setting up dynamic configuration bindings", ioe);
        }
        catch (IllegalArgumentException iae) {
            this.log(1, "Cannot create the FilePersistenceManager", iae);
        }
        this.handleBundleEvents = true;
        bundleContext.addBundleListener((BundleListener)this);
        this.pmtCount = 1;
        this.persistenceManagerTracker = new ServiceTracker(bundleContext, PersistenceManager.class.getName(), null);
        this.persistenceManagerTracker.open();
        this.isActive = true;
        ConfigurationAdminFactory caf = new ConfigurationAdminFactory(this);
        props = new Hashtable();
        props.put("service.pid", "org.apache.felix.cm.ConfigurationAdmin");
        props.put("service.description", "Configuration Admin Service Specification 1.2 Implementation");
        props.put("service.vendor", "Apache Software Foundation");
        this.configurationAdminRegistration = bundleContext.registerService(ConfigurationAdmin.class.getName(), (Object)caf, props);
        this.updateThread.start();
        this.eventThread.start();
        this.managedServiceTracker = new ManagedServiceTracker(this);
        this.managedServiceFactoryTracker = new ManagedServiceFactoryTracker(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(BundleContext bundleContext) {
        this.handleBundleEvents = false;
        if (this.updateThread != null) {
            this.updateThread.terminate();
        }
        if (this.eventThread != null) {
            this.eventThread.terminate();
        }
        if (this.configurationAdminRegistration != null) {
            ServiceRegistration reg = this.configurationAdminRegistration;
            this.configurationAdminRegistration = null;
            reg.unregister();
        }
        this.isActive = false;
        this.managedServiceFactoryTracker.close();
        this.managedServiceTracker.close();
        this.persistenceManagerTracker.close();
        bundleContext.removeBundleListener((BundleListener)this);
        if (this.configurationListenerTracker != null) {
            this.configurationListenerTracker.close();
        }
        if (this.logTracker != null) {
            this.logTracker.close();
        }
        Map map = this.configurations;
        synchronized (map) {
            this.configurations.clear();
        }
        map = this.factories;
        synchronized (map) {
            this.factories.clear();
        }
        this.bundleContext = null;
    }

    boolean isActive() {
        return this.isActive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ConfigurationImpl getCachedConfiguration(String pid) {
        Map map = this.configurations;
        synchronized (map) {
            return (ConfigurationImpl)this.configurations.get(pid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ConfigurationImpl[] getCachedConfigurations() {
        Map map = this.configurations;
        synchronized (map) {
            return this.configurations.values().toArray(new ConfigurationImpl[this.configurations.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ConfigurationImpl cacheConfiguration(ConfigurationImpl configuration) {
        Map map = this.configurations;
        synchronized (map) {
            Object existing = this.configurations.get(configuration.getPid());
            if (existing != null) {
                return (ConfigurationImpl)existing;
            }
            this.configurations.put(configuration.getPid(), configuration);
            return configuration;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeConfiguration(ConfigurationImpl configuration) {
        Map map = this.configurations;
        synchronized (map) {
            this.configurations.remove(configuration.getPid());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Factory getCachedFactory(String factoryPid) {
        Map map = this.factories;
        synchronized (map) {
            return (Factory)this.factories.get(factoryPid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Factory[] getCachedFactories() {
        Map map = this.factories;
        synchronized (map) {
            return this.factories.values().toArray(new Factory[this.factories.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cacheFactory(Factory factory) {
        Map map = this.factories;
        synchronized (map) {
            this.factories.put(factory.getFactoryPid(), factory);
        }
    }

    void setDynamicBundleLocation(String pid, String location) {
        if (this.dynamicBindings != null) {
            try {
                this.dynamicBindings.putLocation(pid, location);
            }
            catch (IOException ioe) {
                this.log(1, "Failed storing dynamic configuration binding for {0} to {1}", new Object[]{pid, location, ioe});
            }
        }
    }

    String getDynamicBundleLocation(String pid) {
        if (this.dynamicBindings != null) {
            return this.dynamicBindings.getLocation(pid);
        }
        return null;
    }

    ConfigurationImpl createFactoryConfiguration(String factoryPid, String location) throws IOException {
        return this.cacheConfiguration(this.createConfiguration(ConfigurationManager.createPid(factoryPid), factoryPid, location));
    }

    ConfigurationImpl getConfiguration(String pid) throws IOException {
        ConfigurationImpl config = this.getCachedConfiguration(pid);
        if (config != null) {
            this.log(4, "Found cached configuration {0} bound to {1}", new Object[]{pid, config.getBundleLocation()});
            config.ensureFactoryConfigPersisted();
            return config;
        }
        PersistenceManager[] pmList = this.getPersistenceManagers();
        for (int i = 0; i < pmList.length; ++i) {
            if (!pmList[i].exists(pid)) continue;
            Dictionary props = pmList[i].load(pid);
            config = new ConfigurationImpl(this, pmList[i], props);
            this.log(4, "Found existing configuration {0} bound to {1}", new Object[]{pid, config.getBundleLocation()});
            return this.cacheConfiguration(config);
        }
        return null;
    }

    ConfigurationImpl createConfiguration(String pid, String bundleLocation) throws IOException {
        ConfigurationImpl config = this.getConfiguration(pid);
        if (config != null) {
            return config;
        }
        config = this.createConfiguration(pid, null, bundleLocation);
        return this.cacheConfiguration(config);
    }

    ConfigurationImpl[] listConfigurations(ConfigurationAdminImpl configurationAdmin, String filterString) throws IOException, InvalidSyntaxException {
        Filter filter = null;
        if (filterString != null) {
            filter = this.bundleContext.createFilter(filterString);
        }
        this.log(4, "Listing configurations matching {0}", new Object[]{filterString});
        ArrayList<ConfigurationImpl> configList = new ArrayList<ConfigurationImpl>();
        PersistenceManager[] pmList = this.getPersistenceManagers();
        for (int i = 0; i < pmList.length; ++i) {
            Enumeration configs = pmList[i].getDictionaries();
            while (configs.hasMoreElements()) {
                Dictionary config = (Dictionary)configs.nextElement();
                String pid = (String)config.get("service.pid");
                if (pid == null) continue;
                if (!configurationAdmin.hasPermission((String)config.get("service.bundleLocation"))) {
                    this.log(4, "Omitting configuration {0}: No permission for bundle {1} on configuration bound to {2}", new Object[]{config.get("service.pid"), configurationAdmin.getBundle().getLocation(), config.get("service.bundleLocation")});
                    continue;
                }
                if (filter == null || filter.match(config)) {
                    ConfigurationImpl cfg = this.getCachedConfiguration(pid);
                    if (cfg == null) {
                        cfg = new ConfigurationImpl(this, pmList[i], config);
                    }
                    if (!cfg.isNew()) {
                        this.log(4, "Adding configuration {0}", new Object[]{config.get("service.pid")});
                        configList.add(cfg);
                        continue;
                    }
                    this.log(4, "Omitting configuration {0}: Is new", new Object[]{config.get("service.pid")});
                    continue;
                }
                this.log(4, "Omitting configuration {0}: Does not match filter", new Object[]{config.get("service.pid")});
            }
        }
        return configList.toArray(new ConfigurationImpl[configList.size()]);
    }

    void deleted(ConfigurationImpl config) {
        this.removeConfiguration(config);
        this.fireConfigurationEvent(2, config.getPid(), config.getFactoryPid());
        this.updateThread.schedule(new DeleteConfiguration(config));
        this.log(4, "DeleteConfiguration({0}) scheduled", new Object[]{config.getPid()});
    }

    void updated(ConfigurationImpl config, boolean fireEvent) {
        if (fireEvent) {
            this.fireConfigurationEvent(1, config.getPid(), config.getFactoryPid());
        }
        this.updateThread.schedule(new UpdateConfiguration(config));
        this.log(4, "UpdateConfiguration({0}) scheduled", new Object[]{config.getPid()});
    }

    void locationChanged(ConfigurationImpl config, String oldLocation) {
        this.fireConfigurationEvent(3, config.getPid(), config.getFactoryPid());
        if (oldLocation != null && !config.isNew()) {
            this.updateThread.schedule(new LocationChanged(config, oldLocation));
            this.log(4, "LocationChanged({0}, {1}=>{2}) scheduled", new Object[]{config.getPid(), oldLocation, config.getBundleLocation()});
        } else {
            this.log(4, "LocationChanged not scheduled for {0} (old location is null or configuration is new)", new Object[]{config.getPid()});
        }
    }

    void fireConfigurationEvent(int type, String pid, String factoryPid) {
        FireConfigurationEvent event = new FireConfigurationEvent(type, pid, factoryPid);
        if (event.hasConfigurationEventListeners()) {
            this.eventThread.schedule(event);
        } else {
            this.log(4, "No ConfigurationListeners to send {0} event to.", new Object[]{event.getTypeName()});
        }
    }

    public void bundleChanged(BundleEvent event) {
        if (event.getType() == 16 && this.handleBundleEvents) {
            String location = event.getBundle().getLocation();
            ConfigurationImpl[] configs = this.getCachedConfigurations();
            for (int i = 0; i < configs.length; ++i) {
                ConfigurationImpl cfg = configs[i];
                if (!location.equals(cfg.getDynamicBundleLocation())) continue;
                cfg.setDynamicBundleLocation(null, true);
            }
        }
    }

    private PersistenceManager[] getPersistenceManagers() {
        int currentPmtCount = this.persistenceManagerTracker.getTrackingCount();
        if (this.persistenceManagers == null || currentPmtCount > this.pmtCount) {
            PersistenceManager[] pm;
            ArrayList<CachingPersistenceManagerProxy> pmList = new ArrayList<CachingPersistenceManagerProxy>();
            ServiceReference<S>[] refs = this.persistenceManagerTracker.getServiceReferences();
            if (refs == null || refs.length == 0) {
                pm = new PersistenceManager[]{};
            } else {
                if (refs.length > 1) {
                    Arrays.sort(refs, RankingComparator.SRV_RANKING);
                }
                for (int i = 0; i < refs.length; ++i) {
                    Object service = this.persistenceManagerTracker.getService(refs[i]);
                    if (service == null) continue;
                    pmList.add(new CachingPersistenceManagerProxy((PersistenceManager)service));
                }
                pm = pmList.toArray(new PersistenceManager[pmList.size()]);
            }
            this.pmtCount = pm.length;
            this.persistenceManagers = pm;
        }
        return this.persistenceManagers;
    }

    private ServiceReference getServiceReference() {
        ServiceRegistration reg = this.configurationAdminRegistration;
        return reg != null ? reg.getReference() : null;
    }

    private void configure(String[] pids, ServiceReference sr, ManagedService service) {
        if (pids != null) {
            if (this.isLogEnabled(4)) {
                this.log(4, "configure(ManagedService {0})", new Object[]{ConfigurationManager.toString(sr)});
            }
            for (int i = 0; i < pids.length; ++i) {
                ManagedServiceUpdate update = new ManagedServiceUpdate(pids[i], sr, service);
                this.updateThread.schedule(update);
                this.log(4, "ManagedServiceUpdate({0}) scheduled", new Object[]{pids[i]});
            }
        }
    }

    private void configure(String[] pids, ServiceReference sr, ManagedServiceFactory service) {
        if (pids != null) {
            if (this.isLogEnabled(4)) {
                this.log(4, "configure(ManagedServiceFactory {0})", new Object[]{ConfigurationManager.toString(sr)});
            }
            for (int i = 0; i < pids.length; ++i) {
                ManagedServiceFactoryUpdate update = new ManagedServiceFactoryUpdate(pids[i], sr, service);
                this.updateThread.schedule(update);
                this.log(4, "ManagedServiceFactoryUpdate({0}) scheduled", new Object[]{pids[i]});
            }
        }
    }

    ConfigurationImpl createConfiguration(String pid, String factoryPid, String bundleLocation) throws IOException {
        this.log(4, "createConfiguration({0}, {1}, {2})", new Object[]{pid, factoryPid, bundleLocation});
        return new ConfigurationImpl(this, this.getPersistenceManagers()[0], pid, factoryPid, bundleLocation);
    }

    Factory getFactory(String factoryPid) throws IOException {
        Factory factory = this.getCachedFactory(factoryPid);
        if (factory != null) {
            return factory;
        }
        PersistenceManager[] pmList = this.getPersistenceManagers();
        for (int i = 0; i < pmList.length; ++i) {
            if (!Factory.exists(pmList[i], factoryPid)) continue;
            factory = Factory.load(this, pmList[i], factoryPid);
            this.cacheFactory(factory);
            return factory;
        }
        return this.createFactory(factoryPid);
    }

    Factory createFactory(String factoryPid) {
        Factory factory = new Factory(this, this.getPersistenceManagers()[0], factoryPid);
        this.cacheFactory(factory);
        return factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void callPlugins(Dictionary props, String targetPid, ServiceReference sr, ConfigurationImpl cfg) {
        if (props == null) {
            return;
        }
        ServiceReference[] plugins = null;
        try {
            String filter = "(|(!(cm.target=*))(cm.target=" + targetPid + "))";
            plugins = this.bundleContext.getServiceReferences(ConfigurationPlugin.class.getName(), filter);
        }
        catch (InvalidSyntaxException ise) {
            // empty catch block
        }
        if (plugins == null || plugins.length == 0) {
            return;
        }
        if (plugins.length > 1) {
            Arrays.sort(plugins, RankingComparator.CM_RANKING);
        }
        for (int i = 0; i < plugins.length; ++i) {
            ServiceReference pluginRef = plugins[i];
            ConfigurationPlugin plugin = (ConfigurationPlugin)this.bundleContext.getService(pluginRef);
            if (plugin == null) continue;
            try {
                plugin.modifyConfiguration(sr, props);
            }
            catch (Throwable t) {
                this.log(1, "Unexpected problem calling configuration plugin {0}", new Object[]{ConfigurationManager.toString(pluginRef), t});
            }
            finally {
                this.bundleContext.ungetService(pluginRef);
            }
            cfg.setAutoProperties(props, false);
        }
    }

    private static String createPid(String factoryPid) {
        Random ng = numberGenerator;
        if (ng == null) {
            try {
                ng = new SecureRandom();
            }
            catch (Throwable t) {
                ng = new Random();
            }
        }
        byte[] randomBytes = new byte[16];
        ng.nextBytes(randomBytes);
        randomBytes[6] = (byte)(randomBytes[6] & 0xF);
        randomBytes[6] = (byte)(randomBytes[6] | 0x40);
        randomBytes[8] = (byte)(randomBytes[8] & 0x3F);
        randomBytes[8] = (byte)(randomBytes[8] | 0x80);
        StringBuffer buf = new StringBuffer(factoryPid.length() + 1 + 36);
        buf.append(factoryPid).append(".");
        for (int i = 0; i < randomBytes.length; ++i) {
            if (i == 4 || i == 6 || i == 8 || i == 10) {
                buf.append('-');
            }
            int val = randomBytes[i] & 0xFF;
            buf.append(Integer.toHexString(val >> 4));
            buf.append(Integer.toHexString(val & 0xF));
        }
        return buf.toString();
    }

    boolean isLogEnabled(int level) {
        return level <= this.logLevel;
    }

    void log(int level, String format, Object[] args) {
        if (this.isLogEnabled(level)) {
            Throwable throwable = null;
            String message = format;
            if (args != null && args.length > 0) {
                if (args[args.length - 1] instanceof Throwable) {
                    throwable = (Throwable)args[args.length - 1];
                }
                message = MessageFormat.format(format, args);
            }
            this.log(level, message, throwable);
        }
    }

    void log(int level, String message, Throwable t) {
        Object log = this.logTracker.getService();
        if (log != null) {
            ((LogService)log).log(this.getServiceReference(), level, message, t);
            return;
        }
        if (this.isLogEnabled(level)) {
            String code;
            switch (level) {
                case 3: {
                    code = "*INFO *";
                    break;
                }
                case 2: {
                    code = "*WARN *";
                    break;
                }
                case 1: {
                    code = "*ERROR*";
                    break;
                }
                default: {
                    code = "*DEBUG*";
                }
            }
            System.err.println(code + " " + message);
            if (t != null) {
                t.printStackTrace(System.err);
            }
        }
    }

    static String[] getServicePid(ServiceReference reference) {
        Object pidObj = reference.getProperty("service.pid");
        if (pidObj instanceof String) {
            return new String[]{(String)pidObj};
        }
        if (pidObj instanceof String[]) {
            return (String[])pidObj;
        }
        if (pidObj instanceof Collection) {
            Collection pidCollection = (Collection)pidObj;
            return pidCollection.toArray(new String[pidCollection.size()]);
        }
        return null;
    }

    static String toString(ServiceReference ref) {
        String[] ocs = (String[])ref.getProperty("objectClass");
        StringBuffer buf = new StringBuffer("[");
        for (int i = 0; i < ocs.length; ++i) {
            buf.append(ocs[i]);
            if (i >= ocs.length - 1) continue;
            buf.append(", ");
        }
        buf.append(", id=").append(ref.getProperty("service.id"));
        Bundle provider = ref.getBundle();
        if (provider != null) {
            buf.append(", bundle=").append(provider.getBundleId());
            buf.append('/').append(provider.getLocation());
        } else {
            buf.append(", unregistered");
        }
        buf.append("]");
        return buf.toString();
    }

    void handleCallBackError(Throwable error, ServiceReference target, ConfigurationImpl config) {
        if (error instanceof ConfigurationException) {
            ConfigurationException ce = (ConfigurationException)error;
            if (ce.getProperty() != null) {
                this.log(1, "{0}: Updating property {1} of configuration {2} caused a problem: {3}", new Object[]{ConfigurationManager.toString(target), ce.getProperty(), config.getPid(), ce.getReason(), ce});
            } else {
                this.log(1, "{0}: Updating configuration {1} caused a problem: {2}", new Object[]{ConfigurationManager.toString(target), config.getPid(), ce.getReason(), ce});
            }
        } else {
            this.log(1, "{0}: Unexpected problem updating configuration {1}", new Object[]{ConfigurationManager.toString(target), config, error});
        }
    }

    boolean canReceive(Bundle bundle, String location) {
        if (location == null) {
            this.log(4, "canReceive=true; bundle={0}; configuration=(unbound)", new Object[]{bundle.getLocation()});
            return true;
        }
        if (location.startsWith("?")) {
            if (System.getSecurityManager() != null) {
                boolean hasPermission = bundle.hasPermission((Object)new ConfigurationPermission(location, "target"));
                this.log(4, "canReceive={0}: bundle={1}; configuration={2} (SecurityManager check)", new Object[]{new Boolean(hasPermission), bundle.getLocation(), location});
                return hasPermission;
            }
            this.log(4, "canReceive=true; bundle={0}; configuration={1} (no SecurityManager)", new Object[]{bundle.getLocation(), location});
            return true;
        }
        boolean hasPermission = location.equals(bundle.getLocation());
        this.log(4, "canReceive={0}: bundle={1}; configuration={2}", new Object[]{new Boolean(hasPermission), bundle.getLocation(), location});
        return hasPermission;
    }

    private ServiceHelper createServiceHelper(ConfigurationImpl config) {
        if (config.getFactoryPid() == null) {
            return new ManagedServiceHelper(config);
        }
        return new ManagedServiceFactoryHelper(config);
    }

    private static class ManagedServiceHolder {
        private final Object managedService;
        private String[] configuredPids;

        ManagedServiceHolder(Object managedService, String[] configuredPids) {
            this.managedService = managedService;
            this.configuredPids = configuredPids;
        }

        public Object getManagedService() {
            return this.managedService;
        }

        public void setConfiguredPids(String[] configuredPids) {
            this.configuredPids = configuredPids;
        }

        boolean isDifferentPids(String[] pids) {
            HashSet<String> otherPids;
            if (this.configuredPids == null && pids == null) {
                return false;
            }
            if (this.configuredPids == null) {
                return true;
            }
            if (pids == null) {
                return true;
            }
            if (this.configuredPids.length != pids.length) {
                return true;
            }
            HashSet<String> thisPids = new HashSet<String>(Arrays.asList(this.configuredPids));
            return !thisPids.equals(otherPids = new HashSet<String>(Arrays.asList(pids)));
        }
    }

    private static class ManagedServiceFactoryTracker
    extends ServiceTracker {
        private final ConfigurationManager cm;

        ManagedServiceFactoryTracker(ConfigurationManager cm) {
            super(cm.bundleContext, ManagedServiceFactory.class.getName(), null);
            this.cm = cm;
            this.open();
        }

        public Object addingService(ServiceReference reference) {
            String[] pids;
            Object serviceObject = super.addingService(reference);
            if (serviceObject instanceof ManagedServiceFactory) {
                pids = ConfigurationManager.getServicePid(reference);
                this.cm.configure(pids, reference, (ManagedServiceFactory)serviceObject);
            } else {
                this.cm.log(2, "Service {0} is not a ManagedServiceFactory", new Object[]{serviceObject});
                pids = null;
            }
            return new ManagedServiceHolder(serviceObject, pids);
        }

        public void modifiedService(ServiceReference reference, Object service) {
            ManagedServiceHolder holder = (ManagedServiceHolder)service;
            String[] pids = ConfigurationManager.getServicePid(reference);
            if (holder.isDifferentPids(pids)) {
                this.cm.configure(pids, reference, (ManagedServiceFactory)holder.getManagedService());
                holder.setConfiguredPids(pids);
            }
            super.modifiedService(reference, service);
        }

        public void removedService(ServiceReference reference, Object service) {
            Object serviceObject = ((ManagedServiceHolder)service).getManagedService();
            super.removedService(reference, serviceObject);
        }
    }

    private static class ManagedServiceTracker
    extends ServiceTracker {
        private final ConfigurationManager cm;

        ManagedServiceTracker(ConfigurationManager cm) {
            super(cm.bundleContext, ManagedService.class.getName(), null);
            this.cm = cm;
            this.open();
        }

        public Object addingService(ServiceReference reference) {
            String[] pids;
            Object service = super.addingService(reference);
            if (service instanceof ManagedService) {
                pids = ConfigurationManager.getServicePid(reference);
                this.cm.configure(pids, reference, (ManagedService)service);
            } else {
                this.cm.log(2, "Service {0} is not a ManagedService", new Object[]{service});
                pids = null;
            }
            return new ManagedServiceHolder(service, pids);
        }

        public void modifiedService(ServiceReference reference, Object service) {
            ManagedServiceHolder holder = (ManagedServiceHolder)service;
            String[] pids = ConfigurationManager.getServicePid(reference);
            if (holder.isDifferentPids(pids)) {
                this.cm.configure(pids, reference, (ManagedService)holder.getManagedService());
                holder.setConfiguredPids(pids);
            }
        }

        public void removedService(ServiceReference reference, Object service) {
            Object serviceObject = ((ManagedServiceHolder)service).getManagedService();
            super.removedService(reference, serviceObject);
        }
    }

    private class FireConfigurationEvent
    implements Runnable {
        private final int type;
        private final String pid;
        private final String factoryPid;
        private final ServiceReference[] listenerReferences;
        private final ConfigurationListener[] listeners;
        private final Bundle[] listenerProvider;

        private FireConfigurationEvent(int type, String pid, String factoryPid) {
            this.type = type;
            this.pid = pid;
            this.factoryPid = factoryPid;
            ServiceReference<S>[] srs = ConfigurationManager.this.configurationListenerTracker.getServiceReferences();
            if (srs == null || srs.length == 0) {
                this.listenerReferences = null;
                this.listeners = null;
                this.listenerProvider = null;
            } else {
                this.listenerReferences = srs;
                this.listeners = new ConfigurationListener[srs.length];
                this.listenerProvider = new Bundle[srs.length];
                for (int i = 0; i < srs.length; ++i) {
                    this.listeners[i] = (ConfigurationListener)ConfigurationManager.this.configurationListenerTracker.getService(srs[i]);
                    this.listenerProvider[i] = srs[i].getBundle();
                }
            }
        }

        boolean hasConfigurationEventListeners() {
            return this.listenerReferences != null;
        }

        String getTypeName() {
            switch (this.type) {
                case 2: {
                    return "CM_DELETED";
                }
                case 1: {
                    return "CM_UPDATED";
                }
                case 3: {
                    return "CM_LOCATION_CHANGED";
                }
            }
            return "<UNKNOWN(" + this.type + ")>";
        }

        public void run() {
            String typeName = this.getTypeName();
            ConfigurationEvent event = new ConfigurationEvent((ServiceReference<ConfigurationAdmin>)ConfigurationManager.this.getServiceReference(), this.type, this.factoryPid, this.pid);
            for (int i = 0; i < this.listeners.length; ++i) {
                if (this.listenerProvider[i].getState() != 32) continue;
                ConfigurationManager.this.log(4, "Sending {0} event for {1} to {2}", new Object[]{typeName, this.pid, ConfigurationManager.toString(this.listenerReferences[i])});
                try {
                    this.listeners[i].configurationEvent(event);
                    continue;
                }
                catch (Throwable t) {
                    ConfigurationManager.this.log(1, "Unexpected problem delivering configuration event to {0}", new Object[]{ConfigurationManager.toString(this.listenerReferences[i]), t});
                }
            }
        }

        public String toString() {
            return "Fire ConfigurationEvent: pid=" + this.pid;
        }
    }

    private class LocationChanged
    implements Runnable {
        private final ConfigurationImpl config;
        private final String oldLocation;

        LocationChanged(ConfigurationImpl config, String oldLocation) {
            this.config = config;
            this.oldLocation = oldLocation;
        }

        public void run() {
            ServiceHelper helper = ConfigurationManager.this.createServiceHelper(this.config);
            ServiceReference[] srList = helper.getServices();
            if (srList != null) {
                for (int i = 0; i < srList.length; ++i) {
                    ServiceReference sr = srList[i];
                    Bundle srBundle = sr.getBundle();
                    if (srBundle == null) {
                        ConfigurationManager.this.log(4, "Service {0} seems to be unregistered concurrently (not processing)", new Object[]{ConfigurationManager.toString(sr)});
                        continue;
                    }
                    boolean wasVisible = ConfigurationManager.this.canReceive(srBundle, this.oldLocation);
                    boolean isVisible = ConfigurationManager.this.canReceive(srBundle, this.config.getBundleLocation());
                    if (isVisible) {
                        this.config.tryBindLocation(srBundle.getLocation());
                    }
                    if (wasVisible && !isVisible) {
                        helper.remove(sr);
                        ConfigurationManager.this.log(4, "Configuration {0} revoked from {1} (no more visibility)", new Object[]{this.config.getPid(), ConfigurationManager.toString(sr)});
                        continue;
                    }
                    if (!wasVisible && isVisible) {
                        helper.provide(sr);
                        ConfigurationManager.this.log(4, "Configuration {0} provided to {1} (new visibility)", new Object[]{this.config.getPid(), ConfigurationManager.toString(sr)});
                        continue;
                    }
                    ConfigurationManager.this.log(4, "Unmodified visibility to configuration {0} for {1}", new Object[]{this.config.getPid(), ConfigurationManager.toString(sr)});
                }
            }
        }

        public String toString() {
            return "Location Changed (pid=" + this.config.getPid() + "): " + this.oldLocation + " ==> " + this.config.getBundleLocation();
        }
    }

    private class DeleteConfiguration
    implements Runnable {
        private final ConfigurationImpl config;
        private final String configLocation;

        DeleteConfiguration(ConfigurationImpl config) {
            this.config = config;
            this.configLocation = config.getBundleLocation();
        }

        public void run() {
            String pid = this.config.getPid();
            String factoryPid = this.config.getFactoryPid();
            ServiceHelper helper = ConfigurationManager.this.createServiceHelper(this.config);
            ServiceReference[] srList = helper.getServices();
            if (srList != null) {
                for (int i = 0; i < srList.length; ++i) {
                    ServiceReference sr = srList[i];
                    Bundle srBundle = sr.getBundle();
                    if (srBundle == null) {
                        ConfigurationManager.this.log(4, "Service {0} seems to be unregistered concurrently (not removing configuration)", new Object[]{ConfigurationManager.toString(sr)});
                        continue;
                    }
                    if (ConfigurationManager.this.canReceive(srBundle, this.configLocation)) {
                        helper.remove(sr);
                        continue;
                    }
                    ConfigurationManager.this.log(1, "Cannot remove configuration {0} for {1}: No visibility to configuration bound to {2}", new Object[]{this.config.getPid(), ConfigurationManager.toString(sr), this.configLocation});
                }
            }
            if (factoryPid != null) {
                try {
                    Factory factory = ConfigurationManager.this.getFactory(factoryPid);
                    factory.removePID(pid);
                    factory.store();
                }
                catch (IOException ioe) {
                    ConfigurationManager.this.log(1, "Failed removing {0} from the factory {1}", new Object[]{pid, factoryPid, ioe});
                }
            }
        }

        public String toString() {
            return "Delete: pid=" + this.config.getPid();
        }
    }

    private class UpdateConfiguration
    implements Runnable {
        private final ConfigurationImpl config;
        private final ServiceHelper helper;
        private final long revision;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        UpdateConfiguration(ConfigurationImpl config) {
            this.config = config;
            ConfigurationImpl configurationImpl = config;
            synchronized (configurationImpl) {
                this.helper = ConfigurationManager.this.createServiceHelper(config);
                this.revision = config.getRevision();
            }
        }

        public void run() {
            ConfigurationManager.this.log(4, "Updating configuration {0} to revision #{1}", new Object[]{this.config.getPid(), new Long(this.revision)});
            ServiceReference[] srList = this.helper.getServices();
            if (srList != null) {
                this.config.tryBindLocation(srList[0].getBundle().getLocation());
                String configBundleLocation = this.config.getBundleLocation();
                for (int i = 0; i < srList.length; ++i) {
                    ServiceReference ref = srList[i];
                    Bundle refBundle = ref.getBundle();
                    if (refBundle == null) {
                        ConfigurationManager.this.log(4, "Service {0} seems to be unregistered concurrently (not providing configuration)", new Object[]{ConfigurationManager.toString(ref)});
                        continue;
                    }
                    if (ConfigurationManager.this.canReceive(refBundle, configBundleLocation)) {
                        this.helper.provide(ref);
                        continue;
                    }
                    ConfigurationManager.this.log(1, "Cannot use configuration {0} for {1}: No visibility to configuration bound to {2}", new Object[]{this.config.getPid(), ConfigurationManager.toString(ref), configBundleLocation});
                }
            } else if (ConfigurationManager.this.isLogEnabled(4)) {
                ConfigurationManager.this.log(4, "No ManagedService[Factory] registered for updates to configuration {0}", new Object[]{this.config.getPid()});
            }
        }

        public String toString() {
            return "Update: pid=" + this.config.getPid();
        }
    }

    private class ManagedServiceFactoryUpdate
    implements Runnable {
        private final String factoryPid;
        private final ServiceReference sr;
        private final ManagedServiceFactory service;
        private final Map configs;
        private final Map revisions;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        ManagedServiceFactoryUpdate(String factoryPid, ServiceReference sr, ManagedServiceFactory service) {
            HashMap<ConfigurationImpl, Long> revisions;
            HashMap<ConfigurationImpl, Dictionary> configs;
            block10: {
                this.factoryPid = factoryPid;
                this.sr = sr;
                this.service = service;
                Factory factory = null;
                configs = null;
                revisions = null;
                try {
                    factory = ConfigurationManager.this.getFactory(factoryPid);
                    if (factory == null) break block10;
                    configs = new HashMap<ConfigurationImpl, Dictionary>();
                    revisions = new HashMap<ConfigurationImpl, Long>();
                    for (String pid : factory.getPIDs()) {
                        ConfigurationImpl cfg;
                        try {
                            cfg = ConfigurationManager.this.getConfiguration(pid);
                        }
                        catch (IOException ioe) {
                            ConfigurationManager.this.log(1, "Error loading configuration for {0}", new Object[]{pid, ioe});
                            continue;
                        }
                        if (cfg == null) {
                            ConfigurationManager.this.log(1, "Configuration {0} referred to by factory {1} does not exist", new Object[]{pid, factoryPid});
                            factory.removePID(pid);
                            factory.storeSilently();
                            continue;
                        }
                        if (cfg.isNew()) {
                            ConfigurationManager.this.log(1, "Ignoring new configuration pid={0}", new Object[]{pid});
                            continue;
                        }
                        if (!factoryPid.equals(cfg.getFactoryPid())) {
                            ConfigurationManager.this.log(1, "Configuration {0} referred to by factory {1} seems to belong to factory {2}", new Object[]{pid, factoryPid, cfg.getFactoryPid()});
                            factory.removePID(pid);
                            factory.storeSilently();
                            continue;
                        }
                        ConfigurationImpl configurationImpl = cfg;
                        synchronized (configurationImpl) {
                            configs.put(cfg, cfg.getProperties(true));
                            revisions.put(cfg, new Long(cfg.getRevision()));
                        }
                    }
                }
                catch (IOException ioe) {
                    ConfigurationManager.this.log(1, "Cannot get factory mapping for factory PID {0}", new Object[]{factoryPid, ioe});
                }
            }
            this.configs = configs;
            this.revisions = revisions;
        }

        public void run() {
            Bundle serviceBundle = this.sr.getBundle();
            if (serviceBundle == null) {
                ConfigurationManager.this.log(3, "ManagedServiceFactory for factory PID {0} seems to already have been unregistered, not updating with factory", new Object[]{this.factoryPid});
                return;
            }
            if (this.configs == null || this.configs.isEmpty()) {
                ConfigurationManager.this.log(4, "No configuration with factory PID {0}; not updating ManagedServiceFactory", new Object[]{this.factoryPid});
            } else {
                for (Map.Entry entry : this.configs.entrySet()) {
                    ConfigurationImpl cfg = (ConfigurationImpl)entry.getKey();
                    Dictionary properties = (Dictionary)entry.getValue();
                    long revision = (Long)this.revisions.get(cfg);
                    ConfigurationManager.this.log(4, "Updating configuration {0} to revision #{1}", new Object[]{cfg.getPid(), new Long(revision)});
                    if (!ConfigurationManager.this.canReceive(serviceBundle, cfg.getBundleLocation())) {
                        ConfigurationManager.this.log(1, "Cannot use configuration {0} for {1}: No visibility to configuration bound to {2}", new Object[]{cfg.getPid(), ConfigurationManager.toString(this.sr), cfg.getBundleLocation()});
                        continue;
                    }
                    cfg.tryBindLocation(serviceBundle.getLocation());
                    ConfigurationManager.this.callPlugins(properties, this.factoryPid, this.sr, cfg);
                    if (properties == null) continue;
                    ConfigurationManager.this.log(4, "{0}: Updating configuration pid={1}", new Object[]{ConfigurationManager.toString(this.sr), cfg.getPid()});
                    try {
                        this.service.updated(cfg.getPid(), properties);
                    }
                    catch (Throwable t) {
                        ConfigurationManager.this.handleCallBackError(t, this.sr, cfg);
                    }
                }
            }
        }

        public String toString() {
            return "ManagedServiceFactory Update: factoryPid=" + this.factoryPid;
        }
    }

    private class ManagedServiceUpdate
    implements Runnable {
        private final String pid;
        private final ServiceReference sr;
        private final ManagedService service;
        private final ConfigurationImpl config;
        private final Dictionary rawProperties;
        private final long revision;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ManagedServiceUpdate(String pid, ServiceReference sr, ManagedService service) {
            long revision;
            Dictionary rawProperties;
            ConfigurationImpl config;
            block5: {
                this.pid = pid;
                this.sr = sr;
                this.service = service;
                config = null;
                rawProperties = null;
                revision = -1L;
                try {
                    config = ConfigurationManager.this.getConfiguration(pid);
                    if (config == null) break block5;
                    ConfigurationImpl configurationImpl = config;
                    synchronized (configurationImpl) {
                        rawProperties = config.getProperties(true);
                        revision = config.getRevision();
                    }
                }
                catch (IOException ioe) {
                    ConfigurationManager.this.log(1, "Error loading configuration for {0}", new Object[]{pid, ioe});
                }
            }
            this.config = config;
            this.rawProperties = rawProperties;
            this.revision = revision;
        }

        public void run() {
            Dictionary properties = this.rawProperties;
            if (this.config != null) {
                ConfigurationManager.this.log(4, "Updating configuration {0} to revision #{1}", new Object[]{this.pid, new Long(this.revision)});
                Bundle serviceBundle = this.sr.getBundle();
                if (serviceBundle == null) {
                    ConfigurationManager.this.log(3, "Service for PID {0} seems to already have been unregistered, not updating with configuration", new Object[]{this.pid});
                    return;
                }
                if (ConfigurationManager.this.canReceive(serviceBundle, this.config.getBundleLocation())) {
                    this.config.tryBindLocation(serviceBundle.getLocation());
                    ConfigurationManager.this.callPlugins(properties, this.pid, this.sr, this.config);
                } else {
                    ConfigurationManager.this.log(4, "Cannot use configuration {0} for {1}: No visibility to configuration bound to {2}; calling with null", new Object[]{this.pid, ConfigurationManager.toString(this.sr), this.config.getBundleLocation()});
                    properties = null;
                }
            } else {
                properties = null;
            }
            try {
                this.service.updated(properties);
            }
            catch (Throwable t) {
                ConfigurationManager.this.handleCallBackError(t, this.sr, this.config);
            }
        }

        public String toString() {
            return "ManagedService Update: pid=" + this.pid;
        }
    }

    private class ManagedServiceFactoryHelper
    extends ServiceHelper {
        protected ManagedServiceFactoryHelper(ConfigurationImpl config) {
            super(config);
        }

        public ServiceReference[] doGetServices() throws InvalidSyntaxException {
            return ConfigurationManager.this.bundleContext.getServiceReferences(ManagedServiceFactory.class.getName(), "(service.pid=" + this.config.getFactoryPid() + ")");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void provide(ServiceReference service) {
            ManagedServiceFactory srv = (ManagedServiceFactory)ConfigurationManager.this.bundleContext.getService(service);
            if (srv != null) {
                try {
                    Dictionary props = this.getProperties(this.config.getFactoryPid(), service);
                    srv.updated(this.config.getPid(), props);
                }
                catch (Throwable t) {
                    ConfigurationManager.this.handleCallBackError(t, service, this.config);
                }
                finally {
                    ConfigurationManager.this.bundleContext.ungetService(service);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove(ServiceReference service) {
            ManagedServiceFactory srv = (ManagedServiceFactory)ConfigurationManager.this.bundleContext.getService(service);
            try {
                srv.deleted(this.config.getPid());
            }
            catch (Throwable t) {
                ConfigurationManager.this.handleCallBackError(t, service, this.config);
            }
            finally {
                ConfigurationManager.this.bundleContext.ungetService(service);
            }
        }
    }

    private class ManagedServiceHelper
    extends ServiceHelper {
        protected ManagedServiceHelper(ConfigurationImpl config) {
            super(config);
        }

        public ServiceReference[] doGetServices() throws InvalidSyntaxException {
            return ConfigurationManager.this.bundleContext.getServiceReferences(ManagedService.class.getName(), "(service.pid=" + this.config.getPid() + ")");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void provide(ServiceReference service) {
            ManagedService srv = (ManagedService)ConfigurationManager.this.bundleContext.getService(service);
            if (srv != null) {
                try {
                    Dictionary props = this.getProperties(this.config.getPid(), service);
                    srv.updated(props);
                }
                catch (Throwable t) {
                    ConfigurationManager.this.handleCallBackError(t, service, this.config);
                }
                finally {
                    ConfigurationManager.this.bundleContext.ungetService(service);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove(ServiceReference service) {
            ManagedService srv = (ManagedService)ConfigurationManager.this.bundleContext.getService(service);
            try {
                srv.updated(null);
            }
            catch (Throwable t) {
                ConfigurationManager.this.handleCallBackError(t, service, this.config);
            }
            finally {
                ConfigurationManager.this.bundleContext.ungetService(service);
            }
        }
    }

    private abstract class ServiceHelper {
        protected final ConfigurationImpl config;
        private final Dictionary properties;

        protected ServiceHelper(ConfigurationImpl config) {
            this.config = config;
            this.properties = config.getProperties(true);
        }

        final ServiceReference[] getServices() {
            try {
                ServiceReference[] refs = this.doGetServices();
                if (refs != null && refs.length > 1) {
                    Arrays.sort(refs, RankingComparator.SRV_RANKING);
                }
                return refs;
            }
            catch (InvalidSyntaxException ise) {
                ConfigurationManager.this.log(1, "Service selection filter is invalid to update {0}", new Object[]{this.config, ise});
                return null;
            }
        }

        protected abstract ServiceReference[] doGetServices() throws InvalidSyntaxException;

        abstract void provide(ServiceReference var1);

        abstract void remove(ServiceReference var1);

        protected Dictionary getProperties(String targetPid, ServiceReference service) {
            CaseInsensitiveDictionary props = new CaseInsensitiveDictionary(this.properties);
            ConfigurationManager.this.callPlugins(props, targetPid, service, this.config);
            return props;
        }
    }
}

