/*
 * Decompiled with CFR 0.152.
 */
package org.noos.xing.mydoggy.plaf.ui.cmp.event;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Timer;
import org.noos.xing.mydoggy.ContentUI;
import org.noos.xing.mydoggy.plaf.ui.animation.TransparencyAnimation;
import org.noos.xing.mydoggy.plaf.ui.transparency.TransparencyManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WindowTransparencyListener
extends WindowAdapter
implements ActionListener {
    private final TransparencyManager<Window> transparencyManager;
    private TransparencyAnimation animation;
    private Timer timer;
    private ContentUI contentUI;
    private Window window;

    public WindowTransparencyListener(TransparencyManager<Window> transparencyManager, ContentUI contentUI, Window window) {
        this.transparencyManager = transparencyManager;
        this.contentUI = contentUI;
        this.window = window;
        this.animation = new TransparencyAnimation(transparencyManager, window, contentUI.getTransparentRatio());
    }

    @Override
    public void windowGainedFocus(WindowEvent e) {
        if (this.transparencyManager.isAlphaModeEnabled(e.getWindow())) {
            this.timer.stop();
            this.animation.hide(new Object[0]);
            this.transparencyManager.setAlphaModeRatio(e.getWindow(), 1.0f);
        }
    }

    @Override
    public void windowLostFocus(WindowEvent e) {
        if (this.contentUI.isTransparentMode() && !this.window.isFocused() && !this.transparencyManager.isAlphaModeEnabled(e.getWindow())) {
            this.timer = new Timer(this.contentUI.getTransparentDelay(), this);
            this.timer.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.timer.isRunning()) {
            this.timer.stop();
            TransparencyManager<Window> transparencyManager = this.transparencyManager;
            synchronized (transparencyManager) {
                this.animation.setAlpha(this.contentUI.getTransparentRatio());
                this.animation.show(new Object[0]);
            }
        }
    }

    @Override
    public void windowClosing(WindowEvent event) {
        if (this.transparencyManager.isAlphaModeEnabled(event.getWindow())) {
            this.animation.hide(new Object[0]);
            this.transparencyManager.setAlphaModeRatio(this.window, 1.0f);
        }
    }
}

