/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.device.test;

import java.util.ArrayList;
import java.util.List;

final class I2CGenerator {
    private static final int SDA = 1;
    private static final int SCL = 2;
    private static final int ACK = 0;
    private static final int NACK = 1;
    private final int sampleRate;
    private final int busSpeed;
    private final int tickSize;
    private final List<Integer> data = new ArrayList<Integer>();
    private int idx;
    private int trigger;

    public I2CGenerator() {
        this.busSpeed = 1000000;
        this.sampleRate = 4000000;
        this.tickSize = (int)Math.rint((double)this.sampleRate / (double)this.busSpeed);
    }

    public int[] getData() {
        int size = this.data.size();
        int[] result = new int[size];
        for (int i = 0; i < size; ++i) {
            result[i] = this.data.get(i);
        }
        return result;
    }

    public int getRate() {
        return this.sampleRate;
    }

    public int getTrigger() {
        return this.trigger;
    }

    public void writeBitStream(String aString) {
        this.idx = 0;
        this.writeStartBit();
        this.trigger = this.data.size();
        this.writeByte((byte)-10);
        this.writeBit(0);
        this.writeByte((byte)-1);
        this.writeBit(0);
        for (byte b : aString.getBytes()) {
            this.writeByte(b);
            this.writeBit(Math.random() > 0.8 ? 1 : 0);
        }
        this.writeStopBit();
        this.writeStartBit();
        this.writeByte((byte)85);
        this.writeBit(0);
        this.writeByte((byte)33);
        this.writeBit(Math.random() > 0.8 ? 1 : 0);
        this.writeStopBit();
        int i = 20;
        while (i-- >= 0) {
            this.data.add(0);
        }
    }

    private int getClock() {
        double nextTickMultiple = (double)this.tickSize * Math.floor((double)this.idx / (double)this.tickSize);
        double tickIdx = nextTickMultiple == 0.0 ? (double)this.idx : Math.ceil((double)this.idx / nextTickMultiple);
        return tickIdx % 2.0 == 0.0 ? 1 : 0;
    }

    private void writeBit(int aBit) {
        int val = this.data.get(this.idx);
        while (this.getClock() == 1) {
            this.data.add(val | 2);
            ++this.idx;
        }
        this.data.remove(this.idx);
        this.data.add(val &= 0xFFFFFFFD);
        if (aBit == 0) {
            val &= 0xFFFFFFFE;
        } else if (aBit >= 1) {
            val |= 1;
        }
        this.data.add(val);
        ++this.idx;
        while (this.getClock() == 0) {
            this.data.add(val);
            ++this.idx;
        }
    }

    private void writeByte(byte aValue) {
        for (int bit = 0; bit < 8; ++bit) {
            this.writeBit(aValue & 0x80);
            aValue = (byte)(aValue << 1);
        }
    }

    private void writeStartBit() {
        int i = this.tickSize - 1;
        while (i-- > 0) {
            this.data.add(3);
        }
        this.data.add(2);
        i = this.tickSize;
        while (i-- > 0) {
            this.data.add(2);
        }
        this.idx = this.data.size() - 1;
    }

    private void writeStopBit() {
        this.writeBit(-1);
        this.data.add(2);
        int i = this.tickSize - 1;
        while (i-- > 0) {
            this.data.add(3);
        }
        this.idx = this.data.size() - 1;
    }
}

