/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.tool.linedecoder.impl.decoders;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;
import nl.lxtreme.ols.api.acquisition.AcquisitionResult;
import nl.lxtreme.ols.api.data.CapturedData;
import nl.lxtreme.ols.api.data.Edge;
import nl.lxtreme.ols.api.data.annotation.Annotation;
import nl.lxtreme.ols.api.data.annotation.AnnotationListener;
import nl.lxtreme.ols.api.tools.ToolProgressListener;
import nl.lxtreme.ols.api.util.FrequencyUnit;
import nl.lxtreme.ols.tool.base.annotation.SampleDataAnnotation;
import nl.lxtreme.ols.tool.linedecoder.LineDecoder;
import nl.lxtreme.ols.tool.linedecoder.LineDecoderToolContext;

public class ManchesterLineDecoder
implements LineDecoder {
    @Override
    public boolean canHandleInversion() {
        return true;
    }

    @Override
    public boolean canRecoverClock() {
        return true;
    }

    @Override
    public AcquisitionResult decode(LineDecoderToolContext aContext, AnnotationListener aAnnotationListener, ToolProgressListener aListener) throws Exception {
        AcquisitionResult inputData = aContext.getData();
        int[] values = inputData.getValues();
        long[] timestamps = inputData.getTimestamps();
        int dataIdx = aContext.getLineChannels()[0];
        int clockIdx = dataIdx >= 1 ? dataIdx - 1 : dataIdx + 1;
        int dataMask = 1 << dataIdx;
        int clockMask = 1 << clockIdx;
        aAnnotationListener.clearAnnotations(dataIdx);
        aAnnotationListener.clearAnnotations(clockIdx);
        int startIdx = aContext.getStartSampleIndex();
        int endIdx = aContext.getEndSampleIndex();
        int lastValue = values[startIdx] & dataMask;
        long symbolStartTime = -1L;
        long lastTimestamp = -1L;
        long firstSignalEdge = -1L;
        long halfCycle = -1L;
        long jitter = 0L;
        int edgeCounter = 0;
        int symbolSize = 8;
        int bitCount = 0;
        int symbol = 0;
        for (int i = startIdx; i < endIdx; ++i) {
            int value = values[i] & dataMask;
            long clockEdge = -1L;
            Edge edge = Edge.toEdge((int)lastValue, (int)value);
            if (!edge.isNone()) {
                if (lastTimestamp < 0L) {
                    symbolStartTime = lastTimestamp = timestamps[i];
                    firstSignalEdge = lastTimestamp;
                } else {
                    long diff = timestamps[i] - lastTimestamp;
                    if (halfCycle < 0L) {
                        halfCycle = edge.isFalling() ? diff / 2L : diff;
                        jitter = diff / 2L;
                    } else if (diff >= halfCycle - jitter && diff <= halfCycle + jitter) {
                        halfCycle = diff;
                        jitter = diff / 8L;
                        if (edgeCounter % 2 == 0) {
                            clockEdge = timestamps[i];
                        }
                        ++edgeCounter;
                    } else if (diff >= 2L * (halfCycle - jitter) && diff <= 2L * (halfCycle + jitter)) {
                        halfCycle = diff / 2L;
                        jitter = diff / 16L;
                        clockEdge = timestamps[i] - halfCycle;
                        edgeCounter += 2;
                    }
                    lastTimestamp = timestamps[i];
                }
            }
            if (clockEdge >= 0L) {
                int sampleValue = this.getDataValue(aContext, clockEdge);
                symbol <<= 1;
                ++bitCount;
                if ((sampleValue & dataMask) != 0) {
                    symbol |= 1;
                }
                if (bitCount == symbolSize) {
                    aAnnotationListener.onAnnotation((Annotation)this.createAnnotation(dataIdx, symbolStartTime, clockEdge, symbol));
                    symbol = 0;
                    bitCount = 0;
                    symbolStartTime = clockEdge;
                }
            }
            lastValue = value;
        }
        if (bitCount < symbolSize) {
            int sampleValue = this.getDataValue(aContext, lastTimestamp += halfCycle);
            while (bitCount++ < symbolSize) {
                lastTimestamp += halfCycle;
                symbol <<= 1;
                if ((sampleValue & dataMask) == 0) continue;
                symbol |= 1;
            }
            aAnnotationListener.onAnnotation((Annotation)this.createAnnotation(dataIdx, symbolStartTime, lastTimestamp, symbol));
        }
        lastTimestamp += halfCycle;
        String format = FrequencyUnit.format((double)((double)inputData.getSampleRate() / (2.0 * (double)halfCycle)));
        System.out.println("Clock signal = " + format);
        TreeMap<Long, Integer> newSamples = new TreeMap<Long, Integer>();
        for (int i = 0; i < values.length; ++i) {
            newSamples.put(timestamps[i], values[i]);
        }
        boolean clockLow = false;
        for (long time = firstSignalEdge + halfCycle; time < lastTimestamp; time += halfCycle) {
            int sampleValue = this.getDataValue(aContext, time);
            sampleValue = clockLow ? (sampleValue &= ~clockMask) : (sampleValue |= clockMask);
            clockLow = !clockLow;
            newSamples.put(time, sampleValue);
        }
        for (Long time : newSamples.keySet()) {
            int sampleValue = (Integer)newSamples.get(time);
            int clockValue = sampleValue & clockMask;
            int dataValue = sampleValue & dataMask;
            sampleValue = clockValue != 0 && dataValue == 0 || clockValue == 0 && dataValue != 0 ? (sampleValue |= 1) : (sampleValue &= 0xFE);
            newSamples.put(time, sampleValue);
        }
        ArrayList<Object> newValues = new ArrayList<Object>();
        ArrayList<Object> newTimestamps = new ArrayList<Object>();
        for (Map.Entry entry : newSamples.entrySet()) {
            newValues.add(entry.getValue());
            newTimestamps.add(entry.getKey());
        }
        for (int i = endIdx; i < values.length; ++i) {
            newValues.add(values[i]);
            newTimestamps.add(timestamps[i]);
        }
        long absoluteLength = (Long)newTimestamps.get(newTimestamps.size() - 1);
        return new CapturedData(newValues, newTimestamps, firstSignalEdge, inputData.getSampleRate(), inputData.getChannels(), inputData.getEnabledChannels(), absoluteLength);
    }

    @Override
    public String[] getLineNames() {
        return new String[]{"Data"};
    }

    @Override
    public String getName() {
        return "Manchester";
    }

    protected final int getDataValue(LineDecoderToolContext aContext, long aTimeValue) {
        AcquisitionResult inputData = aContext.getData();
        int[] values = inputData.getValues();
        long[] timestamps = inputData.getTimestamps();
        int k = Arrays.binarySearch(timestamps, aTimeValue);
        if (k < 0) {
            k = -(k + 1);
        }
        return k == 0 ? values[0] : values[k - 1];
    }

    private SampleDataAnnotation createAnnotation(int aIndex, long aStartTime, long aEndTime, int aSymbol) {
        return new SampleDataAnnotation(aIndex, aStartTime, aEndTime, String.format("%1$c (%1$x)", aSymbol));
    }
}

