/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.tool.linedecoder.impl;

import java.awt.Window;
import java.util.ArrayList;
import java.util.List;
import nl.lxtreme.ols.api.acquisition.AcquisitionResult;
import nl.lxtreme.ols.api.data.annotation.AnnotationListener;
import nl.lxtreme.ols.api.tools.Tool;
import nl.lxtreme.ols.api.tools.ToolCategory;
import nl.lxtreme.ols.api.tools.ToolContext;
import nl.lxtreme.ols.api.tools.ToolProgressListener;
import nl.lxtreme.ols.tool.linedecoder.LineDecoder;
import nl.lxtreme.ols.tool.linedecoder.impl.LineDecoderTask;
import nl.lxtreme.ols.tool.linedecoder.impl.LineDecoderToolDialog;
import nl.lxtreme.ols.tool.linedecoder.impl.decoders.ManchesterLineDecoder;
import nl.lxtreme.ols.tool.linedecoder.impl.decoders.NonReturnToZeroDecoder;
import org.apache.felix.dm.Component;
import org.apache.felix.dm.Dependency;
import org.apache.felix.dm.DependencyManager;
import org.osgi.framework.BundleContext;

public class LineDecoderTool
implements Tool<AcquisitionResult> {
    private final List<LineDecoder> lineDecoders = new ArrayList<LineDecoder>();
    private volatile BundleContext context;
    private volatile DependencyManager dependencyManager;

    public LineDecoderTool() {
        this.lineDecoders.add(new ManchesterLineDecoder());
        this.lineDecoders.add(new NonReturnToZeroDecoder());
    }

    public LineDecoderTask createToolTask(ToolContext aContext, ToolProgressListener aProgressListener, AnnotationListener aAnnotationListener) {
        return new LineDecoderTask(aContext, aProgressListener, aAnnotationListener);
    }

    public ToolCategory getCategory() {
        return ToolCategory.DECODER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final LineDecoder[] getLineDecoders() {
        LineDecoder[] decoders;
        List<LineDecoder> list = this.lineDecoders;
        synchronized (list) {
            decoders = this.lineDecoders.toArray(new LineDecoder[this.lineDecoders.size()]);
        }
        return decoders;
    }

    public String getName() {
        return "Line decoder ...";
    }

    public void invoke(Window aParent, ToolContext aContext) {
        new LineDecoderToolDialog(aParent, aContext, this.context, this).showDialog();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addLineDecoder(LineDecoder aLineDecoder) {
        List<LineDecoder> list = this.lineDecoders;
        synchronized (list) {
            if (!this.lineDecoders.contains(aLineDecoder)) {
                this.lineDecoders.add(aLineDecoder);
            }
        }
    }

    protected void destroy(Component aComponent) {
    }

    protected void init(Component aComponent) {
        aComponent.add((Dependency)this.dependencyManager.createServiceDependency().setService(LineDecoder.class).setCallbacks("addLineDecoder", "removeLineDecoder").setRequired(false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeLineDecoder(LineDecoder aLineDecoder) {
        List<LineDecoder> list = this.lineDecoders;
        synchronized (list) {
            this.lineDecoders.remove(aLineDecoder);
        }
    }
}

