/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.util;

import java.util.ArrayList;
import java.util.ListIterator;
import java.util.StringTokenizer;

public final class StringUtils {
    private StringUtils() {
    }

    public static String integerToBinString(int aValue, int aFieldWidth) {
        long mask = (long)(Math.pow(2.0, aFieldWidth) - 1.0);
        StringBuilder sb = new StringBuilder(Long.toBinaryString((long)aValue & mask));
        for (int numberOfLeadingZeros = Math.max(0, aFieldWidth - sb.length()); numberOfLeadingZeros > 0; --numberOfLeadingZeros) {
            sb.insert(0, '0');
        }
        return sb.toString();
    }

    public static String integerToHexString(int aValue, int aFieldWidth) {
        long mask = (long)(Math.pow(16.0, aFieldWidth) - 1.0);
        StringBuilder sb = new StringBuilder(Long.toHexString((long)aValue & mask));
        for (int numberOfLeadingZeros = Math.max(0, aFieldWidth - sb.length()); numberOfLeadingZeros > 0; --numberOfLeadingZeros) {
            sb.insert(0, '0');
        }
        return sb.toString();
    }

    public static boolean isEmpty(String aValue) {
        return aValue == null || aValue.trim().isEmpty();
    }

    public static String[] tokenize(String aInput, String aDelimiters) {
        if (aInput == null) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(aInput, aDelimiters, false);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            result.add(token.trim());
        }
        return result.toArray(new String[result.size()]);
    }

    public static String[] tokenizeQuotedStrings(String aInput, String aDelimiters) {
        if (aInput == null) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        String lookback = "";
        boolean inQuotedString = false;
        StringTokenizer tokenizer = new StringTokenizer(aInput, aDelimiters, true);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (!inQuotedString && token.startsWith("\"") && !token.endsWith("\"")) {
                inQuotedString = true;
                lookback = token;
            } else if (inQuotedString) {
                lookback = lookback.concat(token);
                if (token.endsWith("\"")) {
                    inQuotedString = false;
                    token = lookback;
                }
            }
            if (inQuotedString || StringUtils.isDelimiter(token, aDelimiters)) continue;
            result.add(token);
        }
        ListIterator<String> iter = result.listIterator();
        while (iter.hasNext()) {
            String token = (String)iter.next();
            iter.set(StringUtils.unquote(token));
        }
        return result.toArray(new String[result.size()]);
    }

    public static String unquote(String aInput) {
        return StringUtils.unquote(aInput, '\"');
    }

    public static String unquote(String aInput, char aQuoteChar) {
        if (aInput == null) {
            return null;
        }
        String quoteChar = Character.toString(aQuoteChar);
        String result = aInput.trim();
        if (result.startsWith(quoteChar) && result.endsWith(quoteChar)) {
            result = result.substring(1, result.length() - 1);
        }
        return result;
    }

    private static boolean isDelimiter(String aInput, String aDelimiters) {
        String regex = "^[" + aDelimiters + "]+$";
        return aInput.matches(regex);
    }
}

