/*
 * Decompiled with CFR 0.152.
 */
package jtermios.macosx;

import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.NativeLong;
import com.sun.jna.Structure;
import java.io.File;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import jtermios.FDSet;
import jtermios.JTermios;
import jtermios.Pollfd;
import jtermios.Termios;
import jtermios.TimeVal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JTermiosImpl
implements JTermios.JTermiosInterface {
    private static int IOSSIOSPEED = -2147199998;
    private static String DEVICE_DIR_PATH = "/dev/";
    static MacOSX_C_lib m_Clib = (MacOSX_C_lib)Native.loadLibrary("c", MacOSX_C_lib.class);

    public JTermiosImpl() {
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(1, "instantiating %s\n", this.getClass().getCanonicalName());
    }

    @Override
    public int errno() {
        return Native.getLastError();
    }

    @Override
    public void cfmakeraw(Termios termios2) {
        MacOSX_C_lib.termios t = new MacOSX_C_lib.termios(termios2);
        m_Clib.cfmakeraw(t);
        t.update(termios2);
    }

    @Override
    public int fcntl(int fd, int cmd, int arg) {
        return m_Clib.fcntl(fd, cmd, arg);
    }

    @Override
    public int tcdrain(int fd) {
        return m_Clib.tcdrain(fd);
    }

    @Override
    public int cfgetispeed(Termios termios2) {
        return m_Clib.cfgetispeed(new MacOSX_C_lib.termios(termios2)).intValue();
    }

    @Override
    public int cfgetospeed(Termios termios2) {
        return m_Clib.cfgetospeed(new MacOSX_C_lib.termios(termios2)).intValue();
    }

    @Override
    public int cfsetispeed(Termios termios2, int speed) {
        MacOSX_C_lib.termios t = new MacOSX_C_lib.termios(termios2);
        int ret = m_Clib.cfsetispeed(t, new NativeLong((long)speed));
        t.update(termios2);
        return ret;
    }

    @Override
    public int cfsetospeed(Termios termios2, int speed) {
        MacOSX_C_lib.termios t = new MacOSX_C_lib.termios(termios2);
        int ret = m_Clib.cfsetospeed(t, new NativeLong((long)speed));
        t.update(termios2);
        return ret;
    }

    @Override
    public int open(String s, int t) {
        if (s != null && !s.startsWith("/")) {
            s = String.valueOf(DEVICE_DIR_PATH) + s;
        }
        return m_Clib.open(s, t);
    }

    @Override
    public int read(int fd, byte[] buffer, int len) {
        return m_Clib.read(fd, ByteBuffer.wrap(buffer), new NativeLong((long)len)).intValue();
    }

    @Override
    public int write(int fd, byte[] buffer, int len) {
        return m_Clib.write(fd, ByteBuffer.wrap(buffer), new NativeLong((long)len)).intValue();
    }

    @Override
    public int close(int fd) {
        return m_Clib.close(fd);
    }

    @Override
    public int tcflush(int fd, int b) {
        return m_Clib.tcflush(fd, b);
    }

    @Override
    public int tcgetattr(int fd, Termios termios2) {
        MacOSX_C_lib.termios t = new MacOSX_C_lib.termios();
        int ret = m_Clib.tcgetattr(fd, t);
        t.update(termios2);
        return ret;
    }

    @Override
    public void perror(String msg) {
        m_Clib.perror(msg);
    }

    @Override
    public int tcsendbreak(int fd, int duration) {
        throw new IllegalArgumentException("Unimplemented function");
    }

    @Override
    public int tcsetattr(int fd, int cmd, Termios termios2) {
        return m_Clib.tcsetattr(fd, cmd, new MacOSX_C_lib.termios(termios2));
    }

    @Override
    public void FD_CLR(int fd, FDSet set) {
        if (set == null) {
            return;
        }
        FDSetImpl p = (FDSetImpl)set;
        int n = fd / 32;
        p.bits[n] = p.bits[n] & ~(1 << fd % 32);
    }

    @Override
    public boolean FD_ISSET(int fd, FDSet set) {
        if (set == null) {
            return false;
        }
        FDSetImpl p = (FDSetImpl)set;
        return (p.bits[fd / 32] & 1 << fd % 32) != 0;
    }

    @Override
    public void FD_SET(int fd, FDSet set) {
        if (set == null) {
            return;
        }
        FDSetImpl p = (FDSetImpl)set;
        int n = fd / 32;
        p.bits[n] = p.bits[n] | 1 << fd % 32;
    }

    @Override
    public void FD_ZERO(FDSet set) {
        if (set == null) {
            return;
        }
        FDSetImpl p = (FDSetImpl)set;
        Arrays.fill(p.bits, 0);
    }

    @Override
    public int select(int nfds, FDSet rfds, FDSet wfds, FDSet efds, TimeVal timeout) {
        MacOSX_C_lib.timeval tout = null;
        if (timeout != null) {
            tout = new MacOSX_C_lib.timeval(timeout);
        }
        int[] r = rfds != null ? ((FDSetImpl)rfds).bits : null;
        int[] w = wfds != null ? ((FDSetImpl)wfds).bits : null;
        int[] e = efds != null ? ((FDSetImpl)efds).bits : null;
        return m_Clib.select(nfds, r, w, e, tout);
    }

    @Override
    public int poll(Pollfd[] fds, int nfds, int timeout) {
        MacOSX_C_lib.pollfd[] pfds = new MacOSX_C_lib.pollfd[fds.length];
        int i = 0;
        while (i < nfds) {
            pfds[i] = new MacOSX_C_lib.pollfd(fds[i]);
            ++i;
        }
        int ret = m_Clib.poll(pfds, nfds, timeout);
        int i2 = 0;
        while (i2 < nfds) {
            fds[i2].revents = pfds[i2].revents;
            ++i2;
        }
        return ret;
    }

    @Override
    public FDSet newFDSet() {
        return new FDSetImpl();
    }

    @Override
    public int ioctl(int fd, int cmd, int[] data) {
        return m_Clib.ioctl(fd, cmd, data);
    }

    public int ioctl(int fd, int cmd, NativeLong[] data) {
        return m_Clib.ioctl(fd, cmd, data);
    }

    @Override
    public List<String> getPortList() {
        File dir = new File(DEVICE_DIR_PATH);
        if (!dir.isDirectory()) {
            JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(1, "device directory %s does not exist\n", DEVICE_DIR_PATH);
            return null;
        }
        String[] devs = dir.list();
        LinkedList<String> list = new LinkedList<String>();
        Pattern p = JTermios.getPortNamePattern(this);
        if (devs != null) {
            int i = 0;
            while (i < devs.length) {
                String s = devs[i];
                if (p.matcher(s).matches()) {
                    list.add(s);
                }
                ++i;
            }
        }
        return list;
    }

    @Override
    public String getPortNamePattern() {
        return "^(tty\\.|cu\\.).*";
    }

    @Override
    public void shutDown() {
    }

    @Override
    public int setspeed(int fd, Termios termios2, int speed) {
        int r = this.cfsetispeed(termios2, speed);
        if (r == 0) {
            r = this.cfsetospeed(termios2, speed);
        }
        if (r == 0) {
            r = this.tcsetattr(fd, JTermios.TCSANOW, termios2);
        }
        if (r != 0 && this.cfsetispeed(termios2, JTermios.B9600) == 0 && this.cfsetospeed(termios2, JTermios.B9600) == 0 && this.tcsetattr(fd, JTermios.TCSANOW, termios2) == 0) {
            NativeLong[] data = new NativeLong[]{new NativeLong((long)speed)};
            r = this.ioctl(fd, IOSSIOSPEED, data);
        }
        return r;
    }

    private static class FDSetImpl
    extends FDSet {
        static final int FD_SET_SIZE = 1024;
        static final int NFBBITS = 32;
        int[] bits = new int[32];

        private FDSetImpl() {
        }

        public String toString() {
            return String.format("%08X%08X", this.bits[0], this.bits[1]);
        }
    }

    public static interface MacOSX_C_lib
    extends Library {
        public int tcdrain(int var1);

        public void cfmakeraw(termios var1);

        public int fcntl(int var1, int var2, int var3);

        public int ioctl(int var1, int var2, int[] var3);

        public int ioctl(int var1, int var2, NativeLong[] var3);

        public int open(String var1, int var2);

        public int close(int var1);

        public int tcgetattr(int var1, termios var2);

        public int tcsetattr(int var1, int var2, termios var3);

        public int cfsetispeed(termios var1, NativeLong var2);

        public int cfsetospeed(termios var1, NativeLong var2);

        public NativeLong cfgetispeed(termios var1);

        public NativeLong cfgetospeed(termios var1);

        public NativeLong write(int var1, ByteBuffer var2, NativeLong var3);

        public NativeLong read(int var1, ByteBuffer var2, NativeLong var3);

        public int select(int var1, int[] var2, int[] var3, int[] var4, timeval var5);

        public int poll(pollfd[] var1, int var2, int var3);

        public int tcflush(int var1, int var2);

        public void perror(String var1);

        public static class pollfd
        extends Structure {
            public int fd;
            public short events;
            public short revents;

            protected List getFieldOrder() {
                return Arrays.asList("fd", "events", "revents");
            }

            public pollfd(Pollfd pfd) {
                this.fd = pfd.fd;
                this.events = pfd.events;
                this.revents = pfd.revents;
            }
        }

        public static class termios
        extends Structure {
            public NativeLong c_iflag = new NativeLong();
            public NativeLong c_oflag = new NativeLong();
            public NativeLong c_cflag = new NativeLong();
            public NativeLong c_lflag = new NativeLong();
            public byte[] c_cc = new byte[20];
            public NativeLong c_ispeed = new NativeLong();
            public NativeLong c_ospeed = new NativeLong();

            protected List getFieldOrder() {
                return Arrays.asList("c_iflag", "c_oflag", "c_cflag", "c_lflag", "c_cc", "c_ispeed", "c_ospeed");
            }

            public termios() {
            }

            public termios(Termios t) {
                this.c_iflag.setValue(t.c_iflag);
                this.c_oflag.setValue(t.c_oflag);
                this.c_cflag.setValue(t.c_cflag);
                this.c_lflag.setValue(t.c_lflag);
                System.arraycopy(t.c_cc, 0, this.c_cc, 0, t.c_cc.length);
                this.c_ispeed.setValue(t.c_ispeed);
                this.c_ospeed.setValue(t.c_ospeed);
            }

            public void update(Termios t) {
                t.c_iflag = this.c_iflag.intValue();
                t.c_oflag = this.c_oflag.intValue();
                t.c_cflag = this.c_cflag.intValue();
                t.c_lflag = this.c_lflag.intValue();
                System.arraycopy(this.c_cc, 0, t.c_cc, 0, t.c_cc.length);
                t.c_ispeed = this.c_ispeed.intValue();
                t.c_ospeed = this.c_ospeed.intValue();
            }
        }

        public static class timeval
        extends Structure {
            public NativeLong tv_sec;
            public NativeLong tv_usec;

            protected List getFieldOrder() {
                return Arrays.asList("tv_sec", "tv_usec");
            }

            public timeval(TimeVal timeout) {
                this.tv_sec = new NativeLong(timeout.tv_sec);
                this.tv_usec = new NativeLong(timeout.tv_usec);
            }
        }
    }
}

