/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.runner;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import nl.lxtreme.ols.runner.HostActivator;
import nl.lxtreme.ols.util.HostUtils;
import org.apache.felix.framework.Felix;
import org.apache.felix.main.AutoProcessor;
import org.osgi.framework.BundleContext;

public final class Runner {
    private static final String[] AUTO_START_BUNDLES = new String[]{"org.apache.felix.configadmin", "org.apache.felix.fileinstall"};
    private static final Logger LOG = Logger.getLogger(Runner.class.getName());
    private final HostActivator hostActivator;
    private Felix framework;

    public Runner() throws Exception {
        HashMap<String, Object> config = new HashMap<String, Object>();
        String pluginDir = Runner.getPluginDir();
        String binaryDir = Runner.getBinaryDir();
        String bundleCacheDir = Runner.getBundleCacheDir();
        String autoStartBundles = Runner.getAutoInstallBundles(binaryDir);
        this.hostActivator = new HostActivator();
        ArrayList<HostActivator> activators = new ArrayList<HostActivator>();
        activators.add(this.hostActivator);
        config.put("felix.systembundle.activators", activators);
        config.put("org.osgi.framework.system.packages.extra", "com.apple.mrj,com.apple.eawt,javax.swing,javax.media.jai");
        config.put("felix.auto.deploy.action", "install,start");
        config.put("felix.auto.start", autoStartBundles);
        config.put("org.osgi.framework.storage", bundleCacheDir);
        config.put("org.osgi.framework.startlevel.beginning", "4");
        config.put("felix.startlevel.bundle", "1");
        config.put("felix.log.level", "1");
        System.setProperty("felix.fileinstall.noInitialDelay", Boolean.toString(true));
        System.setProperty("felix.fileinstall.dir", pluginDir);
        System.setProperty("felix.fileinstall.start.level", "2");
        System.setProperty("felix.fileinstall.enableConfigSave", Boolean.toString(true));
        String logLevel = this.isDebugMode() ? "4" : "1";
        System.setProperty("felix.fileinstall.log.level", logLevel);
        try {
            this.framework = new Felix(config);
            this.framework.init();
            AutoProcessor.process(config, (BundleContext)this.framework.getBundleContext());
            this.framework.start();
            LOG.log(Level.INFO, "Bootstrap complete ...");
            LOG.log(Level.INFO, "  plugin dir: {0}", pluginDir);
            LOG.log(Level.FINE, "  binary dir: {0}", binaryDir);
            LOG.log(Level.FINE, "  cache dir : {0}", bundleCacheDir);
        }
        catch (Exception exception) {
            if (!HostUtils.handleInterruptedException((Throwable)exception)) {
                LOG.log(Level.SEVERE, "Failed to start OSGi framework! Possible reason: " + exception.getMessage());
                LOG.log(Level.FINE, "Details: ", exception);
            }
            throw exception;
        }
    }

    public static void main(String[] aArgs) throws Exception {
        Runner runner = new Runner();
        runner.waitForStop();
    }

    private static String getAutoInstallBundles(String aBinDir) {
        File binDir = new File(aBinDir);
        String[] autoInstallBundleNames = binDir.list(new FilenameFilter(){

            @Override
            public boolean accept(File aDir, String aName) {
                for (String autoStartedBundleName : AUTO_START_BUNDLES) {
                    if (!aName.startsWith(autoStartedBundleName)) continue;
                    return true;
                }
                return false;
            }
        });
        StringBuilder result = new StringBuilder();
        if (autoInstallBundleNames != null && autoInstallBundleNames.length > 0) {
            for (String autoInstallBundleName : autoInstallBundleNames) {
                if (result.length() > 0) {
                    result.append(' ');
                }
                File file = new File(binDir, autoInstallBundleName);
                result.append('\"').append(file.toURI()).append('\"');
            }
        }
        return result.toString();
    }

    private static String getBinaryDir() throws IOException {
        File pluginDir = new File(Runner.getPluginDir());
        return new File(pluginDir.getParentFile(), "bin").getCanonicalPath();
    }

    private static String getBundleCacheDir() throws IOException {
        File pluginDir = new File(Runner.getPluginDir());
        return new File(pluginDir.getParentFile(), "felix-cache").getCanonicalPath();
    }

    private static String getPluginDir() throws IOException {
        File pluginDir = new File(System.getProperty("user.dir"), "plugins");
        if (pluginDir.exists() && pluginDir.isDirectory()) {
            return pluginDir.getCanonicalPath();
        }
        String pluginProperty = System.getProperty("nl.lxtreme.ols.bundle.dir", "./plugins");
        pluginDir = new File(pluginProperty);
        if (pluginDir.exists() && pluginDir.isDirectory()) {
            return pluginDir.getCanonicalPath();
        }
        if ((pluginDir = new File(pluginDir, "plugins")).exists() && pluginDir.isDirectory()) {
            return pluginDir.getCanonicalPath();
        }
        throw new RuntimeException("Failed to find plugins folder! Is '-Dnl.lxtreme.ols.bundle.dir' specified?");
    }

    public void waitForStop() throws InterruptedException {
        this.framework.waitForStop(0L);
    }

    private boolean isDebugMode() {
        return Boolean.parseBoolean(System.getProperty("nl.lxtreme.ols.client.debug", "false"));
    }
}

