/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.io.serial;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class CommPortOptions {
    private static final Pattern SCHEMA_REGEX = Pattern.compile("^comm:([^;]+)(?:;([^\r\n]+))*$");
    private static final Pattern OPTION_REGEX = Pattern.compile("(baudrate|bitsperchar|stopbits|parity|blocking|autocts|autorts|flowcontrol|dtr|delay|recv_timeout)=([\\.\\d\\w_-]+)", 2);
    private String portName;
    private int baudrate;
    private int databits;
    private int stopbits;
    private int parityMode;
    private int flowControl;
    private boolean blocking;
    private boolean dtr;
    private int openDelay;
    private int recvTimeout;

    public CommPortOptions(String aURI) throws IllegalArgumentException {
        if (aURI == null) {
            throw new IllegalArgumentException("URI cannot be null!");
        }
        this.baudrate = 9600;
        this.databits = 8;
        this.parityMode = 0;
        this.stopbits = 1;
        this.flowControl = 0;
        this.blocking = true;
        this.dtr = false;
        this.openDelay = 0;
        this.recvTimeout = 100;
        this.parseURI(aURI);
    }

    public int getBaudrate() {
        return this.baudrate;
    }

    public int getDatabits() {
        return this.databits;
    }

    public int getFlowControl() {
        return this.flowControl;
    }

    public int getOpenDelay() {
        return this.openDelay;
    }

    public int getParityMode() {
        return this.parityMode;
    }

    public String getPortName() {
        return this.portName;
    }

    public int getReceiveTimeout() {
        return this.recvTimeout;
    }

    public int getStopbits() {
        return this.stopbits;
    }

    public boolean isBlocking() {
        return this.blocking;
    }

    public boolean isDTR() {
        return this.dtr;
    }

    private int parseBaudrate(String aStr) {
        int result;
        try {
            result = Integer.parseInt(aStr);
        }
        catch (NumberFormatException exception) {
            result = -1;
        }
        return result;
    }

    private int parseDataBits(String aStr) {
        if ("5".equals(aStr)) {
            return 5;
        }
        if ("6".equals(aStr)) {
            return 6;
        }
        if ("7".equals(aStr)) {
            return 7;
        }
        if ("8".equals(aStr)) {
            return 8;
        }
        return -1;
    }

    private int parseFlowControl(String aStr) {
        if ("off".equals(aStr)) {
            return 0;
        }
        if ("xon_xoff".equals(aStr)) {
            return 4;
        }
        if ("rts_cts".equals(aStr)) {
            return 1;
        }
        return -1;
    }

    private int parseOpenDelay(String aStr) {
        int result = 0;
        try {
            result = Integer.parseInt(aStr);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return result;
    }

    private int parseParityMode(String aStr) {
        if ("even".equalsIgnoreCase(aStr)) {
            return 2;
        }
        if ("mark".equalsIgnoreCase(aStr)) {
            return 3;
        }
        if ("none".equalsIgnoreCase(aStr)) {
            return 0;
        }
        if ("odd".equalsIgnoreCase(aStr)) {
            return 1;
        }
        if ("space".equalsIgnoreCase(aStr)) {
            return 4;
        }
        return -1;
    }

    private int parseRecvTimeout(String aStr) {
        int result = 100;
        try {
            result = Integer.parseInt(aStr);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return result;
    }

    private int parseStopBits(String aStr) {
        if ("1".equals(aStr)) {
            return 1;
        }
        if ("1.5".equals(aStr)) {
            return 3;
        }
        if ("2".equals(aStr)) {
            return 2;
        }
        return -1;
    }

    private void parseURI(String aURI) throws IllegalArgumentException {
        if (aURI == null) {
            throw new IllegalArgumentException("URI cannot be null!");
        }
        Matcher schemaMatcher = SCHEMA_REGEX.matcher(aURI);
        if (!schemaMatcher.matches()) {
            throw new IllegalArgumentException("URI invalid!");
        }
        this.portName = schemaMatcher.group(1);
        String options = schemaMatcher.group(2);
        if (options == null) {
            options = "";
        }
        Matcher optionMatcher = OPTION_REGEX.matcher(options);
        while (optionMatcher.find()) {
            int parsedValue;
            String key = optionMatcher.group(1).toLowerCase();
            String value = optionMatcher.group(2);
            if ("baudrate".equals(key)) {
                parsedValue = this.parseBaudrate(value);
                if (parsedValue < 0) continue;
                this.baudrate = parsedValue;
                continue;
            }
            if ("bitsperchar".equals(key)) {
                parsedValue = this.parseDataBits(value);
                if (parsedValue < 0) continue;
                this.databits = parsedValue;
                continue;
            }
            if ("stopbits".equals(key)) {
                parsedValue = this.parseStopBits(value);
                if (parsedValue < 0) continue;
                this.stopbits = parsedValue;
                continue;
            }
            if ("parity".equals(key)) {
                parsedValue = this.parseParityMode(value);
                if (parsedValue < 0) continue;
                this.parityMode = parsedValue;
                continue;
            }
            if ("flowcontrol".equals(key)) {
                parsedValue = this.parseFlowControl(value);
                if (parsedValue < 0) continue;
                this.flowControl = parsedValue;
                continue;
            }
            if ("blocking".equals(key)) {
                this.blocking = "on".equalsIgnoreCase(value);
                continue;
            }
            if ("autocts".equals(key)) {
                parsedValue = "on".equalsIgnoreCase(value) ? 1 : 0;
                if (parsedValue == 0) continue;
                this.flowControl = 1;
                continue;
            }
            if ("autorts".equals(key)) {
                parsedValue = "on".equalsIgnoreCase(value) ? 1 : 0;
                if (parsedValue == 0) continue;
                this.flowControl = 2;
                continue;
            }
            if ("dtr".equals(key)) {
                this.dtr = "on".equalsIgnoreCase(value);
                continue;
            }
            if ("delay".equals(key)) {
                this.openDelay = this.parseOpenDelay(value);
                continue;
            }
            if (!"recv_timeout".equals(key)) continue;
            this.recvTimeout = this.parseRecvTimeout(value);
        }
    }
}

