/*
 * Decompiled with CFR 0.152.
 */
package org.noos.xing.mydoggy.plaf.ui.look;

import info.clearthought.layout.TableLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.LabelUI;
import javax.swing.plaf.basic.BasicPanelUI;
import javax.swing.plaf.metal.MetalLabelUI;
import org.noos.xing.mydoggy.plaf.ui.cmp.ExtendedTableLayout;
import org.noos.xing.mydoggy.plaf.ui.cmp.ToolWindowScrollBar;
import org.noos.xing.mydoggy.plaf.ui.cmp.border.LineBorder;
import org.noos.xing.mydoggy.plaf.ui.util.Colors;
import org.noos.xing.mydoggy.plaf.ui.util.GraphicsUtil;
import org.noos.xing.mydoggy.plaf.ui.util.SwingUtil;

public class ToolWindowScrollBarUI
extends BasicPanelUI
implements ChangeListener {
    protected ToolWindowScrollBar toolWindowScrollBar;
    protected TableLayout toolWindowScrollBarLayout;
    protected int orientation;
    protected Container container;
    protected JViewport viewport;
    protected boolean scrollEnabled;

    public static ComponentUI createUI(JComponent c) {
        return new ToolWindowScrollBarUI();
    }

    public void installUI(JComponent c) {
        this.toolWindowScrollBar = (ToolWindowScrollBar)c;
        switch (this.toolWindowScrollBar.getToolWindowBar().getAnchor()) {
            case LEFT: 
            case RIGHT: {
                this.orientation = 0;
                break;
            }
            default: {
                this.orientation = 1;
            }
        }
        this.container = this.toolWindowScrollBar.getContainer();
        super.installUI(c);
        this.installComponents();
    }

    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
    }

    public void stateChanged(ChangeEvent e) {
        switch (this.orientation) {
            case 0: {
                if (this.viewport.getView().getHeight() > this.viewport.getExtentSize().height) {
                    this.toolWindowScrollBarLayout.setRow(0, 14.0);
                    this.toolWindowScrollBarLayout.setRow(4, 14.0);
                    this.scrollEnabled = true;
                    break;
                }
                this.toolWindowScrollBarLayout.setRow(0, 0.0);
                this.toolWindowScrollBarLayout.setRow(4, 0.0);
                this.scrollEnabled = false;
                break;
            }
            case 1: {
                if (this.viewport.getView().getWidth() > this.viewport.getExtentSize().width) {
                    this.toolWindowScrollBarLayout.setColumn(0, 14.0);
                    this.toolWindowScrollBarLayout.setColumn(4, 14.0);
                    this.scrollEnabled = true;
                    break;
                }
                this.toolWindowScrollBarLayout.setColumn(0, 0.0);
                this.toolWindowScrollBarLayout.setColumn(4, 0.0);
                this.scrollEnabled = false;
            }
        }
    }

    public void ensureVisible(Component component) {
        Rectangle cellBounds;
        boolean found = false;
        int size = this.container.getComponentCount();
        for (int i = 0; i < size; ++i) {
            Component containerComponent = this.container.getComponent(i);
            if (containerComponent != component && (!(containerComponent instanceof JComponent) || ((JComponent)containerComponent).getClientProperty("ra") != component)) continue;
            component = containerComponent;
            found = true;
            break;
        }
        if (found && (cellBounds = component.getBounds()) != null) {
            switch (this.orientation) {
                case 0: {
                    cellBounds.y -= this.viewport.getViewPosition().y;
                    this.viewport.scrollRectToVisible(cellBounds);
                    break;
                }
                case 1: {
                    cellBounds.x -= this.viewport.getViewPosition().x;
                    this.viewport.scrollRectToVisible(cellBounds);
                }
            }
        }
    }

    protected void installComponents() {
        this.viewport = new JViewport();
        this.viewport.setView(this.container);
        this.viewport.addMouseWheelListener(new WheelScroller());
        switch (this.orientation) {
            case 0: {
                this.toolWindowScrollBarLayout = new ExtendedTableLayout(new double[][]{{-1.0}, {0.0, 1.0, -1.0, 1.0, 0.0}});
                this.toolWindowScrollBar.setLayout(this.toolWindowScrollBarLayout);
                this.toolWindowScrollBar.add(this.renderArrow(Direction.LEFT, "ToolWindowScrollBarUI.arrow.icon.up"), "0,0,c,c");
                this.toolWindowScrollBar.add((Component)this.viewport, "0,2,FULL,FULL");
                this.toolWindowScrollBar.add(this.renderArrow(Direction.RIGHT, "ToolWindowScrollBarUI.arrow.icon.down"), "0,4,c,c");
                break;
            }
            case 1: {
                this.toolWindowScrollBarLayout = new ExtendedTableLayout(new double[][]{{0.0, 1.0, -1.0, 1.0, 0.0}, {-1.0}});
                this.toolWindowScrollBar.setLayout(this.toolWindowScrollBarLayout);
                this.toolWindowScrollBar.add(this.renderArrow(Direction.LEFT, "ToolWindowScrollBarUI.arrow.icon.left"), "0,0,c,c");
                this.toolWindowScrollBar.add((Component)this.viewport, "2,0,FULL,FULL");
                this.toolWindowScrollBar.add(this.renderArrow(Direction.RIGHT, "ToolWindowScrollBarUI.arrow.icon.right"), "4,0,c,c");
            }
        }
        this.viewport.addChangeListener(this);
    }

    protected void scrollBy(int direction, int units) {
        block0 : switch (this.orientation) {
            case 0: {
                switch (direction) {
                    case 0: {
                        Rectangle visRect = this.viewport.getViewRect();
                        Rectangle bounds = this.container.getBounds();
                        visRect.y += units;
                        if (visRect.y + visRect.height >= bounds.height) {
                            visRect.y = bounds.height - visRect.height;
                        }
                        this.viewport.setViewPosition(new Point(visRect.x, visRect.y));
                        break;
                    }
                    case 1: {
                        Rectangle visRect = this.viewport.getViewRect();
                        visRect.y -= units;
                        if (visRect.y < 0) {
                            visRect.y = 0;
                        }
                        this.viewport.setViewPosition(new Point(visRect.x, visRect.y));
                    }
                }
                break;
            }
            case 1: {
                switch (direction) {
                    case 0: {
                        Rectangle visRect = this.viewport.getViewRect();
                        Rectangle bounds = this.container.getBounds();
                        visRect.x += units;
                        if (visRect.x + visRect.width >= bounds.width) {
                            visRect.x = bounds.width - visRect.width;
                        }
                        this.viewport.setViewPosition(new Point(visRect.x, visRect.y));
                        break block0;
                    }
                    case 1: {
                        Rectangle visRect = this.viewport.getViewRect();
                        visRect.x -= units;
                        if (visRect.x < 0) {
                            visRect.x = 0;
                        }
                        this.viewport.setViewPosition(new Point(visRect.x, visRect.y));
                    }
                }
            }
        }
    }

    protected Component renderArrow(Direction direction, String iconName) {
        JLabel label = new JLabel(){

            public void setUI(LabelUI ui) {
                if (ui instanceof ToolScrollBarArrowUI) {
                    super.setUI(ui);
                }
            }
        };
        label.setUI(new ToolScrollBarArrowUI());
        label.setPreferredSize(new Dimension(16, 16));
        label.setHorizontalAlignment(0);
        label.setVerticalAlignment(0);
        label.setOpaque(false);
        label.setFocusable(false);
        label.setBackground(Colors.orange);
        label.setIcon(UIManager.getIcon(iconName));
        label.addMouseListener(new ArrowListener(direction));
        return label;
    }

    public static class ToolScrollBarArrowUI
    extends MetalLabelUI
    implements MouseListener {
        protected LineBorder labelBorder;

        public void installUI(JComponent c) {
            super.installUI(c);
            this.labelBorder = new LineBorder(Color.GRAY, 1, true, 3, 3);
            c.setBorder(this.labelBorder);
        }

        protected void installListeners(JLabel c) {
            super.installListeners(c);
            c.addMouseListener(this);
        }

        protected void uninstallListeners(JLabel c) {
            super.uninstallListeners(c);
            c.removeMouseListener(this);
        }

        public void update(Graphics g, JComponent c) {
            if (c.isOpaque()) {
                GraphicsUtil.fillRect(g, new Rectangle(0, 0, c.getWidth(), c.getHeight()), UIManager.getColor("ToolWindowScrollBarUI.arrow.background.start"), UIManager.getColor("ToolWindowScrollBarUI.arrow.background.end"), null, 1);
            } else {
                g.setColor(c.getParent().getBackground());
                g.fillRect(0, 0, c.getWidth(), c.getHeight());
            }
            this.paint(g, c);
        }

        public void mouseEntered(MouseEvent e) {
            Component source = e.getComponent();
            if (!source.isOpaque()) {
                this.labelBorder.setLineColor(Color.BLACK);
                SwingUtil.repaint(source);
            }
        }

        public void mouseExited(MouseEvent e) {
            Component source = e.getComponent();
            if (!source.isOpaque()) {
                this.labelBorder.setLineColor(Color.GRAY);
                SwingUtil.repaint(source);
            }
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }
    }

    public class WheelScroller
    implements MouseWheelListener {
        public void mouseWheelMoved(MouseWheelEvent e) {
            if (ToolWindowScrollBarUI.this.scrollEnabled) {
                ToolWindowScrollBarUI.this.scrollBy(e.getWheelRotation() == 1 ? 1 : 0, e.getScrollAmount() * 3);
            }
        }
    }

    public class ArrowListener
    extends MouseAdapter
    implements ActionListener {
        protected Timer scrollTimer = new Timer(60, this);
        protected int direction;

        public ArrowListener(Direction direction) {
            this.direction = direction == Direction.RIGHT ? 0 : 1;
        }

        public void mousePressed(MouseEvent e) {
            if (!SwingUtilities.isLeftMouseButton(e)) {
                return;
            }
            JComponent c = (JComponent)e.getComponent();
            c.setOpaque(true);
            SwingUtil.repaint(c);
            ToolWindowScrollBarUI.this.scrollBy(this.direction, 10);
            this.scrollTimer.stop();
            this.scrollTimer.start();
        }

        public void mouseReleased(MouseEvent e) {
            JComponent c = (JComponent)e.getComponent();
            c.setOpaque(false);
            SwingUtil.repaint(c);
            this.scrollTimer.stop();
        }

        public void actionPerformed(ActionEvent e) {
            ToolWindowScrollBarUI.this.scrollBy(this.direction, 15);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Direction {
        LEFT,
        RIGHT;

    }
}

