/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.util.swing.validation;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.ImageIcon;
import javax.swing.InputVerifier;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import nl.lxtreme.ols.util.swing.SwingComponentUtils;
import nl.lxtreme.ols.util.swing.validation.IValidator;
import nl.lxtreme.ols.util.swing.validation.NumberValidator;

public class JComponentInputVerifier
extends InputVerifier
implements KeyListener {
    private static final String DEFAULT_MESSAGE = "Input invalid!";
    private static final byte[] ERROR_GIF_BYTES = new byte[]{71, 73, 70, 56, 57, 97, 16, 0, 16, 0, -77, 0, 0, -1, 127, 63, -8, 88, 56, -1, 95, 63, -8, 56, 56, -33, 63, 63, -65, 63, 63, -104, 56, 56, 127, 63, 63, -1, -65, -65, -97, 127, 127, -1, -1, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 33, -7, 4, 1, 0, 0, 11, 0, 44, 0, 0, 0, 0, 16, 0, 16, 0, 0, 4, 84, 112, -55, 73, -85, -67, 120, -91, -62, 75, -54, -59, 32, 14, 68, 97, 92, 33, -96, 8, 65, -96, -104, 85, 50, 0, 0, -94, 12, 10, 82, 126, 83, 26, -32, 57, 18, -84, 55, 96, 1, 69, -91, 3, 37, -12, -77, -35, -124, 74, 98, -64, 54, -96, -106, 78, -109, 4, 1, 55, 66, 32, 76, -68, -119, -127, 64, 46, -101, -94, 21, 67, -121, 99, 64, 91, 18, -19, -125, 33, -100, -87, -37, 41, 17, 0, 59};
    private static final ImageIcon ERROR_ICON = new ImageIcon(ERROR_GIF_BYTES);
    private final String message;
    private final IValidator validator;
    private JDialog popup;

    public JComponentInputVerifier(IValidator aValidator) {
        this(DEFAULT_MESSAGE, aValidator);
    }

    public JComponentInputVerifier(String aMessage, IValidator aValidator) {
        this.message = aMessage;
        this.validator = aValidator;
    }

    public static JComponentInputVerifier create(Class<?> aType) {
        return JComponentInputVerifier.create(aType, DEFAULT_MESSAGE);
    }

    public static JComponentInputVerifier create(Class<?> aType, String aMessage) {
        IValidator validator = NumberValidator.isNumericType(aType) ? new NumberValidator(aType) : new DefaultValidator();
        return new JComponentInputVerifier(aMessage, validator);
    }

    @Override
    public final void keyPressed(KeyEvent aEvent) {
        ((Component)aEvent.getSource()).removeKeyListener(this);
        if (this.popup != null) {
            this.popup.setVisible(false);
            this.popup.dispose();
            this.popup = null;
        }
    }

    @Override
    public final void keyReleased(KeyEvent aEvent) {
        ((Component)aEvent.getSource()).removeKeyListener(this);
    }

    @Override
    public final void keyTyped(KeyEvent aEvent) {
        ((Component)aEvent.getSource()).removeKeyListener(this);
    }

    @Override
    public final boolean verify(JComponent aInput) {
        Object value = this.getInputValue(aInput);
        if (value == null) {
            return true;
        }
        boolean result = this.validator.validate(value);
        if (!result) {
            if (this.popup != null && this.popup.getOwner() != SwingComponentUtils.getOwningWindow(aInput)) {
                this.popup.setVisible(false);
                this.popup.dispose();
                this.popup = null;
            }
            if (this.popup == null) {
                this.popup = this.createMessagePopup(aInput);
            }
            aInput.addKeyListener(this);
            aInput.setBackground(Color.PINK);
            Point point = aInput.getLocationOnScreen();
            Dimension componentSize = aInput.getSize();
            this.popup.setSize(0, 0);
            this.popup.setLocation(point.x + (int)componentSize.getWidth() / 2, point.y + (int)componentSize.getHeight() / 2);
            this.popup.pack();
            this.popup.setVisible(true);
        } else {
            aInput.setBackground(Color.WHITE);
        }
        return result;
    }

    protected Object getInputValue(Component aComponent) {
        if (aComponent instanceof JComboBox) {
            return ((JComboBox)aComponent).getSelectedItem();
        }
        if (aComponent instanceof JTextField) {
            if (SwingUtilities.getAncestorOfClass(JComboBox.class, aComponent) == null && SwingUtilities.getAncestorOfClass(JSpinner.class, aComponent) == null) {
                return ((JTextField)aComponent).getText();
            }
        } else {
            if (aComponent instanceof JSlider) {
                return ((JSlider)aComponent).getValue();
            }
            if (aComponent instanceof JCheckBox) {
                return ((JCheckBox)aComponent).isSelected();
            }
        }
        return null;
    }

    protected String getMessage() {
        return this.message;
    }

    private JDialog createMessagePopup(JComponent aComponent) {
        String message = this.getMessage();
        if (message == null || "".equals(message.trim())) {
            message = DEFAULT_MESSAGE;
        }
        JDialog result = new JDialog(SwingComponentUtils.getOwningWindow(aComponent));
        result.setFocusableWindowState(false);
        result.setUndecorated(true);
        Container contentPane = result.getContentPane();
        contentPane.setLayout(new FlowLayout());
        contentPane.add(new JLabel(ERROR_ICON));
        contentPane.add(new JLabel(message));
        return result;
    }

    private static final class DefaultValidator
    implements IValidator {
        private DefaultValidator() {
        }

        @Override
        public boolean validate(Object aValue) {
            return true;
        }
    }
}

