/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.util;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Comparator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class NumberUtils {
    private static final Pattern SMART_INT_PATTERN = Pattern.compile("^([-+]?\\d+)(?:\\s*([kKM]))?.*$");

    private NumberUtils() {
    }

    public static int convertBitOrder(int aValue, int aBitCount, BitOrder aBitOrder) {
        if (aBitCount <= 0 || aBitCount > 32) {
            throw new IllegalArgumentException("Bit count cannot be zero, negative or beyond 32-bits!");
        }
        if (aBitOrder == BitOrder.MSB_FIRST) {
            return aValue & NumberUtils.getBitMask(aBitCount);
        }
        return NumberUtils.reverseBits(aValue, aBitCount);
    }

    public static int convertByteOrder(int aValue, int aByteCount, ByteOrder aByteOrder) {
        if (aByteCount <= 0 || aByteCount > 32) {
            throw new IllegalArgumentException("Bit count cannot be zero, negative or beyond 32-bits!");
        }
        ByteBuffer buf = ByteBuffer.allocate(aByteCount);
        buf.putInt(aValue);
        buf.order(aByteOrder);
        buf.position(0);
        int result = buf.getInt();
        return result;
    }

    public static <T extends Number> Comparator<T> createNumberComparator(boolean aSortAscending) {
        return new NumericComparator(aSortAscending);
    }

    public static int getBitIndex(int aMaskValue) {
        return (int)Math.floor(Math.log(aMaskValue) / Math.log(2.0));
    }

    public static int getBitMask(int aBitCount) {
        if (aBitCount <= 0 || aBitCount > 32) {
            throw new IllegalArgumentException("Invalid bit count, should be > 0 && <= 32.");
        }
        return (int)((1L << aBitCount) - 1L);
    }

    public static int getPercentage(int aValue, int aRange) {
        double value = 0.0;
        if (aRange != 0) {
            value = (double)aValue * 100.0 / (double)aRange;
        }
        return (int)Math.max(0.0, Math.min(100.0, value));
    }

    public static int getPercentage(int aValue, int aLowerBound, int aUpperBound) {
        int range;
        int value = aValue;
        if (aLowerBound > aUpperBound) {
            range = aLowerBound - aUpperBound;
            value = Math.max(0, value - aUpperBound);
        } else {
            range = aUpperBound - aLowerBound;
            value = Math.max(0, value - aLowerBound);
        }
        return NumberUtils.getPercentage(value, range);
    }

    public static int getPercentage(long aValue, long aRange) {
        double value = 0.0;
        if (aRange != 0L) {
            value = (double)aValue * 100.0 / (double)aRange;
        }
        return (int)Math.max(0.0, Math.min(100.0, value));
    }

    public static int getPercentage(long aValue, long aLowerBound, long aUpperBound) {
        long range;
        long value = aValue;
        if (aLowerBound > aUpperBound) {
            range = aLowerBound - aUpperBound;
            value = Math.max(0L, value - aUpperBound);
        } else {
            range = aUpperBound - aLowerBound;
            value = Math.max(0L, value - aLowerBound);
        }
        return NumberUtils.getPercentage(value, range);
    }

    public static boolean isPowerOfTwo(int aValue) {
        return aValue != 0 && (aValue & aValue - 1) == 0;
    }

    public static int packBytes(int aValue) {
        int mask = -16777216;
        int result = 0;
        int i = 0;
        int j = 3;
        while (i < 4) {
            int tmp = (aValue & mask) >> j * 8;
            if (tmp != 0) {
                result <<= 8;
                result |= tmp;
            }
            mask >>>= 8;
            ++i;
            --j;
        }
        return result;
    }

    public static int reverseBits(int aValue, int aBitCount) {
        if (NumberUtils.isPowerOfTwo(aBitCount)) {
            long v = aValue;
            int s = aBitCount;
            int mask = NumberUtils.getBitMask(aBitCount);
            while ((s >>= 1) > 0) {
                mask ^= mask << s;
                v = v >> s & (long)mask | v << s & (long)(~mask);
            }
            return (int)v;
        }
        int r = 0;
        int s = aBitCount;
        for (int v = aValue; v != 0; v >>= 1) {
            r <<= 1;
            r |= v & 1;
            --s;
        }
        if (s >= 0) {
            r <<= s;
        }
        return r;
    }

    public static int safeParseInt(String aText) {
        return NumberUtils.safeParseInt(aText, -1);
    }

    public static int safeParseInt(String aText, int aDefault) {
        try {
            return Integer.parseInt(aText);
        }
        catch (NumberFormatException exception) {
            return aDefault;
        }
    }

    public static long safeParseLong(String aText) {
        return NumberUtils.safeParseLong(aText, -1L);
    }

    public static long safeParseLong(String aText, long aDefault) {
        try {
            return Long.parseLong(aText);
        }
        catch (NumberFormatException exception) {
            return aDefault;
        }
    }

    public static int smartParseInt(String aText) {
        return NumberUtils.smartParseInt(aText, 0);
    }

    public static int smartParseInt(String aText, int aDefault) {
        return NumberUtils.smartParseInt(aText, UnitDefinition.BINARY, aDefault);
    }

    public static int smartParseInt(String aText, UnitDefinition aUnitDefinition) {
        return NumberUtils.smartParseInt(aText, aUnitDefinition, 0);
    }

    public static int smartParseInt(String aText, UnitDefinition aUnitDefinition, int aDefault) {
        if (aText == null || aText.trim().isEmpty()) {
            return aDefault;
        }
        Matcher matcher = SMART_INT_PATTERN.matcher(aText);
        if (matcher.matches()) {
            String number = matcher.group(1);
            String unit = matcher.group(2);
            int result = Integer.parseInt(number);
            if (unit != null) {
                result = (int)((long)result * NumberUtils.parseUnit(unit, aUnitDefinition));
            }
            return result;
        }
        return aDefault;
    }

    private static long parseUnit(String aUnit, UnitDefinition aUnitDefinition) {
        if ("k".equalsIgnoreCase(aUnit)) {
            return UnitDefinition.SI == aUnitDefinition ? 1000L : 1024L;
        }
        if ("m".equalsIgnoreCase(aUnit)) {
            return UnitDefinition.SI == aUnitDefinition ? 1000000L : 0x100000L;
        }
        if ("g".equalsIgnoreCase(aUnit)) {
            return UnitDefinition.SI == aUnitDefinition ? 1000000000L : 0x40000000L;
        }
        return 1L;
    }

    private static class NumericComparator<N extends Number>
    implements Serializable,
    Comparator<N> {
        private static final long serialVersionUID = 1L;
        private final boolean sortAscending;

        NumericComparator(boolean aSortAscending) {
            this.sortAscending = aSortAscending;
        }

        @Override
        public int compare(N aO1, N aO2) {
            if (aO1 instanceof Comparable) {
                return this.sortAscending ? ((Comparable)aO1).compareTo(aO2) : ((Comparable)aO2).compareTo(aO1);
            }
            throw new IllegalArgumentException("Your number instance should implement Comparable!");
        }
    }

    public static enum UnitDefinition {
        SI,
        BINARY;

    }

    public static enum BitOrder {
        LSB_FIRST,
        MSB_FIRST;

    }
}

