/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.logging;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogService;
import org.osgi.util.tracker.ServiceTracker;

public final class JdkLogForwarder {
    private static final String LOG_SERVICE_CLASS_NAME = LogService.class.getName();
    private final BundleContext bundleContext;
    private final Handler defaultHandler;
    private final ServiceTracker logServiceTracker;
    private final BundleListener bundleListener;
    private Handler logHandler;

    public JdkLogForwarder(BundleContext aBundleContext) {
        this(aBundleContext, null);
    }

    public JdkLogForwarder(BundleContext aBundleContext, Handler aDefaultHandler) {
        this.bundleContext = aBundleContext;
        this.defaultHandler = aDefaultHandler != null ? aDefaultHandler : new ConsoleHandler();
        this.logServiceTracker = new LogServiceServiceTracker(aBundleContext);
        this.bundleListener = new BundleTracker();
        this.logHandler = this.defaultHandler;
    }

    public void start() throws IOException {
        this.bundleContext.addBundleListener(this.bundleListener);
        this.logServiceTracker.open();
    }

    public void stop() {
        this.bundleContext.removeBundleListener(this.bundleListener);
        this.logServiceTracker.close();
        LogManager logManager = LogManager.getLogManager();
        logManager.reset();
    }

    final Handler getCurrentHandler() {
        return this.logHandler;
    }

    final void setCurrentHandler(LogService aLogService) {
        if (aLogService != null) {
            this.logHandler = new OsgiLogDelegateHandler(aLogService);
            this.updateLogHandler(this.logHandler);
        } else {
            this.logHandler = this.defaultHandler;
            this.updateLogHandler(this.logHandler);
        }
    }

    final void updateLogHandler(Handler aHandler) {
        LogManager logManager = LogManager.getLogManager();
        Enumeration<String> loggerNames = logManager.getLoggerNames();
        while (loggerNames.hasMoreElements()) {
            String loggerName = loggerNames.nextElement();
            Logger logger = logManager.getLogger(loggerName);
            if (logger == null) continue;
            if (this.isNonJdkLogger(logger)) {
                logger.setUseParentHandlers(false);
                logger.setLevel(Level.ALL);
            }
            if (logger.getUseParentHandlers()) continue;
            this.replaceHandler(logger, aHandler);
        }
        this.replaceHandler(Logger.getLogger(""), aHandler);
    }

    private boolean isNonJdkLogger(Logger aLogger) {
        String loggerName = aLogger.getName();
        return !loggerName.startsWith("java.") && !loggerName.startsWith("sun.") && !loggerName.startsWith("javax.") && !loggerName.equals("global") && !loggerName.isEmpty();
    }

    private void replaceHandler(Logger aLogger, Handler aHandler) {
        Handler[] handlers = aLogger.getHandlers();
        if (handlers.length == 1 && handlers[0].equals(aHandler)) {
            return;
        }
        for (Handler handler : handlers) {
            aLogger.removeHandler(handler);
            handler.close();
        }
        aLogger.addHandler(aHandler);
    }

    static class OsgiLogDelegateHandler
    extends Handler {
        private final LogService logService;

        public OsgiLogDelegateHandler(LogService aLogService) {
            this.logService = aLogService;
        }

        private static final int toOSGiLogLevel(Level aLevel) {
            boolean all;
            boolean bl = all = aLevel == Level.ALL;
            if (all || aLevel == Level.SEVERE) {
                return 1;
            }
            if (all || aLevel == Level.WARNING) {
                return 2;
            }
            if (all || aLevel == Level.INFO || aLevel == Level.CONFIG) {
                return 3;
            }
            return 4;
        }

        @Override
        public void close() throws SecurityException {
        }

        @Override
        public void flush() {
        }

        @Override
        public void publish(LogRecord aRecord) {
            if (aRecord.getLevel() == Level.OFF) {
                return;
            }
            if (aRecord.getThrown() != null) {
                this.logService.log(OsgiLogDelegateHandler.toOSGiLogLevel(aRecord.getLevel()), this.getMessage(aRecord), aRecord.getThrown());
            } else {
                this.logService.log(OsgiLogDelegateHandler.toOSGiLogLevel(aRecord.getLevel()), this.getMessage(aRecord));
            }
        }

        private String getMessage(LogRecord aRecord) {
            String result = "[[".concat(aRecord.getLoggerName()).concat("]]").concat(aRecord.getMessage());
            Object[] params = aRecord.getParameters();
            if (params != null && params.length > 0) {
                return MessageFormat.format(result, params);
            }
            return result;
        }
    }

    final class LogServiceServiceTracker
    extends ServiceTracker {
        public LogServiceServiceTracker(BundleContext aBundleContext) {
            super(aBundleContext, LOG_SERVICE_CLASS_NAME, null);
        }

        public Object addingService(ServiceReference aReference) {
            LogService logService = (LogService)super.addingService(aReference);
            JdkLogForwarder.this.setCurrentHandler(logService);
            return logService;
        }

        public void removedService(ServiceReference aReference, Object aService) {
            JdkLogForwarder.this.setCurrentHandler(null);
            super.removedService(aReference, aService);
        }
    }

    final class BundleTracker
    implements BundleListener {
        BundleTracker() {
        }

        public void bundleChanged(BundleEvent aEvent) {
            if (aEvent.getType() == 1) {
                JdkLogForwarder.this.updateLogHandler(JdkLogForwarder.this.getCurrentHandler());
            }
        }
    }
}

