/*
 * Decompiled with CFR 0.152.
 */
package org.noos.xing.mydoggy.plaf.ui.look;

import info.clearthought.layout.TableLayout;
import info.clearthought.layout.TableLayoutConstraints;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicPanelUI;
import org.noos.xing.mydoggy.ToolWindow;
import org.noos.xing.mydoggy.ToolWindowListener;
import org.noos.xing.mydoggy.ToolWindowTab;
import org.noos.xing.mydoggy.event.ToolWindowTabEvent;
import org.noos.xing.mydoggy.plaf.MyDoggyToolWindowTab;
import org.noos.xing.mydoggy.plaf.cleaner.Cleaner;
import org.noos.xing.mydoggy.plaf.support.PropertyChangeBridge;
import org.noos.xing.mydoggy.plaf.ui.PopupUpdater;
import org.noos.xing.mydoggy.plaf.ui.ToolWindowDescriptor;
import org.noos.xing.mydoggy.plaf.ui.cmp.ExtendedTableLayout;
import org.noos.xing.mydoggy.plaf.ui.cmp.ToolWindowTabButton;
import org.noos.xing.mydoggy.plaf.ui.cmp.ToolWindowTabPanel;
import org.noos.xing.mydoggy.plaf.ui.cmp.ToolWindowTitleButton;
import org.noos.xing.mydoggy.plaf.ui.drag.DragListener;
import org.noos.xing.mydoggy.plaf.ui.drag.DragListenerDelegate;
import org.noos.xing.mydoggy.plaf.ui.look.TitleBarMouseAdapter;
import org.noos.xing.mydoggy.plaf.ui.util.MouseEventDispatcher;
import org.noos.xing.mydoggy.plaf.ui.util.RemoveNotifyDragListener;
import org.noos.xing.mydoggy.plaf.ui.util.SwingUtil;

public class ToolWindowTabPanelUI
extends BasicPanelUI
implements Cleaner {
    protected ToolWindowTabPanel toolWindowTabPanel;
    protected ToolWindowDescriptor descriptor;
    protected ToolWindow toolWindow;
    protected JViewport viewport;
    protected JPanel tabContainer;
    protected TableLayout containerLayout;
    protected ToolWindowTab selectedTab;
    protected Component selecTabButton;
    protected PopupButton popupButton;
    protected MouseEventDispatcher mouseEventDispatcher;
    protected PropertyChangeBridge propertyChangeBridge;
    protected ToolWindowListener toolWindowListener;
    protected MouseListener titleBarMouseListener;
    protected PopupUpdater popupUpdater;
    protected DragListenerDelegate dragListenerDelegate;
    protected RemoveNotifyDragListener removeNotifyDragListener;

    public static ComponentUI createUI(JComponent c) {
        return new ToolWindowTabPanelUI();
    }

    public void cleanup() {
        this.uninstallUI(this.toolWindowTabPanel);
    }

    public void installUI(JComponent c) {
        this.toolWindowTabPanel = (ToolWindowTabPanel)c;
        this.descriptor = this.toolWindowTabPanel.getToolWindowDescriptor();
        this.toolWindow = this.descriptor.getToolWindow();
        this.mouseEventDispatcher = new MouseEventDispatcher();
        this.dragListenerDelegate = new DragListenerDelegate();
        super.installUI(c);
    }

    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        this.toolWindow = null;
        this.descriptor = null;
        this.selectedTab = null;
        this.selecTabButton = null;
        this.dragListenerDelegate = null;
    }

    protected void installDefaults(JPanel p) {
        super.installDefaults(p);
        this.installComponents();
        this.installListeners();
    }

    protected void uninstallDefaults(JPanel p) {
        super.uninstallDefaults(p);
        this.uninstallListeners();
    }

    protected void installComponents() {
        this.toolWindowTabPanel.setLayout(new ExtendedTableLayout(new double[][]{{-1.0, 1.0, 14.0}, {0.0, -1.0, 0.0}}, false));
        this.toolWindowTabPanel.setFocusable(false);
        this.toolWindowTabPanel.setBorder(null);
        this.toolWindowTabPanel.setOpaque(false);
        this.containerLayout = new TableLayout(new double[][]{{0.0}, {SwingUtil.getInt("ToolWindowTitleBarUI.length", 16)}});
        this.tabContainer = new JPanel();
        this.tabContainer.setLayout(this.containerLayout);
        this.tabContainer.setName("toolWindow.tabContainer." + this.descriptor.getToolWindow().getId());
        this.tabContainer.setOpaque(false);
        this.tabContainer.setBorder(null);
        this.tabContainer.setFocusable(false);
        this.viewport = new JViewport();
        this.viewport.setBorder(null);
        this.viewport.setOpaque(false);
        this.viewport.setFocusable(false);
        this.viewport.setView(this.tabContainer);
        this.toolWindowTabPanel.add((Component)this.viewport, "0,1,FULL,FULL");
        this.popupButton = new PopupButton();
        this.toolWindowTabPanel.add((Component)this.popupButton, "2,1,FULL,FULL");
        this.viewport.addMouseWheelListener(new WheelScroller());
        this.propertyChangeBridge = new PropertyChangeBridge();
        this.propertyChangeBridge.addBridgePropertyChangeListener("selected", new TabSelectedPropertyChangeListener());
        this.propertyChangeBridge.addBridgePropertyChangeListener("minimized", new TabMinimizedPropertyChangeListener());
        this.initTabs();
    }

    protected void installListeners() {
        this.descriptor.getCleaner().addCleaner(this.propertyChangeBridge);
        this.descriptor.getCleaner().addCleaner(this);
        this.popupUpdater = new TabPopupUpdater();
        this.descriptor.addPopupUpdater(this.popupUpdater);
        this.toolWindowListener = new TabPanelToolWindowListener();
        this.toolWindow.addToolWindowListener(this.toolWindowListener);
        this.titleBarMouseListener = new TitleBarMouseAdapter(this.descriptor);
        this.viewport.addMouseListener(this.titleBarMouseListener);
        this.viewport.addMouseListener(this.mouseEventDispatcher);
        this.viewport.addMouseMotionListener(this.mouseEventDispatcher);
        this.removeNotifyDragListener = new RemoveNotifyDragListener(this.viewport, this.dragListenerDelegate);
        this.descriptor.getManager().addRemoveNotifyListener(this.removeNotifyDragListener);
    }

    protected void uninstallListeners() {
        this.propertyChangeBridge.cleanup();
        this.descriptor.getCleaner().removeCleaner(this.propertyChangeBridge);
        this.descriptor.getCleaner().removeCleaner(this);
        this.descriptor.removePopupUpdater(this.popupUpdater);
        this.descriptor.getCleaner().removeCleaner((Cleaner)((Object)this.toolWindowListener));
        this.toolWindow.removeToolWindowListener(this.toolWindowListener);
        this.viewport.removeMouseListener(this.titleBarMouseListener);
        this.viewport.removeMouseListener(this.mouseEventDispatcher);
        this.viewport.removeMouseMotionListener(this.mouseEventDispatcher);
        this.removeNotifyDragListener.cleanup();
        this.descriptor.getManager().removeRemoveNotifyListener(this.removeNotifyDragListener);
    }

    public void setDragListener(DragListener dragListener) {
        this.dragListenerDelegate.setDragListener(dragListener);
    }

    public DragListener getDragListener() {
        return this.dragListenerDelegate;
    }

    public MouseEventDispatcher getMouseEventDispatcher() {
        return this.mouseEventDispatcher;
    }

    public void addEventDispatcherlListener(EventListener eventListener) {
        this.mouseEventDispatcher.addListener(eventListener);
    }

    public void removeEventDispatcherlListener(EventListener eventListener) {
        this.mouseEventDispatcher.removeListener(eventListener);
    }

    public void ensureVisible(final Rectangle bounds) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                bounds.x -= ToolWindowTabPanelUI.this.viewport.getViewPosition().x;
                ToolWindowTabPanelUI.this.viewport.scrollRectToVisible(bounds);
            }
        });
    }

    protected void initTabs() {
        for (ToolWindowTab tab : this.toolWindow.getToolWindowTabs()) {
            this.addTab((MyDoggyToolWindowTab)tab);
        }
        this.checkPopupButton();
    }

    protected void addTab(Component tabButton) {
        int column = this.containerLayout.getNumColumn();
        this.containerLayout.insertColumn(column, 0.0);
        this.containerLayout.insertColumn(column + 1, -2.0);
        this.containerLayout.insertColumn(column + 2, 0.0);
        this.tabContainer.add(tabButton, column + 1 + ",0" + ",FULL,FULL");
        SwingUtil.repaint(this.tabContainer);
    }

    protected void addTab(MyDoggyToolWindowTab tab) {
        ToolWindowTabButton tabButton = new ToolWindowTabButton(tab, this.toolWindowTabPanel);
        tab.removePlafPropertyChangeListener(this.propertyChangeBridge);
        tab.addPlafPropertyChangeListener(this.propertyChangeBridge);
        this.addTab(tabButton);
    }

    protected ToolWindowTab getNextTab(ToolWindowTab toolWindowTab) {
        TableLayoutConstraints constraints;
        ToolWindowTabButton tabButton;
        int nextTabCol = -1;
        for (Component component : this.tabContainer.getComponents()) {
            if (!(component instanceof ToolWindowTabButton) || (tabButton = (ToolWindowTabButton)component).getToolWindowTab() != toolWindowTab) continue;
            constraints = this.containerLayout.getConstraints(component);
            nextTabCol = constraints.col1 + 3;
            break;
        }
        if (nextTabCol != -1) {
            for (Component component : this.tabContainer.getComponents()) {
                if (!(component instanceof ToolWindowTabButton)) continue;
                tabButton = (ToolWindowTabButton)component;
                constraints = this.containerLayout.getConstraints(tabButton);
                if (constraints.col1 != nextTabCol) continue;
                return tabButton.getToolWindowTab();
            }
            for (ToolWindowTab windowTab : this.toolWindow.getToolWindowTabs()) {
                if (windowTab == toolWindowTab) continue;
                return windowTab;
            }
        }
        return null;
    }

    protected Component removeTab(ToolWindowTab toolWindowTab, boolean flag) {
        for (Component component : this.tabContainer.getComponents()) {
            ToolWindowTabButton tabButton;
            if (!(component instanceof ToolWindowTabButton) || (tabButton = (ToolWindowTabButton)component).getToolWindowTab() != toolWindowTab) continue;
            TableLayoutConstraints constraints = this.containerLayout.getConstraints(component);
            tabButton.setUI(null);
            this.tabContainer.remove(component);
            if (flag) {
                toolWindowTab.removePropertyChangeListener(this.propertyChangeBridge);
            }
            int col = constraints.col1 - 1;
            this.containerLayout.deleteColumn(col);
            this.containerLayout.deleteColumn(col);
            this.containerLayout.deleteColumn(col);
            return component;
        }
        return null;
    }

    protected void checkPopupButton() {
        boolean visible = this.toolWindow.getToolWindowTabs().length > 1;
        this.popupButton.setVisible(visible);
        ((TableLayout)this.toolWindowTabPanel.getLayout()).setColumn(2, visible ? 14.0 : 0.0);
    }

    public class SelectTabAction
    extends AbstractAction {
        private ToolWindowTab tab;

        public SelectTabAction(ToolWindowTab tab) {
            super(tab.getTitle());
            this.tab = tab;
        }

        public void actionPerformed(ActionEvent e) {
            this.tab.setSelected(true);
        }
    }

    public class SelectPreviousTabAction
    extends AbstractAction {
        public SelectPreviousTabAction() {
            super(SwingUtil.getString("@@tool.tab.selectPreviuos"));
        }

        public void actionPerformed(ActionEvent e) {
            ToolWindowTab[] tabs = ToolWindowTabPanelUI.this.toolWindow.getToolWindowTabs();
            if (ToolWindowTabPanelUI.this.selectedTab != null && ToolWindowTabPanelUI.this.selecTabButton != null) {
                int nextTabCol = ToolWindowTabPanelUI.this.containerLayout.getConstraints((Component)ToolWindowTabPanelUI.this.selecTabButton).col1 - 3;
                for (Component component : ToolWindowTabPanelUI.this.tabContainer.getComponents()) {
                    if (!(component instanceof ToolWindowTabButton)) continue;
                    ToolWindowTabButton tabButton = (ToolWindowTabButton)component;
                    TableLayoutConstraints constraints = ToolWindowTabPanelUI.this.containerLayout.getConstraints(tabButton);
                    if (constraints.col1 != nextTabCol) continue;
                    tabButton.getToolWindowTab().setSelected(true);
                    return;
                }
                if (tabs.length > 0) {
                    tabs[tabs.length - 1].setSelected(true);
                }
            } else if (tabs.length > 0) {
                tabs[tabs.length - 1].setSelected(true);
            }
        }
    }

    public class SelectNextTabAction
    extends AbstractAction {
        public SelectNextTabAction() {
            super(SwingUtil.getString("@@tool.tab.selectNext"));
        }

        public void actionPerformed(ActionEvent e) {
            ToolWindowTab[] tabs = ToolWindowTabPanelUI.this.toolWindow.getToolWindowTabs();
            if (ToolWindowTabPanelUI.this.selectedTab != null && ToolWindowTabPanelUI.this.selecTabButton != null) {
                int nextTabCol = ToolWindowTabPanelUI.this.containerLayout.getConstraints((Component)ToolWindowTabPanelUI.this.selecTabButton).col1 + 3;
                for (Component component : ToolWindowTabPanelUI.this.tabContainer.getComponents()) {
                    if (!(component instanceof ToolWindowTabButton)) continue;
                    ToolWindowTabButton tabButton = (ToolWindowTabButton)component;
                    TableLayoutConstraints constraints = ToolWindowTabPanelUI.this.containerLayout.getConstraints(tabButton);
                    if (constraints.col1 != nextTabCol) continue;
                    tabButton.getToolWindowTab().setSelected(true);
                    return;
                }
                if (tabs.length > 0) {
                    tabs[0].setSelected(true);
                }
            } else if (tabs.length > 0) {
                tabs[0].setSelected(true);
            }
        }
    }

    public class TabMinimizedPropertyChangeListener
    implements PropertyChangeListener {
        protected Map<ToolWindowTab, Component> minimizedTabs = new HashMap<ToolWindowTab, Component>();

        public void propertyChange(PropertyChangeEvent evt) {
            ToolWindowTab tab = (ToolWindowTab)evt.getSource();
            if (evt.getNewValue() == Boolean.TRUE) {
                ToolWindowTab nextTab = ToolWindowTabPanelUI.this.getNextTab(tab);
                if (tab.isSelected()) {
                    tab.setSelected(false);
                }
                this.minimizedTabs.put(tab, ToolWindowTabPanelUI.this.removeTab(tab, false));
                if (nextTab != null) {
                    nextTab.setSelected(true);
                }
            } else {
                ToolWindowTabPanelUI.this.addTab(this.minimizedTabs.remove(tab));
            }
            SwingUtil.repaint(ToolWindowTabPanelUI.this.toolWindowTabPanel);
        }
    }

    public class TabSelectedPropertyChangeListener
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent evt) {
            ToolWindowTab tab = (ToolWindowTab)evt.getSource();
            if (evt.getNewValue() == Boolean.TRUE) {
                if (ToolWindowTabPanelUI.this.selectedTab != null) {
                    ToolWindowTabPanelUI.this.selectedTab.setSelected(false);
                }
                ToolWindowTabPanelUI.this.selectedTab = tab;
            }
        }
    }

    public class TabPopupUpdater
    implements PopupUpdater {
        protected JMenuItem nextTabItem;
        protected JMenuItem previousTabItem;
        protected JMenuItem closeAllItem;

        public TabPopupUpdater() {
            this.nextTabItem = new JMenuItem(new SelectNextTabAction());
            this.previousTabItem = new JMenuItem(new SelectPreviousTabAction());
            this.closeAllItem = new JMenuItem(new CloseAllTabAction());
        }

        public void update(Component source, JPopupMenu popupMenu) {
            if (source.getParent() instanceof ToolWindowTabButton) {
                boolean enableByTabsCount = ToolWindowTabPanelUI.this.toolWindow.getToolWindowTabs().length > 1;
                ToolWindowTabButton tabButton = (ToolWindowTabButton)source.getParent();
                int index = 0;
                if (tabButton.getToolWindowTab().isCloseable()) {
                    JMenuItem closeItem = new JMenuItem(new CloseTabAction(tabButton.getToolWindowTab()));
                    popupMenu.add((Component)closeItem, index++);
                    popupMenu.add((Component)this.closeAllItem, index++);
                    popupMenu.add((Component)new JSeparator(), index++);
                }
                popupMenu.add((Component)this.nextTabItem, index++);
                popupMenu.add((Component)this.previousTabItem, index++);
                popupMenu.add((Component)new JSeparator(), index);
                this.nextTabItem.setEnabled(enableByTabsCount);
                this.previousTabItem.setEnabled(enableByTabsCount);
            }
        }

        class CloseAllTabAction
        extends AbstractAction {
            public CloseAllTabAction() {
                super(SwingUtil.getString("@@tool.tab.closeAll"));
            }

            public void actionPerformed(ActionEvent e) {
                ToolWindowTab selectedTab = null;
                for (ToolWindowTab tab : ToolWindowTabPanelUI.this.toolWindow.getToolWindowTabs()) {
                    if (tab.isSelected()) {
                        selectedTab = tab;
                        continue;
                    }
                    this.tryToClose(tab);
                }
                this.tryToClose(selectedTab);
            }

            protected void tryToClose(ToolWindowTab tab) {
                if (tab != null && tab.isCloseable()) {
                    ToolWindowListener listener;
                    boolean result;
                    ToolWindowTabEvent event = new ToolWindowTabEvent(this, ToolWindowTabEvent.ActionId.TAB_REMOVING, ToolWindowTabPanelUI.this.toolWindow, tab);
                    ToolWindowListener[] arr$ = ToolWindowTabPanelUI.this.toolWindow.getToolWindowListeners();
                    int len$ = arr$.length;
                    for (int i$ = 0; i$ < len$ && (result = (listener = arr$[i$]).toolWindowTabRemoving(event)); ++i$) {
                    }
                    ToolWindowTabPanelUI.this.toolWindow.removeToolWindowTab(tab);
                }
            }
        }

        class CloseTabAction
        extends AbstractAction {
            ToolWindowTab tab;

            public CloseTabAction(ToolWindowTab tab) {
                super(SwingUtil.getString("@@tool.tab.close"));
                this.tab = tab;
            }

            public void actionPerformed(ActionEvent e) {
                if (this.tab.isCloseable()) {
                    ToolWindowListener listener;
                    boolean result;
                    ToolWindowTabEvent event = new ToolWindowTabEvent(this, ToolWindowTabEvent.ActionId.TAB_REMOVING, ToolWindowTabPanelUI.this.toolWindow, this.tab);
                    ToolWindowListener[] arr$ = ToolWindowTabPanelUI.this.toolWindow.getToolWindowListeners();
                    int len$ = arr$.length;
                    for (int i$ = 0; i$ < len$ && (result = (listener = arr$[i$]).toolWindowTabRemoving(event)); ++i$) {
                    }
                    ToolWindowTabPanelUI.this.toolWindow.removeToolWindowTab(this.tab);
                }
            }
        }
    }

    public class WheelScroller
    implements MouseWheelListener {
        public void mouseWheelMoved(MouseWheelEvent e) {
            switch (e.getWheelRotation()) {
                case 1: {
                    Rectangle visRect = ToolWindowTabPanelUI.this.viewport.getViewRect();
                    Rectangle bounds = ToolWindowTabPanelUI.this.tabContainer.getBounds();
                    visRect.x += e.getUnitsToScroll() * 2;
                    if (visRect.x + visRect.width >= bounds.width) {
                        visRect.x = bounds.width - visRect.width;
                    }
                    ToolWindowTabPanelUI.this.viewport.setViewPosition(new Point(visRect.x, visRect.y));
                    break;
                }
                case -1: {
                    Rectangle visRect = ToolWindowTabPanelUI.this.viewport.getViewRect();
                    visRect.x += e.getUnitsToScroll() * 2;
                    if (visRect.x < 0) {
                        visRect.x = 0;
                    }
                    ToolWindowTabPanelUI.this.viewport.setViewPosition(new Point(visRect.x, visRect.y));
                }
            }
        }
    }

    public class PopupButton
    extends ToolWindowTitleButton
    implements ActionListener,
    MouseListener {
        protected JPopupMenu popupMenu;

        public PopupButton() {
            super(UIManager.getIcon("ToolWindowTabPanelUI.icon.toolWindowTabPopup"));
            this.setVisible(false);
            this.initListeners();
        }

        public void actionPerformed(ActionEvent e) {
            this.initPopup();
            this.popupMenu.show(this, 10, 10);
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
            ToolWindowTabPanelUI.this.toolWindow.setActive(true);
        }

        public void mouseReleased(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        protected void initListeners() {
            this.addActionListener(this);
            this.addMouseListener(this);
        }

        protected void initPopup() {
            if (this.popupMenu == null) {
                this.popupMenu = new JPopupMenu("TabPopup");
                this.popupMenu.add(new SelectNextTabAction());
                this.popupMenu.add(new SelectPreviousTabAction());
                this.popupMenu.addSeparator();
            }
            int size = this.popupMenu.getComponentCount();
            for (int i = 3; i < size; ++i) {
                this.popupMenu.remove(3);
            }
            for (ToolWindowTab tab : ToolWindowTabPanelUI.this.toolWindow.getToolWindowTabs()) {
                this.popupMenu.add(new SelectTabAction(tab));
            }
        }
    }

    public class TabPanelToolWindowListener
    implements ToolWindowListener,
    Cleaner {
        protected Map<ToolWindowTab, Component> minimizedTabs = new HashMap<ToolWindowTab, Component>();

        public TabPanelToolWindowListener() {
            ToolWindowTabPanelUI.this.descriptor.getCleaner().addBefore(ToolWindowTabPanelUI.this.toolWindowTabPanel, this);
        }

        public void cleanup() {
            ToolWindowTabPanelUI.this.descriptor.getToolWindow().removeToolWindowListener(this);
            ToolWindowTabPanelUI.this.descriptor.getCleaner().removeCleaner(this);
        }

        public void toolWindowTabAdded(ToolWindowTabEvent event) {
            if (ToolWindowTabPanelUI.this.tabContainer.getComponentCount() == 0) {
                ToolWindowTabPanelUI.this.initTabs();
            } else {
                ToolWindowTabPanelUI.this.addTab((MyDoggyToolWindowTab)event.getToolWindowTab());
            }
            ToolWindowTabPanelUI.this.checkPopupButton();
        }

        public boolean toolWindowTabRemoving(ToolWindowTabEvent event) {
            return true;
        }

        public void toolWindowTabRemoved(ToolWindowTabEvent event) {
            ToolWindowTab toolWindowTab = event.getToolWindowTab();
            boolean isSelected = toolWindowTab.isSelected();
            ToolWindowTab nextTab = isSelected ? ToolWindowTabPanelUI.this.getNextTab(toolWindowTab) : null;
            ToolWindowTabPanelUI.this.removeTab(event.getToolWindowTab(), true);
            if (isSelected) {
                if (nextTab != null) {
                    nextTab.setSelected(true);
                } else {
                    ToolWindowTabPanelUI.this.selectedTab = null;
                    ToolWindowTabPanelUI.this.selecTabButton = null;
                }
            }
            ToolWindowTabPanelUI.this.checkPopupButton();
        }
    }
}

