/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.client.signaldisplay.signalelement;

import java.awt.Color;
import javax.swing.UIManager;
import nl.lxtreme.ols.api.data.Channel;
import nl.lxtreme.ols.client.signaldisplay.model.SignalDiagramModel;
import nl.lxtreme.ols.client.signaldisplay.signalelement.ElementGroup;

public final class SignalElement
implements Comparable<SignalElement> {
    private final SignalElementType type;
    private final int mask;
    private Channel channel;
    private ElementGroup group;
    private int height;
    private int yPosition;
    private int signalHeight;
    private SignalDiagramModel.SignalAlignment alignment;

    private SignalElement(SignalElementType aType, int aMask) {
        this.type = aType;
        this.mask = aMask;
    }

    public static SignalElement createAnalogScopeElement(ElementGroup aGroup) {
        SignalElement channelElement = new SignalElement(SignalElementType.ANALOG_SIGNAL, -1);
        channelElement.group = aGroup;
        channelElement.height = UIManager.getInt("ols.analogscope.height");
        return channelElement;
    }

    public static SignalElement createDigitalSignalElement(Channel aChannel, ElementGroup aGroup) {
        SignalElement channelElement = new SignalElement(SignalElementType.DIGITAL_SIGNAL, aChannel.getMask());
        channelElement.channel = aChannel;
        channelElement.group = aGroup;
        channelElement.height = UIManager.getInt("ols.channel.height");
        channelElement.signalHeight = UIManager.getInt("ols.digitalsignal.height");
        channelElement.alignment = SignalDiagramModel.SignalAlignment.valueOf(SignalElement.getUIManagerValue("ols.signal.alignment.enum", "CENTER"));
        return channelElement;
    }

    public static SignalElement createGroupSummaryElement(ElementGroup aGroup) {
        SignalElement channelElement = new SignalElement(SignalElementType.GROUP_SUMMARY, -1);
        channelElement.group = aGroup;
        channelElement.height = UIManager.getInt("ols.groupsummary.height");
        return channelElement;
    }

    public static SignalElement createSignalGroupElement(ElementGroup aGroup) {
        SignalElement channelElement = new SignalElement(SignalElementType.SIGNAL_GROUP, -1);
        channelElement.group = aGroup;
        channelElement.height = UIManager.getInt("ols.signalgroup.height");
        return channelElement;
    }

    private static <TYPE> TYPE getUIManagerValue(String aKey, TYPE aDefault) {
        Object value = UIManager.get(aKey);
        if (value == null || !aDefault.getClass().isAssignableFrom(value.getClass())) {
            return aDefault;
        }
        return (TYPE)value;
    }

    @Override
    public int compareTo(SignalElement aSignalElement) {
        int thisIdx = this.getVirtualIndex();
        int thatIdx = aSignalElement.getVirtualIndex();
        return thisIdx - thatIdx;
    }

    public boolean equals(Object aObject) {
        if (this == aObject) {
            return true;
        }
        if (aObject == null || !(aObject instanceof SignalElement)) {
            return false;
        }
        SignalElement other = (SignalElement)aObject;
        if (this.type != other.type) {
            return false;
        }
        if (this.channel != other.channel) {
            return false;
        }
        return this.group == other.group;
    }

    public Channel getChannel() {
        if (this.channel == null) {
            throw new IllegalStateException("Can only be called for a digital signal!");
        }
        return this.channel;
    }

    public Color getColor() {
        Color result = null;
        if (this.group != null) {
            if (this.isDigitalSignal()) {
                String key = this.getColorKey();
                result = UIManager.getColor(key);
            }
            if (result == null) {
                result = this.group.getColor();
            }
        }
        if (result == null) {
            result = Color.WHITE;
        }
        return result;
    }

    public ElementGroup getGroup() {
        return this.group;
    }

    public int getHeight() {
        return this.height;
    }

    public String getLabel() {
        if (this.channel != null) {
            return this.channel.getLabel();
        }
        if (this.group != null) {
            if (this.isAnalogSignal()) {
                return this.group.getAnalogSignalLabel();
            }
            if (this.isGroupSummary()) {
                return this.group.getGroupSummaryLabel();
            }
            return this.group.getName();
        }
        return this.getDefaultName();
    }

    public int getMask() {
        if (!this.isDigitalSignal()) {
            return this.group.getMask();
        }
        return this.mask;
    }

    public int getOffset() {
        return this.getOffset(this.alignment);
    }

    public int getOffset(SignalDiagramModel.SignalAlignment aAlignment) {
        assert (this.isDigitalSignal()) : "Can only be called for digital signals!";
        int signalOffset = SignalDiagramModel.SignalAlignment.BOTTOM.equals((Object)aAlignment) ? this.height - this.signalHeight : (SignalDiagramModel.SignalAlignment.CENTER.equals((Object)aAlignment) ? (int)((double)(this.height - this.signalHeight) / 2.0) : 0);
        return signalOffset;
    }

    public SignalDiagramModel.SignalAlignment getSignalAlignment() {
        return this.alignment;
    }

    public int getSignalHeight() {
        return this.signalHeight;
    }

    public SignalElementType getType() {
        return this.type;
    }

    public int getVirtualIndex() {
        int result = -1;
        if (this.group != null) {
            result = this.group.getVirtualIndex(this);
        }
        return result;
    }

    public int getYposition() {
        return this.yPosition;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.group.hashCode();
        result = 31 * result + this.type.hashCode();
        return result;
    }

    public boolean isAnalogSignal() {
        return this.type == SignalElementType.ANALOG_SIGNAL;
    }

    public boolean isDigitalSignal() {
        return this.type == SignalElementType.DIGITAL_SIGNAL;
    }

    public boolean isEnabled() {
        if (this.channel != null) {
            return this.channel.isEnabled();
        }
        if (this.group != null) {
            if (this.isGroupSummary()) {
                return this.group.isShowGroupSummary();
            }
            if (this.isAnalogSignal()) {
                return this.group.isShowAnalogSignal();
            }
            if (this.isSignalGroup()) {
                return this.group.isShowDigitalSignals();
            }
            throw new InternalError("Unknown signal element?! Type = " + (Object)((Object)this.type));
        }
        return false;
    }

    public boolean isGroupSummary() {
        return this.type == SignalElementType.GROUP_SUMMARY;
    }

    public boolean isSignalGroup() {
        return this.type == SignalElementType.SIGNAL_GROUP;
    }

    public void setColor(Color aColor) {
        if (aColor == null) {
            throw new IllegalArgumentException("Color cannot be null!");
        }
        UIManager.put(this.getColorKey(), aColor);
    }

    public void setEnabled(boolean aEnabled) {
        if (this.channel != null) {
            this.channel.setEnabled(aEnabled);
        } else if (this.group != null) {
            if (this.isGroupSummary()) {
                this.group.setShowGroupSummary(aEnabled);
            } else if (this.isAnalogSignal()) {
                this.group.setShowAnalogSignal(aEnabled);
            } else if (this.isSignalGroup()) {
                this.group.setShowDigitalSignals(aEnabled);
            } else {
                throw new InternalError("Unknown signal element?! Type = " + (Object)((Object)this.type));
            }
        }
    }

    public void setHeight(int aHeight) {
        this.height = aHeight;
    }

    public final void setLabel(String aLabel) {
        if (this.channel != null) {
            this.channel.setLabel(aLabel);
        } else if (this.group != null) {
            if (this.isAnalogSignal()) {
                this.group.setAnalogSignalLabel(aLabel);
            } else if (this.isGroupSummary()) {
                this.group.setGroupSummaryLabel(aLabel);
            } else {
                this.group.setName(aLabel);
            }
        }
    }

    public void setSignalAlignment(SignalDiagramModel.SignalAlignment aAlignment) {
        if (!this.isDigitalSignal()) {
            throw new IllegalArgumentException("Can only be called for digital signals!");
        }
        this.alignment = aAlignment;
    }

    public void setSignalHeight(int aSignalHeight) {
        if (!this.isDigitalSignal()) {
            throw new IllegalArgumentException("Can only be called for digital signals!");
        }
        this.signalHeight = aSignalHeight;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("SignalElement [type=");
        builder.append((Object)this.type);
        if (this.channel != null) {
            builder.append(", channel=");
            builder.append(this.channel);
        }
        if (this.group != null) {
            builder.append(", channelGroup=");
            builder.append(this.group);
        }
        builder.append("]");
        return builder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void setGroup(ElementGroup aGroup) {
        SignalElement signalElement = this;
        synchronized (signalElement) {
            this.group = aGroup;
        }
    }

    final void setYposition(int aYPosition) {
        this.yPosition = aYPosition;
    }

    private String getColorKey() {
        Integer groupIdx = this.group.getIndex() % 4 + 1;
        Integer channelIdx = this.channel.getIndex() % 8 + 1;
        return String.format("ols.channelgroup%d.channel%d.default.color", groupIdx, channelIdx);
    }

    private String getDefaultName() {
        int index = this.channel != null ? this.channel.getIndex() : this.group.getIndex();
        return String.format("%s-%d", this.group.getName(), index + 1);
    }

    public static enum SignalElementType {
        SIGNAL_GROUP,
        DIGITAL_SIGNAL,
        GROUP_SUMMARY,
        ANALOG_SIGNAL;

    }
}

