/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.client.signaldisplay.model;

import java.awt.Color;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.UIManager;
import nl.lxtreme.ols.client.signaldisplay.SignalDiagramController;
import nl.lxtreme.ols.client.signaldisplay.model.AbstractViewModel;
import nl.lxtreme.ols.client.signaldisplay.model.SignalDiagramModel;

public class SignalViewModel
extends AbstractViewModel {
    public SignalViewModel(SignalDiagramController aController) {
        super(aController);
    }

    public SignalDiagramModel.SignalAlignment getAnnotationAlignment() {
        String alignment = UIManager.getString("ols.signal.annotation.alignment.enum");
        if (alignment == null) {
            alignment = "CENTER";
        }
        return SignalDiagramModel.SignalAlignment.valueOf(alignment);
    }

    public float getAnnotationAlpha() {
        int value = UIManager.getInt("ols.signal.annotation.alpha.value");
        return (float)value / 100.0f;
    }

    public Color getAnnotationColor() {
        Color color = UIManager.getColor("ols.signal.annotation.color");
        if (color == null) {
            color = Color.WHITE;
        }
        return color;
    }

    public Font getAnnotationFont() {
        Font font = UIManager.getFont("ols.signal.annotation.font");
        if (font == null) {
            font = UIManager.getFont("Label.font");
        }
        return font;
    }

    public Color getBackgroundColor() {
        Color color = UIManager.getColor("ols.signal.background.color");
        if (color == null) {
            color = Color.BLACK;
        }
        return color;
    }

    public Font getCursorFlagFont() {
        Font font = UIManager.getFont("ols.timeline.cursor.font");
        if (font == null) {
            font = UIManager.getFont("Label.font");
        }
        return font;
    }

    public int[] getDataValues() {
        return this.controller.getSignalDiagramModel().getValues();
    }

    public int getEndIndex(Rectangle aClip, int aLength) {
        Point location = new Point(aClip.x + aClip.width, 0);
        int index = this.locationToSampleIndex(location);
        return Math.min(index + 1, aLength - 1);
    }

    public Color getGroupSummaryBarColor() {
        Color font = UIManager.getColor("ols.signal.groupsummary.bar.color");
        if (font == null) {
            font = Color.WHITE;
        }
        return font;
    }

    public int getGroupSummaryPadding() {
        return UIManager.getInt("ols.signal.groupsummary.padding");
    }

    public Font getGroupSummaryTextFont() {
        Font font = UIManager.getFont("ols.signal.groupsummary.text.font");
        if (font == null) {
            font = UIManager.getFont("Label.font");
        }
        return font;
    }

    public Color getMeasurementArrowColor() {
        Color color = UIManager.getColor("ols.signal.arrow.color");
        if (color == null) {
            color = Color.WHITE;
        }
        return color;
    }

    public int getStartIndex(Rectangle aClip) {
        Point location = aClip.getLocation();
        int index = this.locationToSampleIndex(location);
        return Math.max(index - 1, 0);
    }

    public long[] getTimestamps() {
        return this.controller.getSignalDiagramModel().getTimestamps();
    }

    public boolean isRenderAnnotationAlternatively() {
        return UIManager.getBoolean("ols.signal.annotation.altstyle.boolean");
    }

    public boolean isRenderAnnotationAntiAliased() {
        return UIManager.getBoolean("ols.signal.annotation.render.aa.boolean");
    }

    public boolean isRenderGroupSummaryAntiAliased() {
        return UIManager.getBoolean("ols.signal.groupsummary.render.aa.boolean");
    }

    public boolean isRenderScopeSignalAntiAliased() {
        return UIManager.getBoolean("ols.signal.analogscope.render.aa.boolean");
    }

    public boolean isSloppyScopeRenderingAllowed() {
        return !UIManager.getBoolean("ols.disble.sloppy.scope.painting.boolean");
    }
}

