/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.client.signaldisplay.dnd;

import java.awt.datatransfer.DataFlavor;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDropEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import nl.lxtreme.ols.client.signaldisplay.SignalDiagramController;

public final class DragAndDropTargetController
extends DropTargetAdapter {
    private final SignalDiagramController ctlr;
    private final List<DragAndDropHandler> handlers;

    public DragAndDropTargetController(SignalDiagramController aController) {
        this.ctlr = aController;
        this.handlers = new CopyOnWriteArrayList<DragAndDropHandler>();
    }

    public void addHandler(DragAndDropHandler aHandler) {
        this.handlers.add(aHandler);
    }

    @Override
    public void drop(DropTargetDropEvent aEvent) {
        DataFlavor[] flavors = aEvent.getCurrentDataFlavors();
        boolean result = false;
        if (flavors != null && flavors.length > 0) {
            for (int i = flavors.length - 1; !result && i >= 0; --i) {
                DragAndDropHandler handler = this.getHandler(flavors[i]);
                if (handler == null || (aEvent.getSourceActions() & handler.getDropAction()) == 0 || !(result = handler.acceptDrop(this.ctlr, aEvent))) continue;
                aEvent.acceptDrop(handler.getDropAction());
            }
        }
        if (!result) {
            aEvent.rejectDrop();
        }
        aEvent.dropComplete(result);
    }

    public void removeHandler(DragAndDropHandler aHandler) {
        this.handlers.remove(aHandler);
    }

    private DragAndDropHandler getHandler(DataFlavor aFlavor) {
        ArrayList<DragAndDropHandler> handlersCopy = new ArrayList<DragAndDropHandler>(this.handlers);
        for (DragAndDropHandler handler : handlersCopy) {
            if (!aFlavor.equals(handler.getFlavor())) continue;
            return handler;
        }
        return null;
    }

    public static interface DragAndDropHandler {
        public boolean acceptDrop(SignalDiagramController var1, DropTargetDropEvent var2);

        public int getDropAction();

        public DataFlavor getFlavor();
    }
}

