/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.client.signaldisplay.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.text.DecimalFormat;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SpringLayout;
import nl.lxtreme.ols.api.acquisition.AcquisitionResult;
import nl.lxtreme.ols.api.data.DataSet;
import nl.lxtreme.ols.client.signaldisplay.IDataModelChangeListener;
import nl.lxtreme.ols.client.signaldisplay.IToolWindow;
import nl.lxtreme.ols.client.signaldisplay.SignalDiagramController;
import nl.lxtreme.ols.client.signaldisplay.ZoomController;
import nl.lxtreme.ols.client.signaldisplay.model.SignalDiagramModel;
import nl.lxtreme.ols.client.signaldisplay.view.AbstractViewLayer;
import nl.lxtreme.ols.client.signaldisplay.view.ViewUtils;
import nl.lxtreme.ols.util.swing.SpringLayoutUtils;
import nl.lxtreme.ols.util.swing.SwingComponentUtils;

public class AcquisitionDetailsView
extends AbstractViewLayer
implements IToolWindow,
IDataModelChangeListener,
ZoomController.ZoomListener {
    public static final String ID = "Acquisition";
    private static final long serialVersionUID = 1L;
    private final JLabel sampleRate = new JLabel("-");
    private final JLabel sampleCount = new JLabel("-");
    private final JLabel totalWidth = new JLabel("-");
    private final JLabel displayedTimeLabel = new JLabel("");
    private final JLabel displayedTime;
    private final JLabel secondsPerPixel;
    private final JLabel unitOfTime;

    private AcquisitionDetailsView(SignalDiagramController aController) {
        super(aController);
        this.displayedTimeLabel.setHorizontalAlignment(4);
        this.displayedTime = new JLabel("-");
        this.secondsPerPixel = new JLabel("-");
        this.unitOfTime = new JLabel("-");
    }

    public static AcquisitionDetailsView create(SignalDiagramController aController) {
        AcquisitionDetailsView result = new AcquisitionDetailsView(aController);
        result.initComponent();
        aController.addDataModelChangeListener(result);
        aController.getZoomController().addZoomListener(result);
        return result;
    }

    @Override
    public void dataModelChanged(DataSet aDataSet) {
        String scText;
        String twText;
        String srText;
        if (aDataSet != null && aDataSet.getCapturedData() != null) {
            AcquisitionResult model = aDataSet.getCapturedData();
            if (model.hasTimingData()) {
                double sr = model.getSampleRate();
                double tw = (double)model.getAbsoluteLength() / sr;
                srText = ViewUtils.formatFrequency(sr);
                twText = ViewUtils.formatTime(tw);
            } else {
                srText = "n/a";
                twText = "n/a";
            }
            scText = new DecimalFormat().format(model.getValues().length);
        } else {
            srText = "-";
            scText = "-";
            twText = "-";
        }
        SwingComponentUtils.invokeOnEDT((Runnable)new Runnable(){

            @Override
            public void run() {
                AcquisitionDetailsView.this.sampleRate.setText(srText);
                AcquisitionDetailsView.this.sampleCount.setText(scText);
                AcquisitionDetailsView.this.totalWidth.setText(twText);
                AcquisitionDetailsView.this.repaint(25L);
            }
        });
    }

    @Override
    public Icon getIcon() {
        return null;
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public void notifyZoomChange(ZoomController.ZoomEvent aEvent) {
        SignalDiagramModel model = this.getController().getSignalDiagramModel();
        Double dt = model.getDisplayedTimeInterval();
        final String dtTextLabel = model.hasTimingData() ? "Displayed time:" : "Displayed states:";
        final String dtText = dt != null ? ViewUtils.formatReference(model.hasTimingData(), model.getDisplayedTimeInterval()) : "-";
        Double spp = model.getTimelineSecondsPerPixel();
        final String sppText = spp != null ? ViewUtils.formatTime(spp) : "-";
        Double uot = model.getTimelineUnitOfTime();
        final String uotText = uot != null ? ViewUtils.formatTime(uot) : "-";
        SwingComponentUtils.invokeOnEDT((Runnable)new Runnable(){

            @Override
            public void run() {
                AcquisitionDetailsView.this.displayedTimeLabel.setText(dtTextLabel);
                AcquisitionDetailsView.this.displayedTime.setText(dtText);
                AcquisitionDetailsView.this.secondsPerPixel.setText(sppText);
                AcquisitionDetailsView.this.unitOfTime.setText(uotText);
                AcquisitionDetailsView.this.repaint(25L);
            }
        });
    }

    private void initComponent() {
        this.setOpaque(false);
        this.setLayout(new BorderLayout());
        this.setName("Acquisition details");
        JPanel panel = new JPanel(new SpringLayout());
        SpringLayoutUtils.addSeparator((Container)panel, (String)"Acquisition details");
        panel.add(SwingComponentUtils.createRightAlignedLabel((String)"Sample count:"));
        panel.add(this.sampleCount);
        panel.add(SwingComponentUtils.createRightAlignedLabel((String)"Sample rate:"));
        panel.add(this.sampleRate);
        panel.add(SwingComponentUtils.createRightAlignedLabel((String)"Sample time:"));
        panel.add(this.totalWidth);
        panel.add(this.displayedTimeLabel);
        panel.add(this.displayedTime);
        panel.add(SwingComponentUtils.createRightAlignedLabel((String)"Time/pixel:"));
        panel.add(this.secondsPerPixel);
        panel.add(SwingComponentUtils.createRightAlignedLabel((String)"Unit of time:"));
        panel.add(this.unitOfTime);
        SpringLayoutUtils.makeEditorGrid((Container)panel, (int)10, (int)10);
        this.add((Component)panel, "North");
    }
}

