/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.client.signaldisplay;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.EventListener;
import javax.swing.event.EventListenerList;
import nl.lxtreme.ols.client.signaldisplay.SignalDiagramComponent;
import nl.lxtreme.ols.client.signaldisplay.SignalDiagramController;
import nl.lxtreme.ols.client.signaldisplay.model.SignalDiagramModel;

public final class ZoomController {
    private static final double DEFAULT_ZOOM_FACTOR = 1.0;
    private static final double DEFAULT_ZOOM_RATIO = 2.0;
    private final SignalDiagramController controller;
    private final EventListenerList eventListeners;
    private final Object LOCK = new Object();
    private volatile ZoomValue value = ZoomValue.DEFAULT;
    private volatile double factor = 1.0;

    public ZoomController(SignalDiagramController aController) {
        this.controller = aController;
        this.eventListeners = new EventListenerList();
    }

    public void addZoomListener(ZoomListener aListener) {
        this.eventListeners.add(ZoomListener.class, aListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getFactor() {
        double result;
        Object object = this.LOCK;
        synchronized (object) {
            result = Double.isNaN(this.factor) ? 1.0 : this.factor;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isZoomAll() {
        Object object = this.LOCK;
        synchronized (object) {
            return this.value == ZoomValue.ALL;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isZoomDefault() {
        Object object = this.LOCK;
        synchronized (object) {
            return this.value == ZoomValue.DEFAULT;
        }
    }

    public void removeZoomListener(ZoomListener aListener) {
        this.eventListeners.remove(ZoomListener.class, aListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restoreZoomLevel() {
        double _factor;
        ZoomValue _value;
        Object object = this.LOCK;
        synchronized (object) {
            _value = this.value;
            _factor = this.factor;
        }
        this.zoom(_value, _factor, null);
    }

    public void zoomAll() {
        this.zoom(ZoomValue.ALL, this.getMinZoomLevel(), null);
    }

    public void zoomDefault() {
        this.zoom(ZoomValue.DEFAULT, this.getDefaultZoomLevel(), null);
    }

    public void zoomIn(Point aCenterPoint) {
        this.zoom(ZoomValue.IN, 2.0, aCenterPoint);
    }

    public void zoomMaximum() {
        this.zoom(ZoomValue.ALL, this.getMaxZoomLevel(), null);
    }

    public void zoomOut(Point aCenterPoint) {
        this.zoom(ZoomValue.OUT, 0.5, aCenterPoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean zoomRegion(Point aPoint1, Point aPoint2) {
        ZoomEvent event;
        if (aPoint1.distance(aPoint2) < 10.0) {
            return false;
        }
        SignalDiagramModel model = this.controller.getSignalDiagramModel();
        Rectangle viewSize = this.getSignalDiagram().getVisibleViewSize();
        int width = Math.abs(aPoint2.x - aPoint1.x);
        Long triggerPos = model.getTriggerPosition();
        Object object = this.LOCK;
        synchronized (object) {
            double oldFactor = this.getFactor();
            int midX = (int)((double)aPoint1.x + (double)width / 2.0);
            long ts = (long)Math.ceil((double)midX / oldFactor);
            if (triggerPos != null) {
                ts -= triggerPos.longValue();
            }
            Point hs = new Point((int)((double)ts * oldFactor), 0);
            double newFactor = (double)viewSize.width / (double)width;
            event = this.createZoomEvent(oldFactor, newFactor, hs);
        }
        this.fireZoomEvent(event);
        return true;
    }

    private ZoomEvent createZoomEvent(double aOldFactor, double aNewFactor, Point aHotSpot) {
        return new ZoomEvent(aNewFactor, aOldFactor, this.getMinZoomLevel(), this.getDefaultZoomLevel(), this.getMaxZoomLevel(), aHotSpot);
    }

    private void fireZoomEvent(ZoomEvent aEvent) {
        ZoomListener[] listeners;
        for (ZoomListener listener : listeners = (ZoomListener[])this.eventListeners.getListeners(ZoomListener.class)) {
            listener.notifyZoomChange(aEvent);
        }
    }

    private double getDefaultZoomLevel() {
        double minLevel = this.getMinZoomLevel();
        if (minLevel > 1.0) {
            return minLevel;
        }
        return 1.0;
    }

    private double getMaxZoomLevel() {
        SignalDiagramModel model = this.getModel();
        if (!model.hasData()) {
            return 1.0;
        }
        double length = model.getAbsoluteLength();
        return Math.floor(2.147483647E9 / length);
    }

    private double getMinZoomLevel() {
        SignalDiagramModel model = this.getModel();
        if (!model.hasData()) {
            return 1.0;
        }
        double width = this.getVisibleViewSize().getWidth();
        double length = model.getAbsoluteLength();
        return width / length;
    }

    private SignalDiagramModel getModel() {
        return this.controller.getSignalDiagramModel();
    }

    private SignalDiagramComponent getSignalDiagram() {
        return this.controller.getSignalDiagram();
    }

    private Rectangle getVisibleViewSize() {
        return this.getSignalDiagram().getVisibleViewSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zoom(ZoomValue aZoomValue, double aFactor, Point aHotSpot) {
        ZoomEvent event;
        double oldFactor = this.getFactor();
        double newFactor = aFactor;
        ZoomValue newValue = aZoomValue;
        Rectangle visibleViewSize = this.getVisibleViewSize();
        SignalDiagramModel model = this.getModel();
        double currentViewWidth = visibleViewSize.getWidth();
        double absLength = model.getAbsoluteLength();
        double oldViewWidth = Math.round(absLength * oldFactor);
        if (aZoomValue == ZoomValue.IN || aZoomValue == ZoomValue.OUT) {
            newFactor = aFactor * oldFactor;
            newValue = null;
        } else if (aZoomValue == ZoomValue.ALL) {
            newFactor = currentViewWidth / absLength;
        }
        if (oldViewWidth < currentViewWidth) {
            newFactor = currentViewWidth / absLength;
        }
        double defaultZoomLevel = this.getDefaultZoomLevel();
        double minZoomLevel = this.getMinZoomLevel();
        double maxZoomLevel = this.getMaxZoomLevel();
        if (Math.abs(newFactor - defaultZoomLevel) < 1.0E-6) {
            newFactor = defaultZoomLevel;
            newValue = ZoomValue.DEFAULT;
        }
        if ((double)Double.compare(newFactor, minZoomLevel) <= 0.0) {
            newFactor = minZoomLevel;
            newValue = ZoomValue.ALL;
        } else if ((double)Double.compare(newFactor, maxZoomLevel) >= 0.0) {
            newFactor = maxZoomLevel;
            newValue = ZoomValue.MAXIMUM;
        }
        if (aZoomValue == ZoomValue.IN || aZoomValue == ZoomValue.OUT) {
            SignalDiagramComponent signalDiagram = this.getSignalDiagram();
            double mx = signalDiagram.getVisibleRect().getCenterX();
            double my = 0.0;
            if (aHotSpot != null) {
                mx = aHotSpot.x;
            }
            long timestamp = (long)(mx / oldFactor);
            int tsIdx = model.getTimestampIndex(timestamp);
            mx = Math.floor((double)model.getTimestamps()[tsIdx] * oldFactor);
            Point location = signalDiagram.getLocation();
            int newX = (int)(location.getX() - (mx * aFactor - mx));
            int newY = (int)(location.getY() - (my * aFactor - my));
            signalDiagram.setLocation(newX, newY);
        }
        Object object = this.LOCK;
        synchronized (object) {
            this.factor = newFactor;
            this.value = newValue;
            event = new ZoomEvent(newFactor, oldFactor, minZoomLevel, defaultZoomLevel, maxZoomLevel, aHotSpot);
        }
        this.fireZoomEvent(event);
    }

    public static enum ZoomValue {
        IN,
        OUT,
        DEFAULT,
        ALL,
        MAXIMUM;

    }

    public static interface ZoomListener
    extends EventListener {
        public void notifyZoomChange(ZoomEvent var1);
    }

    public static final class ZoomEvent {
        private final double minZoomLevel;
        private final double defaultZoomLevel;
        private final double maxZoomLevel;
        private final double newFactor;
        private final double oldFactor;
        private final Point hotSpot;

        public ZoomEvent(double aNewFactor, double aOldFactor, double aMinZoomLevel, double aDefaultLevel, double aMaxZoomLevel, Point aHotSpot) {
            this.newFactor = aNewFactor;
            this.oldFactor = aOldFactor;
            this.minZoomLevel = aMinZoomLevel;
            this.defaultZoomLevel = aDefaultLevel;
            this.maxZoomLevel = aMaxZoomLevel;
            this.hotSpot = aHotSpot == null ? null : new Point(aHotSpot);
        }

        public boolean canZoomIn() {
            double maxZoomLevel = this.getMaxZoomLevel();
            return this.getFactor() < maxZoomLevel;
        }

        public boolean canZoomOut() {
            double minZoomLevel = this.getMinZoomLevel();
            return this.getFactor() > minZoomLevel;
        }

        public double getFactor() {
            return this.newFactor;
        }

        public Point getHotSpot() {
            return this.hotSpot;
        }

        public double getMaxZoomLevel() {
            return this.maxZoomLevel;
        }

        public double getMinZoomLevel() {
            return this.minZoomLevel;
        }

        public double getOldFactor() {
            return this.oldFactor;
        }

        public boolean isZoomAll() {
            return Math.abs(this.newFactor - this.minZoomLevel) < 1.0E-6;
        }

        public boolean isZoomMaximum() {
            return Math.abs(this.newFactor - this.maxZoomLevel) < 1.0E-6;
        }

        public boolean isZoomOriginal() {
            return Math.abs(this.newFactor - this.defaultZoomLevel) < 1.0E-6;
        }
    }
}

