/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.client.actionmanager;

import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import nl.lxtreme.ols.client.actionmanager.IActionManager;
import nl.lxtreme.ols.client.actionmanager.IManagedAction;

public final class ActionManager
implements IActionManager {
    private final ConcurrentMap<String, IManagedAction> registry = new ConcurrentHashMap<String, IManagedAction>();

    @Override
    public IManagedAction add(IManagedAction aAction) throws IllegalArgumentException {
        if (aAction == null) {
            throw new IllegalArgumentException("Action cannot be null!");
        }
        String id = aAction.getId();
        if (id == null || id.trim().isEmpty()) {
            throw new IllegalArgumentException("Action " + aAction.getClass().getName() + " has no valid ID?!");
        }
        if (this.registry.containsKey(id)) {
            throw new IllegalArgumentException("Action " + id + " already registered?!");
        }
        this.registry.put(id, aAction);
        return aAction;
    }

    @Override
    public IManagedAction getAction(String aId) throws IllegalArgumentException {
        if (aId == null || aId.trim().isEmpty()) {
            throw new IllegalArgumentException("Managed action ID cannot be null or empty!");
        }
        IManagedAction result = (IManagedAction)this.registry.get(aId);
        if (result == null) {
            throw new IllegalArgumentException("No such managed action: " + aId);
        }
        return result;
    }

    @Override
    public IManagedAction[] getActionByType(Class<? extends IManagedAction> aActionType) {
        ArrayList<IManagedAction> actions = new ArrayList<IManagedAction>();
        for (IManagedAction action : this.registry.values()) {
            if (!aActionType.isAssignableFrom(action.getClass())) continue;
            actions.add(action);
        }
        return actions.toArray(new IManagedAction[actions.size()]);
    }

    @Override
    public void remove(IManagedAction aAction) throws IllegalArgumentException {
        if (aAction == null) {
            throw new IllegalArgumentException("Action cannot be null!");
        }
        String id = aAction.getId();
        if (!this.registry.containsKey(id)) {
            throw new IllegalArgumentException("Action " + id + " is not registered?!");
        }
        this.registry.remove(id);
    }
}

