/*
 * Decompiled with CFR 0.152.
 */
package org.noos.xing.mydoggy.plaf;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.EventListenerList;
import org.noos.xing.mydoggy.AggregationPosition;
import org.noos.xing.mydoggy.Dockable;
import org.noos.xing.mydoggy.DockableManagerListener;
import org.noos.xing.mydoggy.DockedTypeDescriptor;
import org.noos.xing.mydoggy.FloatingLiveTypeDescriptor;
import org.noos.xing.mydoggy.FloatingTypeDescriptor;
import org.noos.xing.mydoggy.RepresentativeAnchorDescriptor;
import org.noos.xing.mydoggy.SlidingTypeDescriptor;
import org.noos.xing.mydoggy.ToolWindow;
import org.noos.xing.mydoggy.ToolWindowAction;
import org.noos.xing.mydoggy.ToolWindowAnchor;
import org.noos.xing.mydoggy.ToolWindowListener;
import org.noos.xing.mydoggy.ToolWindowManager;
import org.noos.xing.mydoggy.ToolWindowTab;
import org.noos.xing.mydoggy.ToolWindowType;
import org.noos.xing.mydoggy.ToolWindowTypeDescriptor;
import org.noos.xing.mydoggy.event.ToolWindowTabEvent;
import org.noos.xing.mydoggy.plaf.MyDoggyToolWindowManager;
import org.noos.xing.mydoggy.plaf.MyDoggyToolWindowTab;
import org.noos.xing.mydoggy.plaf.PropertyChangeEventSource;
import org.noos.xing.mydoggy.plaf.support.UserPropertyChangeEvent;
import org.noos.xing.mydoggy.plaf.ui.ToolWindowDescriptor;
import org.noos.xing.mydoggy.plaf.ui.util.DockableManager2ToolWindowWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MyDoggyToolWindow
extends PropertyChangeEventSource
implements ToolWindow {
    static final Object LOCK = new ToolWindowLock();
    protected int index;
    protected String id;
    protected ToolWindowAnchor anchor;
    protected ToolWindowType type;
    protected boolean autoHide;
    protected boolean available;
    protected boolean visible;
    protected boolean active;
    protected boolean flash;
    protected boolean maximized;
    protected boolean aggregateEnabled;
    protected boolean lockedOnAnchor;
    protected boolean hideOnZeroTabs;
    protected List<ToolWindowTab> toolWindowTabs;
    protected Map<Object, ToolWindowTab> aliases;
    protected ToolWindowTab rootTab;
    protected ToolWindowDescriptor descriptor;
    protected EventListenerList toolWindowListeners;
    protected int availablePosition;
    protected AggregationPosition lastAggregationPosition;
    protected ToolWindowType lastDetachedType;
    protected PropertyChangeListener pclListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            if ("flash".equals(evt.getPropertyName())) {
                MyDoggyToolWindow.this.firePlafPropertyChangeEvent(evt);
            }
        }
    };

    public MyDoggyToolWindow(MyDoggyToolWindowManager manager, String id, int index, ToolWindowAnchor anchor, ToolWindowType type, String title, Icon icon, Component component) {
        super(manager.getFirePublicEvent());
        this.toolWindowTabs = new ArrayList<ToolWindowTab>();
        this.id = id;
        this.index = index;
        this.anchor = anchor;
        this.type = type;
        this.aggregateEnabled = false;
        this.maximized = false;
        this.visible = false;
        this.active = false;
        this.available = false;
        this.hideOnZeroTabs = true;
        this.descriptor = (ToolWindowDescriptor)manager.createDescriptor(this);
        this.rootTab = this.addTabInternal(title, null, component, null, true);
        this.rootTab.setIcon(icon);
        this.setTitle(title);
        this.setIcon(icon);
    }

    public ToolWindowTab[] getDockables() {
        return this.getToolWindowTabs();
    }

    @Override
    public ToolWindowTab getDockableById(String id) {
        throw new RuntimeException("Cannot call this method!!!");
    }

    @Override
    public void addAlias(ToolWindowTab toolWindowTab, Object alias) {
        if (this.aliases == null) {
            this.aliases = new HashMap<Object, ToolWindowTab>();
        }
        this.aliases.put(alias, toolWindowTab);
    }

    @Override
    public Object[] getAliases(ToolWindowTab toolWindowTab) {
        if (this.aliases == null) {
            return new Object[0];
        }
        ArrayList<Object> result = new ArrayList<Object>();
        for (Map.Entry<Object, ToolWindowTab> entry : this.aliases.entrySet()) {
            if (entry.getValue() != toolWindowTab) continue;
            result.add(entry.getKey());
        }
        return result.toArray();
    }

    @Override
    public ToolWindowTab removeAlias(Object alias) {
        return this.aliases.remove(alias);
    }

    @Override
    public void addDockableManagerListener(DockableManagerListener listener) {
        this.addToolWindowListener(new DockableManager2ToolWindowWrapper(listener));
    }

    @Override
    public void removeDockableManagerListener(DockableManagerListener listener) {
        for (ToolWindowListener managerListener : this.getToolWindowListeners()) {
            if (!(managerListener instanceof DockableManager2ToolWindowWrapper) || ((DockableManager2ToolWindowWrapper)managerListener).getListener() != listener) continue;
            this.removeToolWindowListener(managerListener);
        }
    }

    @Override
    public DockableManagerListener[] getDockableManagerListeners() {
        ArrayList<DockableManagerListener> listeners = new ArrayList<DockableManagerListener>();
        for (ToolWindowListener managerListener : this.getToolWindowListeners()) {
            if (!(managerListener instanceof DockableManager2ToolWindowWrapper)) continue;
            listeners.add(((DockableManager2ToolWindowWrapper)managerListener).getListener());
        }
        return listeners.toArray(new DockableManagerListener[listeners.size()]);
    }

    @Override
    public ToolWindowManager getDockableManager() {
        return this.descriptor.getManager();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public Component getComponent() {
        if (this.toolWindowTabs.size() == 0) {
            return null;
        }
        if (this.toolWindowTabs.size() == 1) {
            return this.toolWindowTabs.get(0).getComponent();
        }
        for (ToolWindowTab toolWindowTab : this.toolWindowTabs) {
            if (!toolWindowTab.isSelected()) continue;
            return toolWindowTab.getComponent();
        }
        return this.toolWindowTabs.get(0).getComponent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setIndex(int index) {
        if (index != -1 && index <= 0 && index > 9) {
            throw new IllegalArgumentException("Invalid index. Valid index range is [-1, 1-9]. [tool : " + this.getId() + ", index : " + index + "]");
        }
        Object object = this.getLock();
        synchronized (object) {
            if (index == this.index) {
                return;
            }
            int old = this.index;
            this.index = index;
            this.firePropertyChangeEvent("index", old, index);
        }
    }

    @Override
    public boolean isAvailable() {
        return this.available;
    }

    @Override
    public void setAvailable(boolean available) {
        if (this.available == available) {
            return;
        }
        this.setAvailableInternal(available, false);
        this.descriptor.getRepresentativeAnchorDescriptor().setVisible(available);
    }

    @Override
    public boolean isVisible() {
        if (this.type == ToolWindowType.EXTERN) {
            Dockable delegator = this.descriptor.getManager().getDockableWrapper(this);
            if (delegator == null) {
                return this.visible;
            }
            if (delegator instanceof ToolWindowTab) {
                ToolWindowTab toolWindowTab = (ToolWindowTab)delegator;
                return toolWindowTab.isSelected() && toolWindowTab.getOwner().isVisible();
            }
            return delegator.isSelected();
        }
        return this.visible;
    }

    @Override
    public void aggregate() {
        if (!this.isVisible()) {
            switch (this.anchor) {
                case LEFT: 
                case RIGHT: {
                    this.aggregate(AggregationPosition.BOTTOM);
                    break;
                }
                case TOP: 
                case BOTTOM: {
                    this.aggregate(AggregationPosition.RIGHT);
                }
            }
        }
    }

    @Override
    public void aggregate(AggregationPosition onPosition) {
        this.aggregate(null, onPosition);
    }

    @Override
    public void aggregateByReference(ToolWindow refToolWindow, AggregationPosition onPosition) {
        this.aggregateInternal(null, onPosition, refToolWindow);
    }

    @Override
    public void aggregate(ToolWindow onToolWindow, AggregationPosition onPosition) {
        this.aggregateInternal(onToolWindow, onPosition, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAggregateMode(boolean aggregateEnabled) {
        if (this.aggregateEnabled == aggregateEnabled) {
            return;
        }
        Object object = this.getLock();
        synchronized (object) {
            boolean old = this.aggregateEnabled;
            this.aggregateEnabled = aggregateEnabled;
            this.firePropertyChangeEvent("aggregateEnabled", old, this.aggregateEnabled);
        }
    }

    @Override
    public boolean isAggregateMode() {
        return this.aggregateEnabled;
    }

    @Override
    public boolean isFlashing() {
        return this.flash;
    }

    @Override
    public void setDetached(boolean detached) {
        if (detached) {
            ToolWindowType targetType = null;
            try {
                targetType = ToolWindowType.valueOf(UIManager.getString("toolwindow.detached.type"));
            }
            catch (IllegalArgumentException e) {
                targetType = ToolWindowType.FLOATING;
            }
            if (this.getType() != targetType) {
                this.lastDetachedType = this.getType();
            }
            this.setType(targetType);
        } else {
            this.setType(this.lastDetachedType);
        }
    }

    @Override
    public boolean isDetached() {
        return this.type != ToolWindowType.DOCKED && this.type != ToolWindowType.SLIDING;
    }

    @Override
    public void setSelected(boolean selected) {
        this.setActive(selected);
    }

    @Override
    public boolean isSelected() {
        return this.isActive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFlashing(boolean flash) {
        if (flash && this.isActive()) {
            return;
        }
        if (!this.flash && !flash) {
            for (ToolWindowTab toolWindowTab : this.toolWindowTabs) {
                toolWindowTab.setFlashing(false);
            }
        } else {
            if (this.flash == flash) {
                return;
            }
            Object object = this.getLock();
            synchronized (object) {
                boolean old = this.flash;
                this.flash = flash;
                this.firePropertyChangeEvent("flash", old, flash);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFlashing(int duration) {
        if (this.isVisible() && this.isActive()) {
            return;
        }
        if (this.flash) {
            return;
        }
        Object object = this.getLock();
        synchronized (object) {
            this.flash = true;
            this.firePropertyChangeEvent("flash", false, true, duration);
        }
    }

    @Override
    public void setVisible(boolean visible) {
        this.setVisibleInternal(visible, false, null, null, null);
    }

    @Override
    public boolean isActive() {
        if (this.type == ToolWindowType.EXTERN) {
            Dockable delegator = this.descriptor.getManager().getDockableWrapper(this);
            if (delegator == null) {
                return this.active;
            }
            if (delegator instanceof ToolWindowTab) {
                ToolWindowTab toolWindowTab = (ToolWindowTab)delegator;
                return toolWindowTab.isSelected() && toolWindowTab.getOwner().isActive();
            }
            return delegator.isSelected();
        }
        return this.active;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setActive(boolean active) {
        if (this.active == active && this.publicEvent) {
            return;
        }
        Object object = this.getLock();
        synchronized (object) {
            if (active) {
                this.setFlashing(false);
                this.setAvailable(active);
                this.setVisible(active);
            }
            boolean old = this.active;
            if (!this.publicEvent) {
                old = false;
            }
            this.active = active;
            this.firePropertyChangeEvent("active", old, active);
            this.firePropertyChangeEvent("selected", old, active);
        }
    }

    @Override
    public ToolWindowAnchor getAnchor() {
        return this.anchor;
    }

    @Override
    public int getAnchorIndex() {
        return this.descriptor.getAnchorIndex();
    }

    @Override
    public void setAnchor(ToolWindowAnchor anchor) {
        this.setAnchor(anchor, -2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAnchor(ToolWindowAnchor anchor, int index) {
        Object object = this.getLock();
        synchronized (object) {
            if (this.anchor == anchor && (index == this.getDescriptor().getAnchorIndex() || index == -2)) {
                return;
            }
            if (this.isLockedOnAnchor() && !this.descriptor.getRepresentativeAnchorDescriptor().containsLockingAnchor(anchor)) {
                return;
            }
            if (this.isMaximized()) {
                this.setMaximized(false);
            }
            if (this.isAvailable() && (this.getType() == ToolWindowType.DOCKED || this.getType() == ToolWindowType.SLIDING)) {
                boolean tempVisible = this.isVisible();
                boolean tempActive = this.isActive();
                if (this.anchor == anchor || !this.isAvailable()) {
                    this.anchor = anchor;
                    this.fireAnchorEvent(null, anchor, index);
                } else {
                    ToolWindowAnchor oldAnchor;
                    this.publicEvent = false;
                    try {
                        this.setAvailableInternal(false, true);
                        oldAnchor = this.anchor;
                        this.anchor = anchor;
                        this.availablePosition = index;
                        this.setAvailableInternal(true, true);
                        if (tempActive) {
                            this.setActive(true);
                        } else if (tempVisible) {
                            this.setVisible(true);
                        }
                    }
                    finally {
                        this.publicEvent = true;
                    }
                    this.fireAnchorEvent(oldAnchor, anchor, index);
                }
            } else {
                ToolWindowAnchor oldAnchor = this.anchor;
                this.anchor = anchor;
                if (oldAnchor == anchor) {
                    if (index != -2) {
                        this.fireAnchorEvent(null, anchor, index);
                    }
                } else {
                    this.fireAnchorEvent(oldAnchor, anchor, index);
                }
            }
        }
    }

    @Override
    public boolean isAutoHide() {
        if (this.type == ToolWindowType.EXTERN) {
            return this.getTypeDescriptor(DockedTypeDescriptor.class).isAutoHide();
        }
        return this.getTypeDescriptor(this.type).isAutoHide();
    }

    @Override
    public void setAutoHide(boolean autoHide) {
        if (this.type == ToolWindowType.EXTERN) {
            return;
        }
        boolean old = this.isAutoHide();
        this.getTypeDescriptor(this.type).setAutoHide(autoHide);
        this.firePropertyChangeEvent("autoHide", old, autoHide);
    }

    @Override
    public void setLockedOnAnchor(boolean lockedOnAnchor) {
        if (this.lockedOnAnchor == lockedOnAnchor) {
            return;
        }
        boolean old = this.lockedOnAnchor;
        this.lockedOnAnchor = lockedOnAnchor;
        this.firePropertyChangeEvent("lockedOnAnchor", old, lockedOnAnchor);
    }

    @Override
    public boolean isLockedOnAnchor() {
        return this.lockedOnAnchor;
    }

    @Override
    public ToolWindowType getType() {
        return this.type;
    }

    @Override
    public void setType(ToolWindowType type) {
        if (type == ToolWindowType.EXTERN) {
            throw new IllegalArgumentException("Invalid type. [type :" + (Object)((Object)type) + "]");
        }
        if (this.type == ToolWindowType.EXTERN) {
            this.descriptor.getManager().removeIfDockableDelegator(this);
        }
        boolean forceAvailable = false;
        if (this.type == ToolWindowType.EXTERN && type != ToolWindowType.FLOATING_FREE) {
            forceAvailable = true;
        }
        this.setTypeInternal(type);
        if (forceAvailable) {
            this.available = false;
            this.setAvailable(true);
        }
    }

    @Override
    public Icon getIcon() {
        return this.rootTab != null ? this.rootTab.getIcon() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setIcon(Icon icon) {
        if (this.rootTab == null) {
            throw new IllegalArgumentException("Cannot call this method. There is no tab.");
        }
        Object object = this.getLock();
        synchronized (object) {
            if (this.toolWindowTabs.size() == 0) {
                return;
            }
            if (this.getIcon() == icon) {
                return;
            }
            Icon old = this.getIcon();
            this.rootTab.setIcon(icon);
            this.firePropertyChangeEvent("icon", old, icon);
        }
    }

    @Override
    public String getTitle() {
        return this.rootTab != null ? this.rootTab.getTitle() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTitle(String title) {
        if (this.rootTab == null) {
            throw new IllegalArgumentException("Cannot call this method. There is no tab.");
        }
        Object object = this.getLock();
        synchronized (object) {
            if (this.toolWindowTabs.size() == 0) {
                return;
            }
            if (title != null && title.equals(this.getTitle())) {
                return;
            }
            String old = this.getTitle();
            this.rootTab.setTitle(title);
            this.firePropertyChangeEvent("title", old, title);
        }
    }

    @Override
    public boolean isMaximized() {
        return this.maximized;
    }

    @Override
    public void setMinimized(boolean minimized) {
        this.setVisible(minimized);
    }

    @Override
    public boolean isMinimized() {
        return !this.isVisible();
    }

    @Override
    public void ensureVisible() {
        DockedTypeDescriptor descriptor;
        if (this.isVisible() && (descriptor = this.getTypeDescriptor(DockedTypeDescriptor.class)).getDockLength() < descriptor.getMinimumDockLength()) {
            descriptor.setDockLength(descriptor.getMinimumDockLength());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMaximized(boolean maximized) {
        if (this.maximized == maximized || !this.isVisible()) {
            return;
        }
        Object object = this.getLock();
        synchronized (object) {
            this.firePlafPropertyChangeEvent("maximizedBefore", this.maximized, maximized);
            boolean old = this.maximized;
            this.maximized = maximized;
            this.firePropertyChangeEvent("maximized", old, maximized);
        }
    }

    @Override
    public boolean isHideOnZeroTabs() {
        return this.hideOnZeroTabs;
    }

    @Override
    public void setHideOnZeroTabs(boolean hideOnZeroTabs) {
        if (this.hideOnZeroTabs == hideOnZeroTabs) {
            return;
        }
        boolean old = this.hideOnZeroTabs;
        this.hideOnZeroTabs = hideOnZeroTabs;
        this.firePropertyChangeEvent("hideOnZeroTabs", old, hideOnZeroTabs);
    }

    @Override
    public ToolWindowTab addToolWindowTab(String title, Component component) {
        return this.addTabInternal(title, null, component, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ToolWindowTab addToolWindowTab(Dockable dockable) {
        Object object = this.getLock();
        synchronized (object) {
            ToolWindowTab result;
            if (dockable instanceof ToolWindow) {
                this.descriptor.getManager().removeIfDockableDelegator(dockable);
                ToolWindow delegator = (ToolWindow)dockable;
                for (ToolWindowTab toolWindowTab : this.toolWindowTabs) {
                    if (toolWindowTab.getDockableDelegator() != dockable) continue;
                    return toolWindowTab;
                }
                ((MyDoggyToolWindow)dockable).setTypeInternal(ToolWindowType.EXTERN);
                result = this.addTabInternal(delegator.getTitle(), delegator.getIcon(), delegator.getComponent(), delegator, false);
                for (ToolWindowTab tab : delegator.getToolWindowTabs()) {
                    if (tab.getTitle().equals(delegator.getTitle())) continue;
                    this.addTabInternal(tab);
                }
            } else {
                throw new IllegalArgumentException("Dockable not yet supported,");
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeToolWindowTab(ToolWindowTab toolWindowTab) {
        Dockable dockable;
        if (toolWindowTab == null) {
            throw new IllegalArgumentException("ToolWindowTab cannot be null.");
        }
        if (!(toolWindowTab instanceof MyDoggyToolWindowTab)) {
            throw new IllegalArgumentException("Invalid ToolWindowTab instance.");
        }
        toolWindowTab.setFlashing(false);
        toolWindowTab.setMaximized(false);
        boolean result = this.toolWindowTabs.remove(toolWindowTab);
        if (result) {
            try {
                this.fireToolWindowTabEvent(new ToolWindowTabEvent(this, ToolWindowTabEvent.ActionId.TAB_REMOVED, this, toolWindowTab));
            }
            finally {
                ((MyDoggyToolWindowTab)toolWindowTab).cleanup();
            }
        }
        if (toolWindowTab.getDockableDelegator() != null && (dockable = toolWindowTab.getDockableDelegator()) instanceof ToolWindow) {
            ToolWindow toolWindow = (ToolWindow)dockable;
            toolWindow.setType(ToolWindowType.DOCKED);
            for (ToolWindowTab tab : toolWindow.getToolWindowTabs()) {
                for (ToolWindowTab fromTab : this.getToolWindowTabs()) {
                    if (fromTab.getDockableDelegator() != tab) continue;
                    this.removeToolWindowTab(fromTab);
                }
            }
        }
        if (this.rootTab == toolWindowTab) {
            this.rootTab = this.toolWindowTabs.size() > 0 ? this.toolWindowTabs.get(0) : null;
        }
        if (this.toolWindowTabs.size() == 0 && this.isHideOnZeroTabs()) {
            this.setAvailable(false);
        }
        return result;
    }

    @Override
    public ToolWindowTab[] getToolWindowTabs() {
        return this.toolWindowTabs.toArray(new ToolWindowTab[this.toolWindowTabs.size()]);
    }

    @Override
    public void addToolWindowAction(ToolWindowAction toolWindowAction) {
        this.descriptor.addCommonToolWindowAction(toolWindowAction);
    }

    @Override
    public void removeToolWindowAction(String id) {
        this.descriptor.removeCommonToolWindowAction(id);
    }

    @Override
    public void addToolWindowListener(ToolWindowListener listener) {
        if (this.toolWindowListeners == null) {
            this.toolWindowListeners = new EventListenerList();
        }
        this.toolWindowListeners.add(ToolWindowListener.class, listener);
    }

    @Override
    public void removeToolWindowListener(ToolWindowListener listener) {
        if (this.toolWindowListeners == null) {
            return;
        }
        this.toolWindowListeners.remove(ToolWindowListener.class, listener);
    }

    @Override
    public ToolWindowListener[] getToolWindowListeners() {
        if (this.toolWindowListeners == null) {
            return new ToolWindowListener[0];
        }
        return (ToolWindowListener[])this.toolWindowListeners.getListeners(ToolWindowListener.class);
    }

    @Override
    public ToolWindowTypeDescriptor getTypeDescriptor(ToolWindowType type) {
        return this.descriptor.getTypeDescriptor(type);
    }

    @Override
    public <T extends ToolWindowTypeDescriptor> T getTypeDescriptor(Class<T> descriptorClass) {
        if (descriptorClass.isAssignableFrom(DockedTypeDescriptor.class)) {
            return (T)this.descriptor.getTypeDescriptor(ToolWindowType.DOCKED);
        }
        if (descriptorClass.isAssignableFrom(SlidingTypeDescriptor.class)) {
            return (T)this.descriptor.getTypeDescriptor(ToolWindowType.SLIDING);
        }
        if (descriptorClass.isAssignableFrom(FloatingLiveTypeDescriptor.class)) {
            return (T)this.descriptor.getTypeDescriptor(ToolWindowType.FLOATING_LIVE);
        }
        if (descriptorClass.isAssignableFrom(FloatingTypeDescriptor.class)) {
            return (T)this.descriptor.getTypeDescriptor(ToolWindowType.FLOATING);
        }
        throw new IllegalArgumentException("Cannot recognize the class type. [class : " + descriptorClass + "]");
    }

    public RepresentativeAnchorDescriptor getRepresentativeAnchorDescriptor() {
        return this.descriptor.getRepresentativeAnchorDescriptor();
    }

    public String toString() {
        return "MyDoggyToolWindow{id='" + this.id + '\'' + ", index=" + this.index + ", available=" + this.available + ", visible=" + this.visible + ", active=" + this.active + ", anchor=" + (Object)((Object)this.anchor) + ", type=" + (Object)((Object)this.type) + ", title='" + this.getTitle() + '\'' + ", autoHide=" + this.autoHide + ", flashing=" + this.flash + ", maximized=" + this.maximized + '}';
    }

    @Override
    public void cleanup() {
        super.cleanup();
        for (ToolWindowListener listener : this.getToolWindowListeners()) {
            this.removeToolWindowListener(listener);
        }
    }

    public final Object getLock() {
        return LOCK;
    }

    public ToolWindowDescriptor getDescriptor() {
        return this.descriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void aggregateInternal(ToolWindow onToolWindow, AggregationPosition aggregationPosition, ToolWindow aggregateReferenceTool) {
        try {
            if (onToolWindow != null && (this.descriptor.getManager().getContentManager().isEnabled() && onToolWindow.getAnchor() != this.anchor && onToolWindow.getType() != ToolWindowType.FLOATING_LIVE && onToolWindow.getType() != ToolWindowType.FLOATING && onToolWindow.getType() != ToolWindowType.FLOATING_FREE || !onToolWindow.isVisible())) {
                return;
            }
            if (this.isAutoHide()) {
                this.setAutoHide(false);
            }
            this.descriptor.getManager().setShowingGroup();
            if (!this.isVisible()) {
                if (onToolWindow != null && onToolWindow.getType() == ToolWindowType.FLOATING_LIVE || aggregateReferenceTool != null && aggregateReferenceTool.getType() == ToolWindowType.FLOATING_LIVE) {
                    this.setType(ToolWindowType.FLOATING_LIVE);
                } else if (onToolWindow != null && onToolWindow.getType() == ToolWindowType.FLOATING || aggregateReferenceTool != null && aggregateReferenceTool.getType() == ToolWindowType.FLOATING) {
                    this.setType(ToolWindowType.FLOATING);
                } else if (onToolWindow != null && onToolWindow.getType() == ToolWindowType.FLOATING_FREE || aggregateReferenceTool != null && aggregateReferenceTool.getType() == ToolWindowType.FLOATING_FREE) {
                    this.setType(ToolWindowType.FLOATING);
                } else if (this.getType() != ToolWindowType.DOCKED) {
                    this.setType(ToolWindowType.DOCKED);
                }
                this.setVisibleInternal(true, true, onToolWindow, aggregationPosition, aggregateReferenceTool);
            } else {
                this.publicEvent = false;
                try {
                    this.setVisible(false);
                }
                finally {
                    this.publicEvent = true;
                }
                if (onToolWindow != null && onToolWindow.getType() == ToolWindowType.FLOATING_LIVE || aggregateReferenceTool != null && aggregateReferenceTool.getType() == ToolWindowType.FLOATING_LIVE) {
                    this.setType(ToolWindowType.FLOATING_LIVE);
                } else if (onToolWindow != null && onToolWindow.getType() == ToolWindowType.FLOATING || aggregateReferenceTool != null && aggregateReferenceTool.getType() == ToolWindowType.FLOATING) {
                    this.setType(ToolWindowType.FLOATING);
                } else if (onToolWindow != null && onToolWindow.getType() == ToolWindowType.FLOATING_FREE || aggregateReferenceTool != null && aggregateReferenceTool.getType() == ToolWindowType.FLOATING_FREE) {
                    this.setType(ToolWindowType.FLOATING);
                } else if (this.getType() != ToolWindowType.DOCKED) {
                    this.setType(ToolWindowType.DOCKED);
                }
                this.publicEvent = false;
                try {
                    this.setVisibleInternal(true, true, onToolWindow, aggregationPosition, aggregateReferenceTool);
                }
                finally {
                    this.publicEvent = true;
                }
            }
            this.lastAggregationPosition = aggregationPosition;
        }
        finally {
            this.descriptor.getManager().resetShowingGroup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setAvailableInternal(boolean available, boolean moveAction) {
        if (this.available == available) {
            return;
        }
        if (available && this.toolWindowTabs.size() == 0) {
            throw new IllegalStateException("Cannot make available the tool. No tabs available.");
        }
        Object object = this.getLock();
        synchronized (object) {
            if (!available) {
                if (this.isActive() && this.publicEvent) {
                    this.setActive(false);
                }
                if (this.isVisible()) {
                    this.setVisible(false);
                }
            }
            boolean old = this.available;
            this.available = available;
            this.firePropertyChangeEvent("available", old, available, new Object[]{this.availablePosition, moveAction});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    protected void setVisibleInternal(boolean visible, boolean aggregate, ToolWindow aggregationOnTool, AggregationPosition aggregationPosition, ToolWindow aggregateReferenceTool) {
        if ((this.aggregateEnabled || this.descriptor.getManager().getToolWindowBar(this.anchor).isAggregateMode()) && visible && !aggregate && this.getType() == ToolWindowType.DOCKED) {
            this.aggregate();
        }
        if (this.getType() == ToolWindowType.EXTERN) {
            for (ToolWindow toolWindow : this.descriptor.getManager().getToolWindows()) {
                for (ToolWindowTab tab : toolWindow.getToolWindowTabs()) {
                    if (tab.getDockableDelegator() != this) continue;
                    toolWindow.setVisible(visible);
                    if (visible) {
                        tab.setSelected(true);
                    }
                    return;
                }
            }
            for (Dockable<ToolWindowManager> dockable : this.descriptor.getManager().getContentManager().getContents()) {
                if (dockable.getDockableDelegator() != this) continue;
                dockable.setSelected(true);
                return;
            }
        }
        if (this.visible == visible) {
            return;
        }
        Object object = this.getLock();
        synchronized (object) {
            if (!visible && this.isMaximized()) {
                this.setMaximized(false);
            }
            if (visible) {
                this.setAvailable(visible);
            } else if (this.active && this.publicEvent) {
                this.setActive(false);
            }
            boolean old = this.visible;
            this.visible = visible;
            if (visible) {
                void var9_14;
                ToolWindowTab selectedTab = null;
                Object var9_13 = null;
                for (ToolWindowTab tab : this.getToolWindowTabs()) {
                    if (tab.isSelected()) {
                        selectedTab = tab;
                        continue;
                    }
                    if (var9_14 != null) continue;
                    ToolWindowTab toolWindowTab = tab;
                }
                if (selectedTab == null) {
                    if (var9_14 != null) {
                        void tab = var9_14;
                        SwingUtilities.invokeLater(new Runnable((ToolWindowTab)tab){
                            final /* synthetic */ ToolWindowTab val$tab;
                            {
                                this.val$tab = toolWindowTab;
                            }

                            public void run() {
                                this.val$tab.setSelected(true);
                            }
                        });
                    } else {
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                MyDoggyToolWindow.this.toolWindowTabs.get(0).setSelected(true);
                            }
                        });
                    }
                }
            }
            if (aggregate) {
                this.firePropertyChangeEvent("visible", old, visible, new Object[]{aggregate, aggregationPosition, aggregationOnTool, aggregateReferenceTool});
            } else {
                this.firePropertyChangeEvent("visible", old, visible);
            }
        }
    }

    protected ToolWindowTab addTabInternal(String title, Icon icon, Component component, ToolWindow toolWindow, boolean root) {
        MyDoggyToolWindowTab tab = new MyDoggyToolWindowTab(this, root, title, icon, component, toolWindow);
        this.toolWindowTabs.add(tab);
        this.fireToolWindowTabEvent(new ToolWindowTabEvent(this, ToolWindowTabEvent.ActionId.TAB_ADDED, this, tab));
        if (this.toolWindowTabs.size() == 1) {
            this.rootTab = tab;
        }
        return tab;
    }

    protected void addTabInternal(ToolWindowTab tab) {
        MyDoggyToolWindowTab newTab = new MyDoggyToolWindowTab(this, false, tab.getTitle(), tab.getIcon(), tab.getComponent(), tab);
        this.toolWindowTabs.add(newTab);
        this.fireToolWindowTabEvent(new ToolWindowTabEvent(this, ToolWindowTabEvent.ActionId.TAB_ADDED, this, newTab));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setTypeInternal(ToolWindowType type) {
        Object object = this.getLock();
        synchronized (object) {
            ToolWindowType oldType;
            if (this.type == type) {
                return;
            }
            switch (type) {
                case SLIDING: {
                    if (this.getTypeDescriptor(ToolWindowType.SLIDING).isEnabled()) break;
                    return;
                }
                case FLOATING: 
                case FLOATING_FREE: {
                    if (this.getTypeDescriptor(ToolWindowType.FLOATING).isEnabled()) break;
                    return;
                }
            }
            if (this.isMaximized()) {
                this.setMaximized(false);
            }
            boolean tempVisible = this.isVisible();
            boolean tempActive = this.isActive();
            this.publicEvent = false;
            try {
                this.setVisible(false);
                if (tempActive) {
                    this.active = false;
                }
                this.publicEvent = true;
                oldType = this.type;
                this.type = type;
                if (type != ToolWindowType.EXTERN) {
                    if (tempActive && tempVisible) {
                        this.setActive(true);
                    } else if (tempVisible) {
                        this.setVisible(true);
                    }
                }
            }
            finally {
                this.publicEvent = true;
            }
            this.firePropertyChangeEvent("type", (Object)oldType, (Object)type);
        }
    }

    @Override
    protected void firePropertyChangeEvent(String property, Object oldValue, Object newValue) {
        PropertyChangeEvent publicEvent = new PropertyChangeEvent(this, property, oldValue, newValue);
        this.firePropertyChangeEvent(publicEvent, publicEvent);
    }

    @Override
    protected void firePropertyChangeEvent(String property, Object oldValue, Object newValue, Object userObject) {
        UserPropertyChangeEvent publicEvent = new UserPropertyChangeEvent(this, property, oldValue, newValue, userObject);
        this.firePropertyChangeEvent(publicEvent, publicEvent);
    }

    protected void fireAnchorEvent(ToolWindowAnchor oldValue, ToolWindowAnchor newValue, Object userObject) {
        this.firePropertyChangeEvent("anchor", (Object)oldValue, (Object)newValue, userObject);
    }

    protected void fireToolWindowTabEvent(ToolWindowTabEvent event) {
        ToolWindowListener[] listeners;
        switch (event.getActionId()) {
            case TAB_ADDED: {
                event.getToolWindowTab().addPropertyChangeListener(this.pclListener);
                break;
            }
            case TAB_REMOVED: {
                event.getToolWindowTab().removePropertyChangeListener(this.pclListener);
            }
        }
        if (this.toolWindowListeners == null) {
            return;
        }
        block8: for (ToolWindowListener listener : listeners = (ToolWindowListener[])this.toolWindowListeners.getListeners(ToolWindowListener.class)) {
            switch (event.getActionId()) {
                case TAB_ADDED: {
                    listener.toolWindowTabAdded(event);
                    continue block8;
                }
                case TAB_REMOVED: {
                    listener.toolWindowTabRemoved(event);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Property {
        visible;

    }

    static class ToolWindowLock {
        ToolWindowLock() {
        }
    }
}

