/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.export.vcd;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import javax.swing.JComponent;
import nl.lxtreme.ols.api.acquisition.AcquisitionResult;
import nl.lxtreme.ols.api.data.Channel;
import nl.lxtreme.ols.api.data.DataSet;
import nl.lxtreme.ols.api.data.export.Exporter;
import nl.lxtreme.ols.export.vcd.ValueChangeDumpHelper;
import nl.lxtreme.ols.util.StringUtils;

public class ValueChangeDumpExporter
implements Exporter {
    private static final String ID = "OLS Java Client";
    private static final String VERSION = "VCD exporter v1.1";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void export(DataSet aDataSet, JComponent aComponent, OutputStream aStream) throws IOException {
        PrintWriter writer = new PrintWriter(aStream);
        try {
            AcquisitionResult capturedData = aDataSet.getCapturedData();
            double timescale = ValueChangeDumpHelper.getTimebase(capturedData.getSampleRate());
            this.writePreamble(writer, aDataSet, timescale);
            this.writeVariableDump(writer, aDataSet);
            this.writeDataDump(writer, capturedData, timescale);
        }
        finally {
            writer.flush();
        }
    }

    public String[] getFilenameExtentions() {
        return new String[]{"vcd"};
    }

    public String getName() {
        return "Value Change Dump";
    }

    protected void writeDataDump(PrintWriter aWriter, AcquisitionResult aCapturedData, double aTimebase) {
        int[] values = aCapturedData.getValues();
        long[] timestamps = aCapturedData.getTimestamps();
        int channelCount = aCapturedData.getChannels();
        int channelMask = aCapturedData.getEnabledChannels();
        int oldValue = -1;
        int size = values.length;
        for (int i = 0; i < size; ++i) {
            int value = values[i];
            long timestamp = timestamps[i];
            int time = (int)((double)timestamp / ((double)aCapturedData.getSampleRate() * aTimebase));
            if (i == 0 || oldValue != value) {
                this.writeTime(aWriter, time);
                this.writeVariableData(aWriter, channelCount, channelMask, value, oldValue, i == 0);
            }
            oldValue = value;
        }
        int time = (int)((double)aCapturedData.getAbsoluteLength() / ((double)aCapturedData.getSampleRate() * aTimebase));
        this.writeTime(aWriter, time);
    }

    protected void writePreamble(PrintWriter aWriter, DataSet aDataSet, double aTimescale) {
        ValueChangeDumpHelper.writeDeclaration(aWriter, "comment", ID);
        ValueChangeDumpHelper.writeDate(aWriter);
        ValueChangeDumpHelper.writeDeclaration(aWriter, "version", VERSION);
        ValueChangeDumpHelper.writeTimescale(aWriter, aTimescale);
        ValueChangeDumpHelper.writeDeclaration(aWriter, "scope", "module logic");
        this.writeVariableDefinitions(aWriter, aDataSet);
        ValueChangeDumpHelper.writeDeclaration(aWriter, "upscope", new String[0]);
        ValueChangeDumpHelper.writeDeclaration(aWriter, "enddefinitions", new String[0]);
    }

    protected void writeSingleVariableDefinition(PrintWriter aWriter, int aIndex) {
        aWriter.printf("x%s", ValueChangeDumpHelper.getIdentifier(aIndex)).println();
    }

    protected void writeTime(PrintWriter aWriter, long aTimebase) {
        ValueChangeDumpHelper.writeTime(aWriter, aTimebase);
    }

    protected void writeVariableData(PrintWriter aWriter, int aChannelCount, int aChannelMask, int aValue, int aOldValue, boolean aAllBits) {
        int value = aValue;
        int oldValue = aOldValue;
        int mask = aChannelMask;
        for (int i = 0; i < aChannelCount; ++i) {
            if ((mask & 1 << i) == 0) continue;
            int bitValue = value & 1;
            int oldBitValue = oldValue & 1;
            if (aAllBits || bitValue != oldBitValue) {
                aWriter.printf("%d%s", bitValue, ValueChangeDumpHelper.getIdentifier(i)).println();
            }
            value >>= 1;
            oldValue >>= 1;
        }
    }

    protected void writeVariableDefinitions(PrintWriter aWriter, DataSet aDataSet) {
        AcquisitionResult capturedData = aDataSet.getCapturedData();
        int channelMask = capturedData.getEnabledChannels();
        Channel[] channelLabels = aDataSet.getChannels();
        for (int i = 0; i < channelLabels.length; ++i) {
            if ((channelMask & 1 << i) == 0) continue;
            String label = channelLabels[i].getLabel();
            if (StringUtils.isEmpty((String)label)) {
                label = "channel" + i;
            }
            ValueChangeDumpHelper.writeVariable(aWriter, i, label);
        }
    }

    protected void writeVariableDump(PrintWriter aWriter, DataSet aDataSet) {
        AcquisitionResult capturedData = aDataSet.getCapturedData();
        int channelCount = capturedData.getChannels();
        int channelMask = capturedData.getEnabledChannels();
        ValueChangeDumpHelper.writeOpenDeclaration(aWriter, "dumpvars");
        for (int i = 0; i < channelCount; ++i) {
            if ((channelMask & 1 << i) == 0) continue;
            this.writeSingleVariableDefinition(aWriter, i);
        }
        ValueChangeDumpHelper.writeCloseDeclaration(aWriter);
    }
}

