/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.tool.uart.impl;

import nl.lxtreme.ols.api.data.BaseData;

public final class UARTData
extends BaseData<UARTData> {
    public static final int UART_TYPE_EVENT = 0;
    public static final int UART_TYPE_RXEVENT = 1;
    public static final int UART_TYPE_TXEVENT = 2;
    public static final int UART_TYPE_RXDATA = 3;
    public static final int UART_TYPE_TXDATA = 4;
    private final int data;
    private final int type;

    public UARTData(int aIndex, int aChannelIdx, int aStartSampleIdx, int aEndSampleIdx, int aData, int aType) {
        super(aIndex, aChannelIdx, aStartSampleIdx, aEndSampleIdx);
        this.data = aData;
        this.type = aType;
    }

    public UARTData(int aIndex, int aChannelIdx, int aSampleIdx, String aEvent) {
        this(aIndex, aChannelIdx, aSampleIdx, aEvent, 0);
    }

    public UARTData(int aIndex, int aChannelIdx, int aSampleIdx, String aEvent, int aType) {
        super(aIndex, aChannelIdx, aSampleIdx, aEvent);
        this.data = 0;
        this.type = aType;
    }

    public int compareTo(UARTData aComparable) {
        return this.getStartSampleIndex() - aComparable.getStartSampleIndex();
    }

    public boolean equals(Object aObject) {
        if (this == aObject) {
            return true;
        }
        if (!super.equals(aObject) || !(aObject instanceof UARTData)) {
            return false;
        }
        UARTData other = (UARTData)((Object)aObject);
        if (this.data != other.data) {
            return false;
        }
        return this.type == other.type;
    }

    public int getData() {
        return this.data;
    }

    public int getType() {
        return this.type;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.data;
        result = 31 * result + this.type;
        return result;
    }

    public boolean isEvent() {
        return this.type == 0 || this.type == 1 || this.type == 2;
    }
}

