/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.client.signaldisplay.util;

import java.awt.Graphics2D;
import java.awt.Polygon;

public class ArrowRenderer {
    private static final int LEFT_FACING = 1;
    private static final int RIGHT_FACING = -1;
    public static final int HEAD_WIDTH = 8;
    public static final int HEAD_HEIGHT = 8;

    public static void render(Graphics2D aCanvas, int aWidth, int aMidPos) {
        if (aWidth > 0 && aMidPos >= 0) {
            int dir = 1;
            if (aWidth - aMidPos > aMidPos) {
                dir = -1;
            }
            ArrowRenderer.drawArrowHead(aCanvas, aMidPos, 0, dir, 8, 8);
        }
        ArrowRenderer.drawDoubleHeadedArrow(aCanvas, 0, 0, aWidth, 0, 8, 8);
    }

    private static void drawArrowHead(Graphics2D aCanvas, int aXpos, int aYpos, int aDirection, int aArrowWidth, int aArrowHeight) {
        double halfHeight = (double)aArrowHeight / 2.0;
        int x1 = aXpos + aDirection * aArrowWidth;
        int y1 = (int)Math.ceil((double)aYpos - halfHeight);
        int y2 = (int)Math.floor((double)aYpos + halfHeight);
        Polygon arrowHead = new Polygon();
        arrowHead.addPoint(aXpos, aYpos);
        arrowHead.addPoint(x1, y1);
        arrowHead.addPoint(x1, y2);
        aCanvas.fill(arrowHead);
    }

    private static void drawDoubleHeadedArrow(Graphics2D aCanvas, int aX1, int aY1, int aX2, int aY2, int aArrowWidth, int aArrowHeight) {
        int threshold;
        int x2 = aX2;
        int x1 = aX1;
        int lineWidth = Math.abs(x2 - x1);
        if (lineWidth > (threshold = 2 * aArrowWidth + 2)) {
            ArrowRenderer.drawArrowHead(aCanvas, x1, aY1, 1, aArrowWidth, aArrowHeight);
            ArrowRenderer.drawArrowHead(aCanvas, x2 + 1, aY2, -1, aArrowWidth, aArrowHeight);
            x1 += aArrowWidth - 1;
            x2 -= aArrowWidth + 1;
        }
        aCanvas.drawLine(x1, aY1, x2, aY2);
    }
}

