/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.client.project.impl;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.UIManager;
import nl.lxtreme.ols.api.UserSettings;
import nl.lxtreme.ols.api.acquisition.AcquisitionResult;
import nl.lxtreme.ols.api.data.project.Project;
import nl.lxtreme.ols.api.data.project.ProjectVisitor;
import nl.lxtreme.ols.client.project.impl.DataSetImpl;
import nl.lxtreme.ols.client.project.impl.OlsDataHelper;
import nl.lxtreme.ols.client.project.impl.ProjectProperties;
import nl.lxtreme.ols.client.project.impl.UserSettingsImpl;

public final class ProjectImpl
implements Project,
ProjectProperties,
PropertyChangeListener {
    private static final Logger LOG = Logger.getLogger(ProjectImpl.class.getName());
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private final Map<String, UserSettings> settings = new HashMap<String, UserSettings>();
    private DataSetImpl dataSet;
    private String name;
    private boolean changed;
    private Date lastModified;
    private String sourceVersion;
    private File filename;

    public ProjectImpl() {
        this.setDataSet(new DataSetImpl());
        this.changed = false;
    }

    public void addPropertyChangeListener(PropertyChangeListener aListener) {
        this.propertyChangeSupport.addPropertyChangeListener(aListener);
    }

    public DataSetImpl getDataSet() {
        return this.dataSet;
    }

    public File getFilename() {
        return this.filename;
    }

    public Date getLastModified() {
        return this.lastModified;
    }

    public String getName() {
        return this.name;
    }

    public UserSettings getSettings(String aName) {
        UserSettings result = this.settings.get(aName);
        if (result == null) {
            result = new UserSettingsImpl(aName);
            this.settings.put(aName, result);
        }
        return result;
    }

    public String getSourceVersion() {
        return this.sourceVersion;
    }

    public boolean isChanged() {
        return this.changed;
    }

    @Override
    public void propertyChange(PropertyChangeEvent aEvent) {
        String name = aEvent.getPropertyName();
        if ("cursorsEnabled".equals(name) || name.startsWith("channel") || name.startsWith("cursor")) {
            this.setChanged(true);
        }
        this.propertyChangeSupport.firePropertyChange(aEvent);
    }

    public final void readData(Reader aReader) throws IOException {
        this.setDataSet(OlsDataHelper.read(aReader));
    }

    public void removePropertyChangeListener(PropertyChangeListener aListener) {
        this.propertyChangeSupport.removePropertyChangeListener(aListener);
    }

    public void setCapturedData(AcquisitionResult aCapturedData) {
        DataSetImpl old = this.dataSet;
        boolean retainAnnotations = UIManager.getBoolean("ols.retain.annotations.boolean");
        this.setDataSet(new DataSetImpl(aCapturedData, old, retainAnnotations));
        this.setChanged(true);
    }

    public void setChanged(boolean aChanged) {
        boolean old = this.changed;
        this.changed = aChanged;
        this.propertyChangeSupport.firePropertyChange("changed", old, aChanged);
    }

    public void setFilename(File aFilename) {
        File old = this.filename;
        this.filename = aFilename;
        this.propertyChangeSupport.firePropertyChange("filename", old, aFilename);
    }

    public void setLastModified(Date aLastModified) {
        Date old = this.lastModified;
        this.lastModified = aLastModified;
        this.propertyChangeSupport.firePropertyChange("lastModified", old, aLastModified);
        this.setChanged(true);
    }

    public void setName(String aName) {
        String old = this.name;
        this.name = aName;
        this.propertyChangeSupport.firePropertyChange("name", old, aName);
        this.setChanged(true);
    }

    public void setSettings(UserSettings aSettings) {
        if (aSettings == null) {
            throw new IllegalArgumentException("Settings cannot be null!");
        }
        UserSettings old = this.settings.get(aSettings.getName());
        this.settings.put(aSettings.getName(), aSettings);
        this.propertyChangeSupport.firePropertyChange("settings", old, aSettings);
        this.setChanged(true);
    }

    public void setSourceVersion(String aSourceVersion) {
        String old = this.sourceVersion;
        this.sourceVersion = aSourceVersion;
        this.propertyChangeSupport.firePropertyChange("sourceVersion", old, aSourceVersion);
        this.setChanged(true);
    }

    public void visit(ProjectVisitor aVisitor) {
        ArrayList<UserSettings> userSettings = new ArrayList<UserSettings>(this.settings.values());
        for (UserSettings settings : userSettings) {
            try {
                aVisitor.visit(settings);
            }
            catch (Exception exception) {
                LOG.log(Level.INFO, "Exception during visiting project! Continuing anyway...", exception);
            }
        }
    }

    public void writeData(Writer aWriter) throws IOException {
        OlsDataHelper.write(this.dataSet, aWriter);
    }

    final PropertyChangeListener[] getPropertyChangeListeners() {
        return this.propertyChangeSupport.getPropertyChangeListeners();
    }

    final void setDataSet(DataSetImpl aDataSet) {
        if (aDataSet == null) {
            throw new IllegalArgumentException();
        }
        if (this.dataSet != null) {
            this.dataSet.removePropertyChangeListener(this);
        }
        DataSetImpl old = this.dataSet;
        this.dataSet = aDataSet;
        this.dataSet.addPropertyChangeListener(this);
        this.propertyChangeSupport.firePropertyChange("capturedData", old, this.dataSet);
    }
}

