/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.acquisition;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import nl.lxtreme.ols.api.DataAcquisitionService;
import nl.lxtreme.ols.api.acquisition.AcquisitionDataListener;
import nl.lxtreme.ols.api.acquisition.AcquisitionProgressListener;
import nl.lxtreme.ols.api.acquisition.AcquisitionResult;
import nl.lxtreme.ols.api.acquisition.AcquisitionResultStatus;
import nl.lxtreme.ols.api.acquisition.AcquisitionStatusListener;
import nl.lxtreme.ols.api.devices.AcquisitionTask;
import nl.lxtreme.ols.api.devices.CancelTask;
import nl.lxtreme.ols.api.devices.Device;
import nl.lxtreme.ols.api.task.Task;
import nl.lxtreme.ols.api.task.TaskExecutionService;
import nl.lxtreme.ols.api.task.TaskStatusListener;

public class BackgroundDataAcquisitionService
implements DataAcquisitionService,
TaskStatusListener {
    private static final Logger LOG = Logger.getLogger(BackgroundDataAcquisitionService.class.getName());
    private final List<AcquisitionProgressListener> acquisitionProgressListeners = new CopyOnWriteArrayList<AcquisitionProgressListener>();
    private final List<AcquisitionStatusListener> acquisitionStatusListeners = new CopyOnWriteArrayList<AcquisitionStatusListener>();
    private final List<AcquisitionDataListener> acquisitionDataListeners = new CopyOnWriteArrayList<AcquisitionDataListener>();
    private volatile TaskExecutionService taskExecutionService;
    private volatile Future<?> acquisitionFutureTask;
    private volatile Task<AcquisitionResult> acquisitionTask;

    public void acquireData(final Device aDevice) throws IOException {
        final AcquisitionTask innerTask = aDevice.createAcquisitionTask(new AcquisitionProgressListener(){

            public void acquisitionInProgress(int aPercentage) {
                BackgroundDataAcquisitionService.this.fireAcquisitionInProgressEvent(aPercentage);
            }
        });
        this.acquisitionTask = new Task<AcquisitionResult>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public AcquisitionResult call() throws Exception {
                try {
                    AcquisitionResult acquisitionResult = (AcquisitionResult)innerTask.call();
                    return acquisitionResult;
                }
                finally {
                    aDevice.close();
                }
            }
        };
        this.acquisitionFutureTask = this.taskExecutionService.execute(this.acquisitionTask);
    }

    public void addAcquisitionDataListener(AcquisitionDataListener aListener) {
        this.acquisitionDataListeners.add(aListener);
    }

    public void addAcquisitionProgressListener(AcquisitionProgressListener aListener) {
        this.acquisitionProgressListeners.add(aListener);
    }

    public void addAcquisitionStatusListener(AcquisitionStatusListener aListener) {
        this.acquisitionStatusListeners.add(aListener);
    }

    public void cancelAcquisition(Device aDevice) throws IOException, IllegalStateException {
        if (this.acquisitionFutureTask == null) {
            throw new IllegalStateException("No acquisition in progress!");
        }
        CancelTask cancelTask = aDevice.createCancelTask();
        if (cancelTask != null) {
            this.taskExecutionService.execute((Task)cancelTask);
        } else {
            this.acquisitionFutureTask.cancel(true);
            this.acquisitionFutureTask = null;
        }
    }

    public boolean isAcquiring() {
        return this.acquisitionFutureTask != null && !this.acquisitionFutureTask.isDone();
    }

    public void removeAcquisitionDataListener(AcquisitionDataListener aListener) {
        this.acquisitionDataListeners.remove(aListener);
    }

    public void removeAcquisitionProgressListener(AcquisitionProgressListener aListener) {
        this.acquisitionProgressListeners.remove(aListener);
    }

    public void removeAcquisitionStatusListener(AcquisitionStatusListener aListener) {
        this.acquisitionStatusListeners.remove(aListener);
    }

    public void stop() {
        if (this.acquisitionFutureTask != null && !this.acquisitionFutureTask.isDone()) {
            this.acquisitionFutureTask.cancel(true);
            this.acquisitionFutureTask = null;
        }
    }

    public <RT> void taskEnded(Task<RT> aTask, RT aResult) {
        if (aTask == this.acquisitionTask) {
            this.acquisitionTask = null;
            this.acquisitionFutureTask = null;
            AcquisitionResult result = (AcquisitionResult)aResult;
            this.fireAcquisitionCompleteEvent(result);
            AcquisitionResultStatus status = new AcquisitionResultStatus(AcquisitionResultStatus.ResultStatus.NORMAL);
            this.fireAcquisitionEndedEvent(status);
            LOG.log(Level.INFO, "Acquisition successful!");
        }
    }

    public <RT> void taskFailed(Task<RT> aTask, Exception aException) {
        if (aTask == this.acquisitionTask) {
            this.acquisitionTask = null;
            this.acquisitionFutureTask = null;
            AcquisitionResultStatus status = AcquisitionResultStatus.create((Throwable)aException);
            this.fireAcquisitionEndedEvent(status);
            LOG.log(Level.WARNING, "Acquisition failed!", aException);
        }
    }

    public <RT> void taskStarted(Task<RT> aTask) {
        if (this.acquisitionTask == aTask) {
            this.fireAcquisitionStartedEvent();
        }
    }

    void fireAcquisitionCompleteEvent(AcquisitionResult result) {
        Iterator<AcquisitionDataListener> dataListenerIter = this.acquisitionDataListeners.iterator();
        while (dataListenerIter.hasNext()) {
            dataListenerIter.next().acquisitionComplete(result);
        }
    }

    void fireAcquisitionEndedEvent(AcquisitionResultStatus status) {
        Iterator<AcquisitionStatusListener> statusListenerIter = this.acquisitionStatusListeners.iterator();
        while (statusListenerIter.hasNext()) {
            statusListenerIter.next().acquisitionEnded(status);
        }
    }

    void fireAcquisitionInProgressEvent(int aPercentage) {
        Iterator<AcquisitionProgressListener> iter = this.acquisitionProgressListeners.iterator();
        while (iter.hasNext()) {
            iter.next().acquisitionInProgress(aPercentage);
        }
    }

    void fireAcquisitionStartedEvent() {
        Iterator<AcquisitionStatusListener> statusListenerIter = this.acquisitionStatusListeners.iterator();
        while (statusListenerIter.hasNext()) {
            statusListenerIter.next().acquisitionStarted();
        }
    }
}

