/*
 * Decompiled with CFR 0.152.
 */
package org.sump.device.logicsniffer;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import nl.lxtreme.ols.api.devices.DeviceMetadata;
import org.sump.device.logicsniffer.profile.DeviceProfile;

public final class LogicSnifferMetadata
implements DeviceMetadata {
    private final Map<Integer, Object> values = new HashMap<Integer, Object>();
    private DeviceProfile deviceProfile;

    public String getAncillaryVersion() {
        return (String)this.getValue(3);
    }

    public DeviceProfile getDeviceProfile() {
        return this.deviceProfile;
    }

    public Integer getDynamicMemoryDepth() {
        return (Integer)this.getValue(34);
    }

    public String getFpgaVersion() {
        return (String)this.getValue(2);
    }

    public Integer getMaxSampleRate() {
        return (Integer)this.getValue(35);
    }

    public String getName() {
        return (String)this.getValue(1);
    }

    public Integer getProbeCount() {
        Object result = this.getValue(32);
        if (result == null) {
            result = this.getValue(64);
        }
        return (Integer)result;
    }

    public int getProbeCount(int aDefaultProbeCount) {
        Integer result = this.getProbeCount();
        if (result == null) {
            return aDefaultProbeCount;
        }
        return result;
    }

    public Integer getProtocolVersion() {
        Object result = this.getValue(36);
        if (result == null) {
            result = this.getValue(65);
        }
        return (Integer)result;
    }

    public Integer getSampleMemoryDepth() {
        return (Integer)this.getValue(33);
    }

    public int getSampleMemoryDepth(int aDefaultSize) {
        Integer result = this.getSampleMemoryDepth();
        if (result == null) {
            return aDefaultSize;
        }
        return result;
    }

    public Iterator<Object> iterator() {
        return this.values.values().iterator();
    }

    public void put(int aKey, Object aValue) throws IllegalStateException {
        Integer key = aKey;
        if (this.values.containsKey(key)) {
            throw new IllegalStateException("Duplicate key: 0x" + Integer.toHexString(aKey) + "!");
        }
        this.values.put(key, aValue);
    }

    public void setDeviceProfile(DeviceProfile aDeviceProfile) {
        this.deviceProfile = aDeviceProfile;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Device name              => ").append(this.getValue(1)).append('\n');
        sb.append("FPGA version             => ").append(this.getValue(2)).append('\n');
        sb.append("Ancillary version        => ").append(this.getValue(3)).append('\n');
        sb.append("Protocol version (long)  => ").append(this.getValue(36)).append('\n');
        sb.append("Protocol version (short) => ").append(this.getValue(65)).append('\n');
        sb.append("Probe count (long)       => ").append(this.getValue(32)).append('\n');
        sb.append("Probe count (short)      => ").append(this.getValue(64)).append('\n');
        sb.append("Sample memory depth (b)  => ").append(this.getValue(33)).append('\n');
        sb.append("Dynamic memory depth (b) => ").append(this.getValue(34)).append('\n');
        sb.append("Max. sample rate (Hz)    => ").append(this.getValue(35)).append('\n');
        return sb.toString();
    }

    private Object getValue(int aKey) {
        return this.values.get(aKey);
    }
}

