/*
 * Decompiled with CFR 0.152.
 */
package org.noos.xing.mydoggy.plaf.ui.cmp;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.image.BufferedImage;
import org.noos.xing.mydoggy.AggregationPosition;
import org.noos.xing.mydoggy.Content;
import org.noos.xing.mydoggy.ContentManager;
import org.noos.xing.mydoggy.ContentUI;
import org.noos.xing.mydoggy.Dockable;
import org.noos.xing.mydoggy.MultiSplitConstraint;
import org.noos.xing.mydoggy.ToolWindowAnchor;
import org.noos.xing.mydoggy.plaf.MyDoggyToolWindowManager;
import org.noos.xing.mydoggy.plaf.ui.cmp.DockableDropPanel;
import org.noos.xing.mydoggy.plaf.ui.cmp.DockablePanel;
import org.noos.xing.mydoggy.plaf.ui.cmp.MultiSplitDockableContainer;
import org.noos.xing.mydoggy.plaf.ui.cmp.TabbedContentPane;
import org.noos.xing.mydoggy.plaf.ui.cmp.multisplit.MultiSplitPanel;
import org.noos.xing.mydoggy.plaf.ui.drag.DragListenerAdapter;
import org.noos.xing.mydoggy.plaf.ui.drag.MyDoggyTransferable;
import org.noos.xing.mydoggy.plaf.ui.util.SwingUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiSplitTabbedContentContainer<D extends Dockable>
extends MultiSplitDockableContainer<D> {
    protected DockableDropPanel dockableDropPanel;

    public MultiSplitTabbedContentContainer(MyDoggyToolWindowManager toolWindowManager) {
        super(toolWindowManager, 0);
        this.setStoreLayout(false);
        this.dockableDropPanel = this.createDockableDropPanel();
        this.add((Component)this.dockableDropPanel, "0,0,FULL,FULL");
    }

    public Component[] getTabbedComponents() {
        Component component = this.dockableDropPanel.getComponent();
        if (component instanceof MultiSplitPanel) {
            return ((MultiSplitPanel)component).getComponents();
        }
        return new Component[]{component};
    }

    @Override
    protected Component getWrapperForComponent(Dockable dockable, Component component, MultiSplitDockableContainer.Action action) {
        if (this.isWrapRequest(dockable, action)) {
            return this.forceWrapperForComponent(dockable, component);
        }
        DockablePanel wrapper = new DockablePanel(dockable, component);
        wrapper.setName("@@mydoggy.dockable.panel");
        return wrapper;
    }

    @Override
    protected Component forceWrapperForComponent(Dockable dockable, Component component) {
        TabbedContentPane wrapper = new TabbedContentPane();
        wrapper.setToolWindowManager(this.toolWindowManager);
        wrapper.setName("@@mydoggy.dockable.tabbedpane");
        wrapper.addTab((Content)dockable, (Component)new DockablePanel(dockable, component));
        wrapper.setDragListener(new TabbedDragListener(wrapper));
        return wrapper;
    }

    @Override
    protected Component getComponentFromWrapper(Component wrapper) {
        if (wrapper instanceof TabbedContentPane) {
            TabbedContentPane tabbedPane = (TabbedContentPane)wrapper;
            return this.getComponentFromWrapper(tabbedPane.getComponentAt(0));
        }
        if (wrapper instanceof DockablePanel) {
            return ((DockablePanel)wrapper).getComponent();
        }
        return wrapper;
    }

    @Override
    protected Component getComponentFromWrapper(Component wrapper, Dockable dockable) {
        if (wrapper instanceof TabbedContentPane) {
            TabbedContentPane tabbedPane = (TabbedContentPane)wrapper;
            return this.getComponentFromWrapper(tabbedPane.getComponentAt(tabbedPane.indexOfContent((Content)dockable)), dockable);
        }
        if (wrapper instanceof DockablePanel) {
            return ((DockablePanel)wrapper).getComponent();
        }
        return wrapper;
    }

    @Override
    protected void addToWrapper(Component wrapper, Dockable dockable, int aggregationIndexLocation, Component content) {
        if (wrapper instanceof TabbedContentPane) {
            TabbedContentPane tabbedContentPane = (TabbedContentPane)wrapper;
            tabbedContentPane.addTab((Content)dockable, new DockablePanel(dockable, content), aggregationIndexLocation);
            tabbedContentPane.setSelectedIndex(aggregationIndexLocation < 0 || aggregationIndexLocation >= tabbedContentPane.getTabCount() ? tabbedContentPane.getTabCount() - 1 : aggregationIndexLocation);
        } else if (wrapper instanceof DockablePanel) {
            DockablePanel wrapperContainer = (DockablePanel)wrapper;
            TabbedContentPane tabbedContentPane = (TabbedContentPane)this.forceWrapperForComponent(wrapperContainer.getDockable(), wrapperContainer.getComponent());
            tabbedContentPane.addTab((Content)dockable, new DockablePanel(dockable, content), aggregationIndexLocation);
            tabbedContentPane.setSelectedIndex(aggregationIndexLocation < 0 || aggregationIndexLocation >= tabbedContentPane.getTabCount() ? tabbedContentPane.getTabCount() - 1 : aggregationIndexLocation);
            String leafName = this.getLeafName(wrapperContainer.getDockable());
            this.multiSplitPane.remove(this.multiSplitPane.getMultiSplitLayout().getChildMap().get(leafName));
            this.multiSplitPane.add(leafName, tabbedContentPane);
        } else {
            throw new IllegalArgumentException("Invalid Wrapper.");
        }
    }

    @Override
    protected int removeFromWrapper(Component wrapperSource, Dockable dockable) {
        TabbedContentPane tabbedPane = (TabbedContentPane)wrapperSource;
        int index = tabbedPane.indexOfContent((Content)dockable);
        if (index != -1) {
            tabbedPane.removeTabAt(index);
            if (tabbedPane.getTabCount() == 1) {
                Content lastDockable = tabbedPane.getContentAt(0);
                if (!this.isWrapRequest(tabbedPane.getContentAt(0), MultiSplitDockableContainer.Action.REMOVE_DOCK)) {
                    String leafName = this.getLeafName(lastDockable);
                    this.multiSplitPane.remove(this.multiSplitPane.getMultiSplitLayout().getChildMap().get(leafName));
                    this.multiSplitPane.add(leafName, this.getWrapperForComponent(lastDockable, ((DockablePanel)tabbedPane.getComponentAt(0)).getComponent(), MultiSplitDockableContainer.Action.REMOVE_DOCK));
                }
            }
            return index;
        }
        throw new IllegalArgumentException("Cannot find that dockable on the passed tabbedpane");
    }

    @Override
    protected Component getRootComponent() {
        return this.dockableDropPanel.getComponent();
    }

    @Override
    protected void setRootComponent(Component component) {
        this.dockableDropPanel.setComponent(component);
    }

    @Override
    protected void resetRootComponent() {
        this.dockableDropPanel.resetComponent();
    }

    @Override
    protected boolean isWrapper(Component component) {
        return component instanceof TabbedContentPane;
    }

    protected DockableDropPanel createDockableDropPanel() {
        return new MultiSplitTabbedDockableDropPanel();
    }

    protected boolean isDockableContainerDragEnabled() {
        return true;
    }

    public class MultiSplitTabbedDockableDropPanel
    extends DockableDropPanel {
        public MultiSplitTabbedDockableDropPanel() {
            super(10, Content.class);
        }

        public boolean dragStart(Transferable transferable, int action) {
            try {
                if (transferable.isDataFlavorSupported(MyDoggyTransferable.TOOL_WINDOW_MANAGER) && transferable.getTransferData(MyDoggyTransferable.TOOL_WINDOW_MANAGER).equals(System.identityHashCode(MultiSplitTabbedContentContainer.this.toolWindowManager)) && transferable.isDataFlavorSupported(MyDoggyTransferable.CONTENT_ID_DF)) {
                    return super.dragStart(transferable, action);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return false;
        }

        public boolean drop(Transferable transferable) {
            if (transferable.isDataFlavorSupported(MyDoggyTransferable.CONTENT_ID_DF)) {
                try {
                    ContentManager contentManager = MultiSplitTabbedContentContainer.this.toolWindowManager.getContentManager();
                    Content content = contentManager.getContent(transferable.getTransferData(MyDoggyTransferable.CONTENT_ID_DF));
                    if (content != null) {
                        boolean rejectDrop = false;
                        Content onDockable = (Content)this.getOnDockable();
                        int onIndex = this.getOnIndex();
                        if (content == onDockable) {
                            if (onIndex == -1) {
                                rejectDrop = true;
                            } else {
                                DockablePanel dockablePanel;
                                Component onDockableContainer = this.getOnDockableContainer();
                                if (onDockableContainer instanceof TabbedContentPane) {
                                    TabbedContentPane tabbedContentPane = (TabbedContentPane)onDockableContainer;
                                    int size = tabbedContentPane.getTabCount();
                                    for (int i = 0; i < size; ++i) {
                                        DockablePanel dockablePanel2 = (DockablePanel)tabbedContentPane.getComponentAt(i);
                                        if (dockablePanel2.getDockable() != onDockable || i != onIndex) continue;
                                        rejectDrop = true;
                                        break;
                                    }
                                } else if (onDockableContainer instanceof DockablePanel && (dockablePanel = (DockablePanel)onDockableContainer).getDockable() == onDockable) {
                                    rejectDrop = true;
                                }
                            }
                        }
                        if (rejectDrop) {
                            return false;
                        }
                        ToolWindowAnchor onAnchor = this.getOnAnchor();
                        if (content.isDetached()) {
                            content.reattach(new MultiSplitConstraint(onDockable, onIndex, onAnchor == null ? null : AggregationPosition.valueOf(onAnchor.toString())));
                        } else {
                            MultiSplitTabbedContentContainer.this.setConstraints(content, content.getComponent(), onDockable, onIndex, onAnchor == null ? null : AggregationPosition.valueOf(onAnchor.toString()));
                        }
                        return true;
                    }
                    return false;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return false;
                }
            }
            return false;
        }
    }

    public class TabbedDragListener
    extends DragListenerAdapter {
        protected TabbedContentPane tabbedContentPane;
        protected int dragTabIndex;

        public TabbedDragListener(TabbedContentPane tabbedContentPane) {
            super(MultiSplitTabbedContentContainer.this.toolWindowManager);
            this.tabbedContentPane = tabbedContentPane;
        }

        public void dragGestureRecognized(DragGestureEvent dge) {
            super.dragGestureRecognized(dge);
            if (!this.acquireLocks()) {
                return;
            }
            Point origin = dge.getDragOrigin();
            this.dragTabIndex = this.tabbedContentPane.indexAtLocation(origin.x, origin.y);
            if (this.dragTabIndex != -1) {
                Content dockable = this.tabbedContentPane.getContentAt(this.dragTabIndex);
                if (dockable != null) {
                    dge.startDrag(DragSource.DefaultMoveDrop, new MyDoggyTransferable(this.manager, MyDoggyTransferable.CONTENT_ID_DF, dockable.getId()), this);
                    if (SwingUtil.getBoolean("drag.icon.useDefault", false)) {
                        this.setGhostImage(dge.getDragOrigin(), SwingUtil.getImage("mydoggy.image.drag"));
                    } else {
                        Component c = dge.getComponent();
                        Rectangle rect = this.tabbedContentPane.getBoundsAt(this.dragTabIndex);
                        try {
                            BufferedImage image = new BufferedImage(c.getWidth() + rect.width, c.getHeight() + rect.height, 2);
                            Graphics g = image.getGraphics();
                            c.paint(g);
                            image = image.getSubimage(rect.x, rect.y, rect.width, rect.height);
                            this.setGhostImage(dge.getDragOrigin(), image);
                        }
                        catch (Throwable t) {
                            t.printStackTrace();
                            this.setGhostImage(dge.getDragOrigin(), SwingUtil.getImage("mydoggy.image.drag"));
                        }
                    }
                } else {
                    this.releaseLocks();
                }
            } else {
                this.releaseLocks();
            }
        }

        public void dragMouseMoved(DragSourceDragEvent dsde) {
            if (!this.checkStatus()) {
                return;
            }
            this.updateGhostImage(dsde.getLocation());
            this.updateDropTarget(dsde);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dragDropEnd(DragSourceDropEvent dsde) {
            if (!this.checkStatus()) {
                return;
            }
            this.releaseLocks();
            this.cleanupGhostImage();
            try {
                if (this.lastDropPanel != null) {
                    this.lastDropPanel.drop(dsde.getDragSourceContext().getTransferable());
                } else if (this.lastBarAnchor == null && SwingUtil.getBoolean("dnd.content.outside.frame", true)) {
                    Content content = this.tabbedContentPane.getContentAt(this.dragTabIndex);
                    if (content == null) {
                        return;
                    }
                    ContentUI contentUI = content.getContentUI();
                    Rectangle bounds = contentUI.getDetachedBounds();
                    if (bounds != null) {
                        bounds.setLocation(dsde.getLocation());
                    } else {
                        bounds = new Rectangle();
                        bounds.setLocation(dsde.getLocation());
                        bounds.setSize(MultiSplitTabbedContentContainer.this.toolWindowManager.getBoundsToScreen(content.getComponent().getBounds(), content.getComponent().getParent()).getSize());
                    }
                    contentUI.setDetachedBounds(bounds);
                    content.setDetached(true);
                }
            }
            finally {
                this.dockableDropDragEnd();
            }
        }

        protected boolean isDragEnabled() {
            return super.isDragEnabled() && MultiSplitTabbedContentContainer.this.isDockableContainerDragEnabled();
        }
    }
}

