/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.util.export;

import java.util.logging.Level;
import java.util.logging.Logger;
import nl.lxtreme.ols.util.ExportUtils;
import nl.lxtreme.ols.util.export.NullMacroResolver;
import nl.lxtreme.ols.util.export.TagElement;

public class HtmlExporterImpl
implements ExportUtils.HtmlExporter {
    private static final Logger LOG = Logger.getAnonymousLogger();
    private final ExportUtils.HtmlExporter.Element root;
    private final ExportUtils.HtmlExporter.Element head;
    private final ExportUtils.HtmlExporter.Element body;
    private final boolean includeDTD;

    public HtmlExporterImpl(boolean aIncludeDTD) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Creating new HtmlExporter...");
        }
        this.includeDTD = aIncludeDTD;
        this.root = new TagElement("html");
        this.head = this.root.addChild(new TagElement("head"));
        this.head.addChild("title");
        this.body = this.root.addChild(new TagElement("body"));
    }

    @Override
    public void addCssStyle(String aStyleClause) {
        ExportUtils.HtmlExporter.Element style = this.getHead().getChildByName("style");
        if (style == null) {
            style = this.getHead().addChild("style");
            style.addAttribute("type", "text/css");
        }
        style.addContent(aStyleClause);
    }

    @Override
    public ExportUtils.HtmlExporter.Element getBody() {
        return this.body;
    }

    @Override
    public ExportUtils.HtmlExporter.Element getHead() {
        return this.head;
    }

    @Override
    public void setTitle(String aTitle) {
        ExportUtils.HtmlExporter.Element title = this.getHead().getChildByName("title");
        if (title == null) {
            title = this.getHead().addChild("title");
        }
        title.addContent(aTitle);
    }

    public String toString() {
        return this.toString(new NullMacroResolver());
    }

    @Override
    public String toString(ExportUtils.HtmlExporter.MacroResolver aResolver) {
        StringBuilder sb = new StringBuilder();
        if (this.includeDTD) {
            sb.append("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01//EN\" \"http://www.w3.org/TR/html4/strict.dtd\">").append('\n');
        }
        sb.append(this.root.toString(aResolver));
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("+++\n" + sb + "\n---\n");
        }
        return sb.toString();
    }
}

