/*
 * Decompiled with CFR 0.152.
 */
package org.sump.device.logicsniffer;

import java.awt.Window;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.microedition.io.StreamConnection;
import nl.lxtreme.ols.api.acquisition.AcquisitionProgressListener;
import nl.lxtreme.ols.api.devices.AcquisitionTask;
import nl.lxtreme.ols.api.devices.CancelTask;
import nl.lxtreme.ols.api.devices.Device;
import nl.lxtreme.ols.util.swing.SwingComponentUtils;
import org.apache.felix.dm.Component;
import org.apache.felix.dm.Dependency;
import org.apache.felix.dm.DependencyManager;
import org.osgi.service.cm.ManagedServiceFactory;
import org.osgi.service.io.ConnectorService;
import org.sump.device.logicsniffer.LogicSnifferAcquisitionTask;
import org.sump.device.logicsniffer.LogicSnifferCancelTask;
import org.sump.device.logicsniffer.LogicSnifferConfig;
import org.sump.device.logicsniffer.LogicSnifferConfigDialog;
import org.sump.device.logicsniffer.profile.DeviceProfile;
import org.sump.device.logicsniffer.profile.DeviceProfileManager;

public class LogicSnifferDevice
implements Device {
    private static final String NAME = "OpenBench LogicSniffer";
    private static final Logger LOG = Logger.getLogger(LogicSnifferDevice.class.getName());
    private LogicSnifferConfig config;
    private volatile DependencyManager dependencyManager;
    private volatile ManagedServiceFactory deviceProfileManagerServiceFactory;
    private volatile ConnectorService connectorService;
    private volatile StreamConnection connection;
    private volatile LogicSnifferConfigDialog configDialog;

    public void close() throws IOException {
        if (this.connection != null) {
            this.connection.close();
            this.connection = null;
        }
    }

    public AcquisitionTask createAcquisitionTask(AcquisitionProgressListener aProgressListener) throws IOException {
        return new LogicSnifferAcquisitionTask(this.config, this.getStreamConnection(), this.getDeviceProfileManager(), aProgressListener);
    }

    public CancelTask createCancelTask() throws IOException {
        if (this.config.isRleEnabled()) {
            return new LogicSnifferCancelTask(this.getStreamConnection());
        }
        return null;
    }

    public String getName() {
        return NAME;
    }

    public boolean isSetup() {
        return this.config != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setupCapture(Window aOwner) {
        this.disposeConfigDialog();
        this.configDialog = new LogicSnifferConfigDialog(aOwner, this);
        try {
            boolean configConfirmed = this.configDialog.showDialog();
            if (configConfirmed) {
                this.config = this.configDialog.getConfiguration();
            }
            boolean bl = configConfirmed;
            return bl;
        }
        finally {
            this.configDialog.dispose();
            this.configDialog = null;
        }
    }

    final StreamConnection createStreamConnection(String uri) throws IOException {
        return (StreamConnection)this.connectorService.open(uri, 3, true);
    }

    final DeviceProfile getDefaultProfile() {
        return this.getDeviceProfileManager().getDefaultProfile();
    }

    final DeviceProfileManager getDeviceProfileManager() {
        return (DeviceProfileManager)this.deviceProfileManagerServiceFactory;
    }

    protected void destroy(Component aComponent) {
        this.disposeConfigDialog();
    }

    protected void init(Component aComponent) {
        String pmFilter = String.format("(%s=%s)", "service.pid", "ols.profile");
        aComponent.add((Dependency)this.dependencyManager.createServiceDependency().setService(ManagedServiceFactory.class, pmFilter).setAutoConfig("deviceProfileManagerServiceFactory").setInstanceBound(true).setRequired(true)).add((Dependency)this.dependencyManager.createServiceDependency().setService(ConnectorService.class).setAutoConfig("connectorService").setInstanceBound(true).setRequired(true));
    }

    private void disposeConfigDialog() {
        if (this.configDialog != null) {
            SwingComponentUtils.dispose((Window)this.configDialog);
            this.configDialog = null;
        }
    }

    private StreamConnection getStreamConnection() throws IOException {
        if (this.connection == null) {
            String uri = this.config.getConnectionURI();
            if (LOG.isLoggable(Level.INFO)) {
                LOG.info("Connecting to " + uri);
            }
            this.connection = this.createStreamConnection(uri);
        }
        return this.connection;
    }
}

