/*
 * Decompiled with CFR 0.152.
 */
package org.sump.device.logicsniffer;

import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.microedition.io.StreamConnection;
import nl.lxtreme.ols.api.task.Task;
import nl.lxtreme.ols.util.HostUtils;
import org.sump.device.logicsniffer.LogicSnifferDevice;
import org.sump.device.logicsniffer.LogicSnifferMetadata;
import org.sump.device.logicsniffer.profile.DeviceProfile;
import org.sump.device.logicsniffer.protocol.SumpProtocolConstants;

public class LogicSnifferDetectionTask
implements Task<LogicSnifferMetadata>,
SumpProtocolConstants {
    private static final Logger LOG = Logger.getLogger(LogicSnifferDetectionTask.class.getName());
    private final LogicSnifferDevice device;
    private final String connectionURI;

    public LogicSnifferDetectionTask(LogicSnifferDevice aDevice, String aConnectionURI) {
        this.device = aDevice;
        this.connectionURI = aConnectionURI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LogicSnifferMetadata call() throws IOException {
        LogicSnifferMetadata logicSnifferMetadata;
        StreamConnection connection;
        DataOutputStream outputStream;
        DataInputStream inputStream;
        block10: {
            inputStream = null;
            outputStream = null;
            connection = null;
            boolean gotResponse = false;
            try {
                connection = this.device.createStreamConnection(this.connectionURI);
                inputStream = connection.openDataInputStream();
                outputStream = connection.openDataOutputStream();
                LogicSnifferMetadata metadata = new LogicSnifferMetadata();
                int tries = 3;
                do {
                    this.flushInputStream(inputStream);
                    this.writeCmdReset(outputStream);
                    this.writeCmdGetDeviceId(outputStream);
                    this.readDeviceId(inputStream);
                    LOG.log(Level.INFO, "Detected SUMP-compatible device ...");
                    this.flushInputStream(inputStream);
                    this.writeCmdGetMetadata(outputStream);
                    gotResponse = this.readMetadata(inputStream, metadata);
                    if (!gotResponse) continue;
                    LOG.log(Level.INFO, "Found device type: {0}", metadata.getName());
                    LOG.log(Level.FINE, "Device metadata = \n{0}", metadata.toString());
                    metadata.setDeviceProfile(this.getDeviceProfile(metadata.getName()));
                } while (!Thread.currentThread().isInterrupted() && !gotResponse && tries-- > 0);
                logicSnifferMetadata = metadata;
                if (outputStream == null) break block10;
            }
            catch (Throwable throwable) {
                if (outputStream != null) {
                    this.writeCmdReset(outputStream);
                }
                HostUtils.closeResource(inputStream);
                HostUtils.closeResource(outputStream);
                try {
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (IOException exception) {
                    LOG.log(Level.INFO, "I/O connection while trying to close connection after device detect!", exception);
                }
                throw throwable;
            }
            this.writeCmdReset(outputStream);
        }
        HostUtils.closeResource((Closeable)inputStream);
        HostUtils.closeResource((Closeable)outputStream);
        try {
            if (connection != null) {
                connection.close();
            }
        }
        catch (IOException exception) {
            LOG.log(Level.INFO, "I/O connection while trying to close connection after device detect!", exception);
        }
        return logicSnifferMetadata;
    }

    private void flushInputStream(InputStream aResource) throws IOException {
        if (aResource != null) {
            while (aResource.available() > 0 && aResource.read() >= 0) {
            }
        }
    }

    private DeviceProfile getDeviceProfile(String aName) {
        DeviceProfile profile = null;
        if (aName != null) {
            profile = this.device.getDeviceProfileManager().findProfile(aName);
            if (profile != null) {
                LOG.log(Level.INFO, "Using device profile: {0}", profile.getDescription());
            } else {
                LOG.log(Level.SEVERE, "No device profile found matching: {0}", aName);
            }
        } else {
            LOG.log(Level.SEVERE, "No device name provided by metadata! Cannot determine device profile...");
        }
        return profile;
    }

    private int readDeviceId(DataInputStream aInputStream) throws IOException {
        int id = aInputStream.readInt();
        if (id == 809585747) {
            LOG.log(Level.INFO, "Found (unsupported!) Sump Logic Analyzer ...", Integer.toHexString(id));
        } else if (id == 826362963) {
            LOG.log(Level.INFO, "Found Sump Logic Analyzer/LogicSniffer compatible device ...", Integer.toHexString(id));
        } else {
            LOG.log(Level.INFO, "Found unknown device: 0x{0} ...", Integer.toHexString(id));
            id = -1;
        }
        return id;
    }

    private boolean readMetadata(DataInputStream aInputStream, LogicSnifferMetadata aMetadata) throws IOException {
        boolean gotResponse = false;
        int result = -1;
        do {
            try {
                result = aInputStream.read();
                if (result <= 0) continue;
                gotResponse = true;
                int type = (result & 0xE0) >> 5;
                if (type == 0) {
                    String value = this.readString(aInputStream);
                    aMetadata.put(result, value);
                    continue;
                }
                if (type == 1) {
                    int value = aInputStream.readInt();
                    aMetadata.put(result, value);
                    continue;
                }
                if (type == 2) {
                    int value = aInputStream.read();
                    aMetadata.put(result, value);
                    continue;
                }
                LOG.log(Level.INFO, "Ignoring unknown metadata type: {0}", type);
            }
            catch (IOException exception) {
                result = -1;
                if (HostUtils.handleInterruptedException((Throwable)exception)) continue;
                throw exception;
            }
        } while (result > 0 && !Thread.currentThread().isInterrupted());
        return gotResponse;
    }

    private String readString(InputStream aInputStream) throws IOException {
        StringBuilder sb = new StringBuilder();
        int read = -1;
        do {
            if ((read = aInputStream.read()) <= 0) continue;
            sb.append((char)read);
        } while (read > 0 && !Thread.currentThread().isInterrupted());
        return sb.toString();
    }

    private void writeCmdGetDeviceId(DataOutputStream aOutputStream) throws IOException {
        aOutputStream.writeByte(2);
        aOutputStream.flush();
    }

    private void writeCmdGetMetadata(DataOutputStream aOutputStream) throws IOException {
        aOutputStream.writeByte(4);
        aOutputStream.flush();
    }

    private void writeCmdReset(DataOutputStream aOutputStream) throws IOException {
        byte[] resetSequence = new byte[5];
        Arrays.fill(resetSequence, (byte)0);
        aOutputStream.write(resetSequence);
        aOutputStream.flush();
    }
}

