/*
 * Decompiled with CFR 0.152.
 */
package org.sump.device.logicsniffer;

import java.util.Arrays;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import nl.lxtreme.ols.util.NumberUtils;
import org.sump.device.logicsniffer.profile.DeviceProfile;

final class ConfigDialogHelper {
    ConfigDialogHelper() {
    }

    static String getComboBoxText(JComboBox aComboBox) {
        if (aComboBox == null) {
            return null;
        }
        Object value = aComboBox.getSelectedItem();
        if (value instanceof String) {
            return (String)value;
        }
        if (value == null) {
            return null;
        }
        return String.valueOf(value);
    }

    static Integer getNumericValue(JComboBox aTextField) {
        if (aTextField == null) {
            return null;
        }
        Object value = aTextField.getSelectedItem();
        if (value == null) {
            return null;
        }
        return NumberUtils.smartParseInt((String)String.valueOf(value));
    }

    static Integer getNumericValue(JTextField aTextField) {
        if (aTextField == null) {
            return null;
        }
        String value = aTextField.getText();
        if (value == null) {
            return null;
        }
        return NumberUtils.smartParseInt((String)value);
    }

    static void updateCaptureSpeedComboBoxModel(JComboBox aComboBox, DeviceProfile aProfile) {
        Vector<Integer> sampleRates = new Vector<Integer>(Arrays.asList(aProfile.getSampleRates()));
        if (aProfile.isDoubleDataRateSupported()) {
            sampleRates.add(0, 2 * aProfile.getClockspeed());
        }
        ConfigDialogHelper.updateComboBoxModel(aComboBox, sampleRates);
    }

    static void updateChannelGroups(JCheckBox[] aChannelGroups, DeviceProfile aProfile) {
        assert (aChannelGroups != null) : "Channel groups cannot be null!";
        assert (aChannelGroups.length == 4) : "There should be 4 channel groups!";
        int channelGroups = aProfile.getChannelGroupCount();
        for (int i = 0; i < aChannelGroups.length; ++i) {
            boolean enabled = i < channelGroups;
            ConfigDialogHelper.updateCheckBoxState(aChannelGroups[i], enabled);
        }
    }

    static void updateCheckBoxState(JCheckBox aCheckBox, boolean aEnabled) {
        if (!aEnabled) {
            aCheckBox.setSelected(false);
        }
        aCheckBox.setEnabled(aEnabled);
    }

    static <T> void updateComboBoxModel(JComboBox aComboBox, T ... aValues) {
        aComboBox.setModel(new DefaultComboBoxModel<T>(aValues));
    }

    static <T> void updateComboBoxModel(JComboBox aComboBox, Vector<T> aValues) {
        aComboBox.setModel(new DefaultComboBoxModel<T>(aValues));
    }

    static void updateTriggerChannels(JCheckBox[][] aTriggerMasks, JCheckBox[][] aTriggerValues, DeviceProfile aProfile) {
        assert (aTriggerMasks != null) : "Trigger masks cannot be null!";
        assert (aTriggerValues != null) : "Trigger values cannot be null!";
        assert (aTriggerMasks.length == aTriggerValues.length) : "Trigger values length should match Trigger masks length";
        assert (aTriggerMasks.length == 4) : "There should be 4 trigger stages";
        int maxStages = aProfile.getTriggerStages();
        int maxChannels = aProfile.getChannelCount();
        int stageCount = aTriggerMasks.length;
        for (int i = 0; i < stageCount; ++i) {
            boolean stageEnabled = i < maxStages;
            JCheckBox[] triggerMasks = aTriggerMasks[i];
            JCheckBox[] triggerValues = aTriggerValues[i];
            assert (triggerMasks.length == triggerValues.length);
            assert (triggerMasks.length == 32);
            for (int j = 0; j < 32; ++j) {
                boolean triggerEnabled = stageEnabled && j < maxChannels;
                ConfigDialogHelper.updateCheckBoxState(triggerMasks[j], triggerEnabled);
            }
        }
    }

    static void updateTriggerTypeComboBoxModel(JComboBox aComboBox, DeviceProfile aProfile) {
        boolean complexTriggersSupported = aProfile.isComplexTriggersSupported();
        DeviceProfile.TriggerType[] values = complexTriggersSupported ? DeviceProfile.TriggerType.values() : new DeviceProfile.TriggerType[]{DeviceProfile.TriggerType.SIMPLE};
        ConfigDialogHelper.updateComboBoxModel(aComboBox, values);
        if (!complexTriggersSupported) {
            aComboBox.setSelectedItem((Object)DeviceProfile.TriggerType.SIMPLE);
        }
        aComboBox.setEnabled(aProfile.isTriggerSupported());
    }
}

